/*
 * Decompiled with CFR 0.152.
 */
package squants.space;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.MagneticFlux;
import squants.electro.MagneticFluxDensity;
import squants.electro.Webers$;
import squants.energy.Power;
import squants.energy.Watts$;
import squants.mass.AreaDensity;
import squants.mass.Mass;
import squants.motion.Force;
import squants.motion.Newtons$;
import squants.motion.Pressure;
import squants.package$;
import squants.photo.Candelas$;
import squants.photo.Illuminance;
import squants.photo.Lumens$;
import squants.photo.Luminance;
import squants.photo.LuminousFlux;
import squants.photo.LuminousIntensity;
import squants.radio.Irradiance;
import squants.radio.Radiance;
import squants.radio.RadiantIntensity;
import squants.radio.WattsPerSteradian$;
import squants.space.Acres$;
import squants.space.Area$;
import squants.space.AreaUnit;
import squants.space.Barnes$;
import squants.space.CubicFeet$;
import squants.space.CubicInches$;
import squants.space.CubicMeters$;
import squants.space.CubicUsMiles$;
import squants.space.CubicYards$;
import squants.space.Feet$;
import squants.space.Hectares$;
import squants.space.Inches$;
import squants.space.Length;
import squants.space.Meters$;
import squants.space.SquareCentimeters$;
import squants.space.SquareFeet$;
import squants.space.SquareInches$;
import squants.space.SquareKilometers$;
import squants.space.SquareMeters$;
import squants.space.SquareUsMiles$;
import squants.space.SquareYards$;
import squants.space.UsMiles$;
import squants.space.Volume;
import squants.space.Yards$;

@ScalaSignature(bytes="\u0006\u0001\t%a\u0001B\u0001\u0003\u0005\u001d\u0011A!\u0011:fC*\u00111\u0001B\u0001\u0006gB\f7-\u001a\u0006\u0002\u000b\u000591/];b]R\u001c8\u0001A\n\u0003\u0001!\u00012!\u0003\u0006\r\u001b\u0005!\u0011BA\u0006\u0005\u0005!\tV/\u00198uSRL\bCA\u0007\u0001\u001b\u0005\u0011\u0001\u0002C\b\u0001\u0005\u000b\u0007I\u0011\u0001\t\u0002\u000bY\fG.^3\u0016\u0003E\u0001\"AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\u0011a\u0001R8vE2,\u0007\u0002\u0003\r\u0001\u0005\u0003\u0005\u000b\u0011B\t\u0002\rY\fG.^3!\u0011!Q\u0002A!b\u0001\n\u0003Y\u0012\u0001B;oSR,\u0012\u0001\b\t\u0003\u001buI!A\b\u0002\u0003\u0011\u0005\u0013X-Y+oSRD\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0006k:LG\u000f\t\u0005\u0006E\u0001!IaI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071!S\u0005C\u0003\u0010C\u0001\u0007\u0011\u0003C\u0003\u001bC\u0001\u0007A\u0004C\u0003(\u0001\u0011\u0005\u0001&A\u0005eS6,gn]5p]V\t\u0011F\u0004\u0002\u000eU\u001d)1F\u0001E\u0001Y\u0005!\u0011I]3b!\tiQFB\u0003\u0002\u0005!\u0005af\u0005\u0003._I*\u0004C\u0001\n1\u0013\t\t4C\u0001\u0004B]f\u0014VM\u001a\t\u0004\u0013Mb\u0011B\u0001\u001b\u0005\u0005%!\u0015.\\3og&|g\u000e\u0005\u0002\u0013m%\u0011qg\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006E5\"\t!\u000f\u000b\u0002Y!11(\fC\u0001\u0005q\nQ!\u00199qYf,\"!P(\u0015\u0007yB&\f\u0006\u0002\r\u007f!)\u0001I\u000fa\u0002\u0003\u0006\u0019a.^7\u0011\u0007\tSUJ\u0004\u0002D\u0011:\u0011AiR\u0007\u0002\u000b*\u0011aIB\u0001\u0007yI|w\u000e\u001e \n\u0003QI!!S\n\u0002\u000fA\f7m[1hK&\u00111\n\u0014\u0002\b\u001dVlWM]5d\u0015\tI5\u0003\u0005\u0002O\u001f2\u0001A!\u0002);\u0005\u0004\t&!A!\u0012\u0005I+\u0006C\u0001\nT\u0013\t!6CA\u0004O_RD\u0017N\\4\u0011\u0005I1\u0016BA,\u0014\u0005\r\te.\u001f\u0005\u00063j\u0002\r!T\u0001\u0002]\")!D\u000fa\u00019!)1(\fC\u00019R\u0011Ql\u0019\t\u0004=\u0006dQ\"A0\u000b\u0005\u0001\u001c\u0012\u0001B;uS2L!AY0\u0003\u0007Q\u0013\u0018\u0010C\u0003\u00107\u0002\u0007Q\u000bC\u0003f[\u0011\u0005a-\u0001\u0003oC6,W#A4\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017\u0001\u00027b]\u001eT\u0011\u0001\\\u0001\u0005U\u00064\u0018-\u0003\u0002oS\n11\u000b\u001e:j]\u001eDQ\u0001]\u0017\u0005\u0002E\f1\u0002\u001d:j[\u0006\u0014\u00180\u00168jiV\t!O\u0004\u0002\u000eg&\u0011AOA\u0001\r'F,\u0018M]3NKR,'o\u001d\u0005\u0006m6\"\t!]\u0001\u0007g&,f.\u001b;\t\u000balC\u0011A=\u0002\u000bUt\u0017\u000e^:\u0016\u0003i\u0004Ra_A\u0001\u0003\u000bi\u0011\u0001 \u0006\u0003{z\f\u0011\"[7nkR\f'\r\\3\u000b\u0005}\u001c\u0012AC2pY2,7\r^5p]&\u0019\u00111\u0001?\u0003\u0007M+G\u000f\u0005\u0003\n\u0003\u000fa\u0011bAA\u0005\t\tiQK\\5u\u001f\u001alU-Y:ve\u0016D\u0011\"!\u0004.\u0003\u0003%I!a\u0004\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003#\u00012\u0001[A\n\u0013\r\t)\"\u001b\u0002\u0007\u001f\nTWm\u0019;\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c\u00051A\u0005^5nKN$B!!\b\u0002$A\u0019Q\"a\b\n\u0007\u0005\u0005\"A\u0001\u0004W_2,X.\u001a\u0005\t\u0003K\t9\u00021\u0001\u0002(\u0005!A\u000f[1u!\ri\u0011\u0011F\u0005\u0004\u0003W\u0011!A\u0002'f]\u001e$\b\u000eC\u0004\u0002\u001a\u0001!\t!a\f\u0015\t\u0005E\u0012\u0011\t\t\u0005\u0003g\tYD\u0004\u0003\u00026\u0005ebb\u0001#\u00028%\tQ!\u0003\u0002J\t%!\u0011QHA \u0005\u0011i\u0015m]:\u000b\u0005%#\u0001\u0002CA\u0013\u0003[\u0001\r!a\u0011\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013\u0005\u0003\u0011i\u0017m]:\n\t\u00055\u0013q\t\u0002\f\u0003J,\u0017\rR3og&$\u0018\u0010C\u0004\u0002\u001a\u0001!\t!!\u0015\u0015\t\u0005M\u0013\u0011\f\t\u0005\u0003g\t)&\u0003\u0003\u0002X\u0005}\"!\u0002$pe\u000e,\u0007\u0002CA\u0013\u0003\u001f\u0002\r!a\u0017\u0011\t\u0005u\u00131M\u0007\u0003\u0003?R1!!\u0019\u0005\u0003\u0019iw\u000e^5p]&!\u0011QMA0\u0005!\u0001&/Z:tkJ,\u0007bBA\r\u0001\u0011\u0005\u0011\u0011\u000e\u000b\u0005\u0003W\n9\b\u0005\u0003\u0002n\u0005MTBAA8\u0015\r\t\t\bB\u0001\u0006a\"|Go\\\u0005\u0005\u0003k\nyG\u0001\u0007Mk6Lgn\\;t\r2,\b\u0010\u0003\u0005\u0002&\u0005\u001d\u0004\u0019AA=!\u0011\ti'a\u001f\n\t\u0005u\u0014q\u000e\u0002\f\u00132dW/\\5oC:\u001cW\rC\u0004\u0002\u001a\u0001!\t!!!\u0015\t\u0005\r\u0015\u0011\u0012\t\u0005\u0003[\n))\u0003\u0003\u0002\b\u0006=$!\u0005'v[&tw.^:J]R,gn]5us\"A\u0011QEA@\u0001\u0004\tY\t\u0005\u0003\u0002n\u00055\u0015\u0002BAH\u0003_\u0012\u0011\u0002T;nS:\fgnY3\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u0014R!\u0011QSAQ!\u0011\t9*!(\u000e\u0005\u0005e%bAAN\t\u00059Q\r\\3diJ|\u0017\u0002BAP\u00033\u0013A\"T1h]\u0016$\u0018n\u0019$mkbD\u0001\"!\n\u0002\u0012\u0002\u0007\u00111\u0015\t\u0005\u0003/\u000b)+\u0003\u0003\u0002(\u0006e%aE'bO:,G/[2GYVDH)\u001a8tSRL\bbBA\r\u0001\u0011\u0005\u00111\u0016\u000b\u0005\u0003[\u000b\u0019\f\u0005\u0003\u00024\u0005=\u0016\u0002BAY\u0003\u007f\u0011Q\u0001U8xKJD\u0001\"!\n\u0002*\u0002\u0007\u0011Q\u0017\t\u0005\u0003o\u000bi,\u0004\u0002\u0002:*\u0019\u00111\u0018\u0003\u0002\u000bI\fG-[8\n\t\u0005}\u0016\u0011\u0018\u0002\u000b\u0013J\u0014\u0018\rZ5b]\u000e,\u0007bBA\r\u0001\u0011\u0005\u00111\u0019\u000b\u0005\u0003\u000b\fY\r\u0005\u0003\u00028\u0006\u001d\u0017\u0002BAe\u0003s\u0013\u0001CU1eS\u0006tG/\u00138uK:\u001c\u0018\u000e^=\t\u0011\u0005\u0015\u0012\u0011\u0019a\u0001\u0003\u001b\u0004B!a.\u0002P&!\u0011\u0011[A]\u0005!\u0011\u0016\rZ5b]\u000e,\u0007bBAk\u0001\u0011\u0005\u0011q[\u0001\u0005I\u0011Lg\u000f\u0006\u0003\u0002(\u0005e\u0007\u0002CA\u0013\u0003'\u0004\r!a\n\t\u000f\u0005u\u0007\u0001\"\u0001\u0002`\u0006Q1/];be\u0016\u0014vn\u001c;\u0016\u0005\u0005\u001d\u0002BBAr\u0001\u0011\u0005\u0001#\u0001\bu_N\u000bX/\u0019:f\u001b\u0016$XM]:\t\r\u0005\u001d\b\u0001\"\u0001\u0011\u0003M!xnU9vCJ,7)\u001a8uS6,G/\u001a:t\u0011\u0019\tY\u000f\u0001C\u0001!\u0005\u0011Bo\\*rk\u0006\u0014XmS5m_6,G/\u001a:t\u0011\u0019\ty\u000f\u0001C\u0001!\u0005yAo\\*rk\u0006\u0014X-V:NS2,7\u000f\u0003\u0004\u0002t\u0002!\t\u0001E\u0001\u000ei>\u001c\u0016/^1sKf\u000b'\u000fZ:\t\r\u0005]\b\u0001\"\u0001\u0011\u00031!xnU9vCJ,g)Z3u\u0011\u0019\tY\u0010\u0001C\u0001!\u0005qAo\\*rk\u0006\u0014X-\u00138dQ\u0016\u001c\bBBA\u0000\u0001\u0011\u0005\u0001#\u0001\u0006u_\"+7\r^1sKNDaAa\u0001\u0001\t\u0003\u0001\u0012a\u0002;p\u0003\u000e\u0014Xm\u001d\u0005\u0007\u0005\u000f\u0001A\u0011\u0001\t\u0002\u0011Q|')\u0019:oKN\u0004")
public final class Area
extends Quantity<Area> {
    private final double value;
    private final AreaUnit unit;

    public static <N> Try<Area> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Area$.MODULE$.parseTuple(tuple2, numeric);
    }

    public static Try<Area> parseString(String string) {
        return Area$.MODULE$.parseString(string);
    }

    public static Option<UnitOfMeasure<Area>> symbolToUnit(String string) {
        return Area$.MODULE$.symbolToUnit(string);
    }

    public static /* bridge */ UnitOfMeasure siUnit() {
        return Area$.MODULE$.siUnit();
    }

    public static /* bridge */ UnitOfMeasure primaryUnit() {
        return Area$.MODULE$.primaryUnit();
    }

    public static Set<UnitOfMeasure<Area>> units() {
        return Area$.MODULE$.units();
    }

    public static SquareMeters$ siUnit() {
        return Area$.MODULE$.siUnit();
    }

    public static SquareMeters$ primaryUnit() {
        return Area$.MODULE$.primaryUnit();
    }

    public static String name() {
        return Area$.MODULE$.name();
    }

    public static Try<Area> apply(Object object) {
        return Area$.MODULE$.apply(object);
    }

    @Override
    public double value() {
        return this.value;
    }

    public AreaUnit unit() {
        return this.unit;
    }

    public Area$ dimension() {
        return Area$.MODULE$;
    }

    public Volume $times(Length that) {
        AreaUnit areaUnit = this.unit();
        Quantity quantity = SquareUsMiles$.MODULE$.equals(areaUnit) ? CubicUsMiles$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() * that.toUsMiles())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (SquareYards$.MODULE$.equals(areaUnit) ? CubicYards$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() * that.toYards())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (SquareFeet$.MODULE$.equals(areaUnit) ? CubicFeet$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() * that.toFeet())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (SquareInches$.MODULE$.equals(areaUnit) ? CubicInches$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() * that.toInches())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : CubicMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() * that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$))));
        return quantity;
    }

    public Mass $times(AreaDensity that) {
        return package$.MODULE$.Kilograms().apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() * that.toKilogramsPerSquareMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Force $times(Pressure that) {
        return Newtons$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() * that.toPascals())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public LuminousFlux $times(Illuminance that) {
        return Lumens$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() * that.toLux())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public LuminousIntensity $times(Luminance that) {
        return Candelas$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() * that.toCandelasPerSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public MagneticFlux $times(MagneticFluxDensity that) {
        return Webers$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() * that.toTeslas())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Power $times(Irradiance that) {
        return Watts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() * that.toWattsPerSquareMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public RadiantIntensity $times(Radiance that) {
        return WattsPerSteradian$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() * that.toWattsPerSteradianPerSquareMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Length $div(Length that) {
        AreaUnit areaUnit = this.unit();
        Quantity quantity = SquareUsMiles$.MODULE$.equals(areaUnit) ? UsMiles$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() / that.toUsMiles())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (SquareYards$.MODULE$.equals(areaUnit) ? Yards$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() / that.toYards())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (SquareFeet$.MODULE$.equals(areaUnit) ? Feet$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() / that.toFeet())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : (SquareInches$.MODULE$.equals(areaUnit) ? Inches$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.value() / that.toInches())), (Numeric)Numeric.DoubleIsFractional$.MODULE$) : Meters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSquareMeters() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$))));
        return quantity;
    }

    public Length squareRoot() {
        return Meters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)scala.math.package$.MODULE$.sqrt(this.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toSquareMeters() {
        return this.to(SquareMeters$.MODULE$);
    }

    public double toSquareCentimeters() {
        return this.to(SquareCentimeters$.MODULE$);
    }

    public double toSquareKilometers() {
        return this.to(SquareKilometers$.MODULE$);
    }

    public double toSquareUsMiles() {
        return this.to(SquareUsMiles$.MODULE$);
    }

    public double toSquareYards() {
        return this.to(SquareYards$.MODULE$);
    }

    public double toSquareFeet() {
        return this.to(SquareFeet$.MODULE$);
    }

    public double toSquareInches() {
        return this.to(SquareInches$.MODULE$);
    }

    public double toHectares() {
        return this.to(Hectares$.MODULE$);
    }

    public double toAcres() {
        return this.to(Acres$.MODULE$);
    }

    public double toBarnes() {
        return this.to(Barnes$.MODULE$);
    }

    public Area(double value, AreaUnit unit) {
        this.value = value;
        this.unit = unit;
    }
}

