/*
 * Decompiled with CFR 0.152.
 */
package squants.motion;

import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.motion.Bars$;
import squants.motion.Force;
import squants.motion.InchesOfMercury$;
import squants.motion.MillimetersOfMercury$;
import squants.motion.Newtons$;
import squants.motion.Pascals$;
import squants.motion.PascalsPerSecond$;
import squants.motion.PoundsPerSquareInch$;
import squants.motion.Pressure$;
import squants.motion.PressureChange;
import squants.motion.PressureUnit;
import squants.motion.StandardAtmospheres$;
import squants.motion.Torrs$;
import squants.package$;
import squants.space.Area;
import squants.time.Frequency;
import squants.time.Time;
import squants.time.TimeIntegral;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0005\u001d\u0011\u0001\u0002\u0015:fgN,(/\u001a\u0006\u0003\u0007\u0011\ta!\\8uS>t'\"A\u0003\u0002\u000fM\fX/\u00198ug\u000e\u00011c\u0001\u0001\t\u001dA\u0019\u0011B\u0003\u0007\u000e\u0003\u0011I!a\u0003\u0003\u0003\u0011E+\u0018M\u001c;jif\u0004\"!\u0004\u0001\u000e\u0003\t\u00012a\u0004\n\u0015\u001b\u0005\u0001\"BA\t\u0005\u0003\u0011!\u0018.\\3\n\u0005M\u0001\"\u0001\u0004+j[\u0016Le\u000e^3he\u0006d\u0007CA\u0007\u0016\u0013\t1\"A\u0001\bQe\u0016\u001c8/\u001e:f\u0007\"\fgnZ3\t\u0011a\u0001!Q1A\u0005\u0002e\tQA^1mk\u0016,\u0012A\u0007\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\t>,(\r\\3\t\u0011\u0005\u0002!\u0011!Q\u0001\ni\taA^1mk\u0016\u0004\u0003\u0002C\u0012\u0001\u0005\u000b\u0007I\u0011\u0001\u0013\u0002\tUt\u0017\u000e^\u000b\u0002KA\u0011QBJ\u0005\u0003O\t\u0011A\u0002\u0015:fgN,(/Z+oSRD\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0006k:LG\u000f\t\u0005\u0006W\u0001!I\u0001L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071ic\u0006C\u0003\u0019U\u0001\u0007!\u0004C\u0003$U\u0001\u0007Q\u0005C\u00031\u0001\u0011\u0005\u0011'A\u0005eS6,gn]5p]V\t!G\u0004\u0002\u000eg\u001d)AG\u0001E\u0001k\u0005A\u0001K]3tgV\u0014X\r\u0005\u0002\u000em\u0019)\u0011A\u0001E\u0001oM!a\u0007O\u001e?!\tY\u0012(\u0003\u0002;9\t1\u0011I\\=SK\u001a\u00042!\u0003\u001f\r\u0013\tiDAA\u0005ES6,gn]5p]B\u00111dP\u0005\u0003\u0001r\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQa\u000b\u001c\u0005\u0002\t#\u0012!\u000e\u0005\u0007\tZ\"\tAA#\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\u0005\u0019CFcA$bGR\u0011A\u0002\u0013\u0005\u0006\u0013\u000e\u0003\u001dAS\u0001\u0004]Vl\u0007cA&T-:\u0011A*\u0015\b\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f\u001a\ta\u0001\u0010:p_Rt\u0014\"A\u000f\n\u0005Ic\u0012a\u00029bG.\fw-Z\u0005\u0003)V\u0013qAT;nKJL7M\u0003\u0002S9A\u0011q\u000b\u0017\u0007\u0001\t\u0015I6I1\u0001[\u0005\u0005\t\u0015CA._!\tYB,\u0003\u0002^9\t9aj\u001c;iS:<\u0007CA\u000e`\u0013\t\u0001GDA\u0002B]fDQAY\"A\u0002Y\u000b\u0011A\u001c\u0005\u0006G\r\u0003\r!\n\u0005\u0006\tZ\"\t!\u001a\u000b\u0003M2\u00042a\u001a6\r\u001b\u0005A'BA5\u001d\u0003\u0011)H/\u001b7\n\u0005-D'a\u0001+ss\")\u0001\u0004\u001aa\u0001=\")aN\u000eC\u0001_\u0006!a.Y7f+\u0005\u0001\bCA9w\u001b\u0005\u0011(BA:u\u0003\u0011a\u0017M\\4\u000b\u0003U\fAA[1wC&\u0011qO\u001d\u0002\u0007'R\u0014\u0018N\\4\t\u000be4D\u0011\u0001>\u0002\u0017A\u0014\u0018.\\1ssVs\u0017\u000e^\u000b\u0002w:\u0011Q\u0002`\u0005\u0003{\n\tq\u0001U1tG\u0006d7\u000fC\u0003\u0000m\u0011\u0005!0\u0001\u0004tSVs\u0017\u000e\u001e\u0005\b\u0003\u00071D\u0011AA\u0003\u0003\u0015)h.\u001b;t+\t\t9\u0001\u0005\u0004\u0002\n\u0005M\u0011qC\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003#a\u0012AC2pY2,7\r^5p]&!\u0011QCA\u0006\u0005\r\u0019V\r\u001e\t\u0005\u0013\u0005eA\"C\u0002\u0002\u001c\u0011\u0011Q\"\u00168ji>3W*Z1tkJ,\u0007\"CA\u0010m\u0005\u0005I\u0011BA\u0011\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\r\u0002cA9\u0002&%\u0019\u0011q\u0005:\u0003\r=\u0013'.Z2u\u0011\u001d\tY\u0003\u0001C)\u0003[\t1\u0002^5nK\u0012+'/\u001b<fIV\tA\u0003\u0003\u0004\u0012\u0001\u0011E\u0013\u0011G\u000b\u0003\u0003g\u0001B!!\u000e\u0002>9!\u0011qGA\u001e\u001d\ri\u0015\u0011H\u0005\u0002\u000b%\u0011!\u000bB\u0005\u0005\u0003\u007f\t\tE\u0001\u0003US6,'B\u0001*\u0005\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000f\na\u0001\n;j[\u0016\u001cH\u0003BA%\u0003\u001f\u00022!DA&\u0013\r\tiE\u0001\u0002\u0006\r>\u00148-\u001a\u0005\t\u0003#\n\u0019\u00051\u0001\u0002T\u0005!A\u000f[1u!\u0011\t)$!\u0016\n\t\u0005]\u0013\u0011\t\u0002\u0005\u0003J,\u0017\rC\u0004\u0002F\u0001!\t!a\u0017\u0015\u0007m\u000bi\u0006\u0003\u0005\u0002R\u0005e\u0003\u0019AA\u001a\u0011\u0019\t\t\u0007\u0001C\u00013\u0005IAo\u001c)bg\u000e\fGn\u001d\u0005\u0007\u0003K\u0002A\u0011A\r\u0002\rQ|')\u0019:t\u0011\u0019\tI\u0007\u0001C\u00013\u0005)Bo\u001c)pk:$7\u000fU3s'F,\u0018M]3J]\u000eD\u0007BBA7\u0001\u0011\u0005\u0011$A\u000bu_N#\u0018M\u001c3be\u0012\fE/\\8ta\",'/Z:\t\r\u0005E\u0004\u0001\"\u0001\u001a\u0003Y!x.T5mY&lW\r^3sg>3W*\u001a:dkJL\bBBA;\u0001\u0011\u0005\u0011$A\tu_&s7\r[3t\u001f\u001alUM]2vefDa!!\u001f\u0001\t\u0003I\u0012A\u0002;p)>\u0014(\u000f")
public final class Pressure
extends Quantity<Pressure>
implements TimeIntegral<PressureChange> {
    private final double value;
    private final PressureUnit unit;

    public static <N> Try<Pressure> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Pressure$.MODULE$.parseTuple(tuple2, numeric);
    }

    public static Try<Pressure> parseString(String string) {
        return Pressure$.MODULE$.parseString(string);
    }

    public static Option<UnitOfMeasure<Pressure>> symbolToUnit(String string) {
        return Pressure$.MODULE$.symbolToUnit(string);
    }

    public static /* bridge */ UnitOfMeasure siUnit() {
        return Pressure$.MODULE$.siUnit();
    }

    public static /* bridge */ UnitOfMeasure primaryUnit() {
        return Pressure$.MODULE$.primaryUnit();
    }

    public static Set<UnitOfMeasure<Pressure>> units() {
        return Pressure$.MODULE$.units();
    }

    public static Pascals$ siUnit() {
        return Pressure$.MODULE$.siUnit();
    }

    public static Pascals$ primaryUnit() {
        return Pressure$.MODULE$.primaryUnit();
    }

    public static String name() {
        return Pressure$.MODULE$.name();
    }

    public static Try<Pressure> apply(Object object) {
        return Pressure$.MODULE$.apply(object);
    }

    @Override
    public Quantity $div(Time that) {
        return TimeIntegral.$div$((TimeIntegral)this, that);
    }

    @Override
    public Quantity per(Time that) {
        return TimeIntegral.per$(this, that);
    }

    @Override
    public Time $div(Quantity that) {
        return TimeIntegral.$div$((TimeIntegral)this, that);
    }

    @Override
    public Quantity $times(Frequency that) {
        return TimeIntegral.$times$(this, that);
    }

    @Override
    public double value() {
        return this.value;
    }

    public PressureUnit unit() {
        return this.unit;
    }

    public Pressure$ dimension() {
        return Pressure$.MODULE$;
    }

    @Override
    public PressureChange timeDerived() {
        return PascalsPerSecond$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toPascals()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return package$.MODULE$.Seconds().apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Force $times(Area that) {
        return Newtons$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toPascals() * that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Nothing$ $times(Time that) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public double toPascals() {
        return this.to(Pascals$.MODULE$);
    }

    public double toBars() {
        return this.to(Bars$.MODULE$);
    }

    public double toPoundsPerSquareInch() {
        return this.to(PoundsPerSquareInch$.MODULE$);
    }

    public double toStandardAtmospheres() {
        return this.to(StandardAtmospheres$.MODULE$);
    }

    public double toMillimetersOfMercury() {
        return this.to(MillimetersOfMercury$.MODULE$);
    }

    public double toInchesOfMercury() {
        return this.to(InchesOfMercury$.MODULE$);
    }

    public double toTorr() {
        return this.to(Torrs$.MODULE$);
    }

    public Pressure(double value, PressureUnit unit) {
        this.value = value;
        this.unit = unit;
        TimeIntegral.$init$(this);
    }
}

