/*
 * Decompiled with CFR 0.152.
 */
package squants.motion;

import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.energy.Energy;
import squants.energy.Joules$;
import squants.mass.Kilograms$;
import squants.mass.Mass;
import squants.motion.Acceleration;
import squants.motion.Force$;
import squants.motion.ForceUnit;
import squants.motion.KilogramForce$;
import squants.motion.MetersPerSecondSquared$;
import squants.motion.Momentum;
import squants.motion.NewtonSeconds$;
import squants.motion.Newtons$;
import squants.motion.NewtonsPerSecond$;
import squants.motion.Pascals$;
import squants.motion.PoundForce$;
import squants.motion.Pressure;
import squants.motion.Yank;
import squants.space.Area;
import squants.space.Length;
import squants.space.SquareMeters$;
import squants.time.Frequency;
import squants.time.Seconds$;
import squants.time.Time;
import squants.time.TimeDerivative;
import squants.time.TimeIntegral;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u0001\u0003\u0005\u001d\u0011QAR8sG\u0016T!a\u0001\u0003\u0002\r5|G/[8o\u0015\u0005)\u0011aB:rk\u0006tGo]\u0002\u0001'\u0011\u0001\u0001BD\f\u0011\u0007%QA\"D\u0001\u0005\u0013\tYAA\u0001\u0005Rk\u0006tG/\u001b;z!\ti\u0001!D\u0001\u0003!\ry!\u0003F\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0005i&lW-\u0003\u0002\u0014!\tqA+[7f\t\u0016\u0014\u0018N^1uSZ,\u0007CA\u0007\u0016\u0013\t1\"A\u0001\u0005N_6,g\u000e^;n!\ry\u0001DG\u0005\u00033A\u0011A\u0002V5nK&sG/Z4sC2\u0004\"!D\u000e\n\u0005q\u0011!\u0001B-b].D\u0001B\b\u0001\u0003\u0006\u0004%\taH\u0001\u0006m\u0006dW/Z\u000b\u0002AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1Ai\\;cY\u0016D\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0007m\u0006dW/\u001a\u0011\t\u0011%\u0002!Q1A\u0005\u0002)\nA!\u001e8jiV\t1\u0006\u0005\u0002\u000eY%\u0011QF\u0001\u0002\n\r>\u00148-Z+oSRD\u0001b\f\u0001\u0003\u0002\u0003\u0006IaK\u0001\u0006k:LG\u000f\t\u0005\u0006c\u0001!IAM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071\u0019D\u0007C\u0003\u001fa\u0001\u0007\u0001\u0005C\u0003*a\u0001\u00071\u0006C\u00037\u0001\u0011\u0005q'A\u0005eS6,gn]5p]V\t\u0001H\u0004\u0002\u000es\u001d)!H\u0001E\u0001w\u0005)ai\u001c:dKB\u0011Q\u0002\u0010\u0004\u0006\u0003\tA\t!P\n\u0005yy\nE\t\u0005\u0002\"\u007f%\u0011\u0001I\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0007%\u0011E\"\u0003\u0002D\t\tIA)[7f]NLwN\u001c\t\u0003C\u0015K!A\u0012\u0012\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000bEbD\u0011\u0001%\u0015\u0003mBaA\u0013\u001f\u0005\u0002\tY\u0015!B1qa2LXC\u0001'_)\riu-\u001b\u000b\u0003\u00199CQaT%A\u0004A\u000b1A\\;n!\r\t\u0016\f\u0018\b\u0003%^s!a\u0015,\u000e\u0003QS!!\u0016\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013B\u0001-#\u0003\u001d\u0001\u0018mY6bO\u0016L!AW.\u0003\u000f9+X.\u001a:jG*\u0011\u0001L\t\t\u0003;zc\u0001\u0001B\u0003`\u0013\n\u0007\u0001MA\u0001B#\t\tG\r\u0005\u0002\"E&\u00111M\t\u0002\b\u001d>$\b.\u001b8h!\t\tS-\u0003\u0002gE\t\u0019\u0011I\\=\t\u000b!L\u0005\u0019\u0001/\u0002\u00039DQ!K%A\u0002-BQA\u0013\u001f\u0005\u0002-$\"\u0001\u001c:\u0011\u00075\u0004H\"D\u0001o\u0015\ty'%\u0001\u0003vi&d\u0017BA9o\u0005\r!&/\u001f\u0005\u0006=)\u0004\r\u0001\u001a\u0005\u0006ir\"\t!^\u0001\u0005]\u0006lW-F\u0001w!\t9H0D\u0001y\u0015\tI(0\u0001\u0003mC:<'\"A>\u0002\t)\fg/Y\u0005\u0003{b\u0014aa\u0015;sS:<\u0007BB@=\t\u0003\t\t!A\u0006qe&l\u0017M]=V]&$XCAA\u0002\u001d\ri\u0011QA\u0005\u0004\u0003\u000f\u0011\u0011a\u0002(foR|gn\u001d\u0005\b\u0003\u0017aD\u0011AA\u0001\u0003\u0019\u0019\u0018.\u00168ji\"9\u0011q\u0002\u001f\u0005\u0002\u0005E\u0011!B;oSR\u001cXCAA\n!\u0019\t)\"a\b\u0002$5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"A\u0005j[6,H/\u00192mK*\u0019\u0011Q\u0004\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\"\u0005]!aA*fiB!\u0011\"!\n\r\u0013\r\t9\u0003\u0002\u0002\u000e+:LGo\u00144NK\u0006\u001cXO]3\t\u0013\u0005-B(!A\u0005\n\u00055\u0012a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\f\u0011\u0007]\f\t$C\u0002\u00024a\u0014aa\u00142kK\u000e$\b\u0002CA\u001c\u0001\u0011EA!!\u000f\u0002\u001dQLW.Z%oi\u0016<'/\u0019;fIV\tA\u0003C\u0004\u0002>\u0001!\t\"a\u0010\u0002\u0017QLW.\u001a#fe&4X\rZ\u000b\u00025!1\u0011\u0003\u0001C!\u0003\u0007*\"!!\u0012\u0011\u0007=\t9%C\u0002\u0002JA\u0011A\u0001V5nK\"9\u0011Q\n\u0001\u0005\u0002\u0005=\u0013A\u0002\u0013uS6,7\u000f\u0006\u0003\u0002R\u0005\u0005\u0004\u0003BA*\u00037rA!!\u0016\u0002Z9\u00191+a\u0016\n\u0003\u0015I!\u0001\u0017\u0003\n\t\u0005u\u0013q\f\u0002\u0007\u000b:,'oZ=\u000b\u0005a#\u0001\u0002CA2\u0003\u0017\u0002\r!!\u001a\u0002\tQD\u0017\r\u001e\t\u0005\u0003'\n9'\u0003\u0003\u0002j\u0005}#A\u0002'f]\u001e$\b\u000eC\u0004\u0002n\u0001!\t!a\u001c\u0002\t\u0011\"\u0017N\u001e\u000b\u0004C\u0006E\u0004\u0002CA2\u0003W\u0002\r!!\u001a\t\u000f\u00055\u0004\u0001\"\u0001\u0002vQ!\u0011qOA?!\ri\u0011\u0011P\u0005\u0004\u0003w\u0012!\u0001D!dG\u0016dWM]1uS>t\u0007\u0002CA2\u0003g\u0002\r!a \u0011\t\u0005M\u0013\u0011Q\u0005\u0005\u0003\u0007\u000byF\u0001\u0003NCN\u001c\bbBA7\u0001\u0011\u0005\u0011q\u0011\u000b\u0005\u0003\u007f\nI\t\u0003\u0005\u0002d\u0005\u0015\u0005\u0019AA<\u0011\u001d\ti\u0007\u0001C\u0001\u0003\u001b#B!a$\u0002\u0016B\u0019Q\"!%\n\u0007\u0005M%A\u0001\u0005Qe\u0016\u001c8/\u001e:f\u0011!\t\u0019'a#A\u0002\u0005]\u0005\u0003BA*\u00033KA!a'\u0002`\t!\u0011I]3b\u0011\u001d\ti\u0007\u0001C\u0001\u0003?#B!a&\u0002\"\"A\u00111MAO\u0001\u0004\ty\t\u0003\u0004\u0002&\u0002!\taH\u0001\ni>tUm\u001e;p]NDa!!+\u0001\t\u0003y\u0012a\u0004;p\u0017&dwn\u001a:b[\u001a{'oY3\t\r\u00055\u0006\u0001\"\u0001 \u00031!x\u000eU8v]\u00124uN]2f\u0001")
public final class Force
extends Quantity<Force>
implements TimeDerivative<Momentum>,
TimeIntegral<Yank> {
    private final double value;
    private final ForceUnit unit;

    public static <N> Try<Force> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Force$.MODULE$.parseTuple(tuple2, numeric);
    }

    public static Try<Force> parseString(String string) {
        return Force$.MODULE$.parseString(string);
    }

    public static Option<UnitOfMeasure<Force>> symbolToUnit(String string) {
        return Force$.MODULE$.symbolToUnit(string);
    }

    public static /* bridge */ UnitOfMeasure siUnit() {
        return Force$.MODULE$.siUnit();
    }

    public static /* bridge */ UnitOfMeasure primaryUnit() {
        return Force$.MODULE$.primaryUnit();
    }

    public static Set<UnitOfMeasure<Force>> units() {
        return Force$.MODULE$.units();
    }

    public static Newtons$ siUnit() {
        return Force$.MODULE$.siUnit();
    }

    public static Newtons$ primaryUnit() {
        return Force$.MODULE$.primaryUnit();
    }

    public static String name() {
        return Force$.MODULE$.name();
    }

    public static Try<Force> apply(Object object) {
        return Force$.MODULE$.apply(object);
    }

    @Override
    public Quantity $div(Time that) {
        return TimeIntegral.$div$((TimeIntegral)this, that);
    }

    @Override
    public Quantity per(Time that) {
        return TimeIntegral.per$(this, that);
    }

    @Override
    public Time $div(Quantity that) {
        return TimeIntegral.$div$((TimeIntegral)this, that);
    }

    @Override
    public Quantity $times(Frequency that) {
        return TimeIntegral.$times$(this, that);
    }

    @Override
    public Quantity $times(Time that) {
        return TimeDerivative.$times$(this, that);
    }

    @Override
    public double value() {
        return this.value;
    }

    public ForceUnit unit() {
        return this.unit;
    }

    public Force$ dimension() {
        return Force$.MODULE$;
    }

    @Override
    public Momentum timeIntegrated() {
        return NewtonSeconds$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toNewtons()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Yank timeDerived() {
        return NewtonsPerSecond$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toNewtons()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Seconds$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Energy $times(Length that) {
        return Joules$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toNewtons() * that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Nothing$ $div(Length that) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Acceleration $div(Mass that) {
        return MetersPerSecondSquared$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toNewtons() / that.toKilograms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Mass $div(Acceleration that) {
        return Kilograms$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toNewtons() / that.toMetersPerSecondSquared())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Pressure $div(Area that) {
        return Pascals$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toNewtons() / that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Area $div(Pressure that) {
        return SquareMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toNewtons() / that.toPascals())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toNewtons() {
        return this.to(Newtons$.MODULE$);
    }

    public double toKilogramForce() {
        return this.to(KilogramForce$.MODULE$);
    }

    public double toPoundForce() {
        return this.to(PoundForce$.MODULE$);
    }

    public Force(double value, ForceUnit unit) {
        this.value = value;
        this.unit = unit;
        TimeDerivative.$init$(this);
        TimeIntegral.$init$(this);
    }
}

