/*
 * Decompiled with CFR 0.152.
 */
package squants.motion;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.mass.Mass;
import squants.motion.Acceleration$;
import squants.motion.AccelerationUnit;
import squants.motion.EarthGravities$;
import squants.motion.FeetPerSecondSquared$;
import squants.motion.Force;
import squants.motion.Jerk;
import squants.motion.MetersPerSecond$;
import squants.motion.MetersPerSecondCubed$;
import squants.motion.MetersPerSecondSquared$;
import squants.motion.MillimetersPerSecondSquared$;
import squants.motion.Newtons$;
import squants.motion.UsMilesPerHourSquared$;
import squants.motion.Velocity;
import squants.space.Length;
import squants.time.Frequency;
import squants.time.SecondTimeDerivative;
import squants.time.Seconds$;
import squants.time.Time;
import squants.time.TimeDerivative;
import squants.time.TimeIntegral;
import squants.time.TimeSquared;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001B\u0001\u0003\u0005\u001d\u0011A\"Q2dK2,'/\u0019;j_:T!a\u0001\u0003\u0002\r5|G/[8o\u0015\u0005)\u0011aB:rk\u0006tGo]\u0002\u0001'\u0015\u0001\u0001BD\f'!\rI!\u0002D\u0007\u0002\t%\u00111\u0002\u0002\u0002\t#V\fg\u000e^5usB\u0011Q\u0002A\u0007\u0002\u0005A\u0019qB\u0005\u000b\u000e\u0003AQ!!\u0005\u0003\u0002\tQLW.Z\u0005\u0003'A\u0011a\u0002V5nK\u0012+'/\u001b<bi&4X\r\u0005\u0002\u000e+%\u0011aC\u0001\u0002\t-\u0016dwnY5usB\u0019q\u0002\u0007\u000e\n\u0005e\u0001\"\u0001F*fG>tG\rV5nK\u0012+'/\u001b<bi&4X\r\u0005\u0002\u001cG9\u0011A$\t\b\u0003;\u0001j\u0011A\b\u0006\u0003?\u0019\ta\u0001\u0010:p_Rt\u0014\"A\u0003\n\u0005\t\"\u0011a\u00029bG.\fw-Z\u0005\u0003I\u0015\u0012a\u0001T3oORD'B\u0001\u0012\u0005!\ryq%K\u0005\u0003QA\u0011A\u0002V5nK&sG/Z4sC2\u0004\"!\u0004\u0016\n\u0005-\u0012!\u0001\u0002&fe.D\u0001\"\f\u0001\u0003\u0006\u0004%\tAL\u0001\u0006m\u0006dW/Z\u000b\u0002_A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1Ai\\;cY\u0016D\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IaL\u0001\u0007m\u0006dW/\u001a\u0011\t\u0011a\u0002!Q1A\u0005\u0002e\nA!\u001e8jiV\t!\b\u0005\u0002\u000ew%\u0011AH\u0001\u0002\u0011\u0003\u000e\u001cW\r\\3sCRLwN\\+oSRD\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IAO\u0001\u0006k:LG\u000f\t\u0005\u0006\u0001\u0002!I!Q\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071\u00115\tC\u0003.\u007f\u0001\u0007q\u0006C\u00039\u007f\u0001\u0007!\bC\u0003F\u0001\u0011\u0005a)A\u0005eS6,gn]5p]V\tqI\u0004\u0002\u000e\u0011\u001e)\u0011J\u0001E\u0001\u0015\u0006a\u0011iY2fY\u0016\u0014\u0018\r^5p]B\u0011Qb\u0013\u0004\u0006\u0003\tA\t\u0001T\n\u0005\u00176\u00036\u000b\u0005\u00021\u001d&\u0011q*\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0007%\tF\"\u0003\u0002S\t\tIA)[7f]NLwN\u001c\t\u0003aQK!!V\u0019\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000b\u0001[E\u0011A,\u0015\u0003)Ca!W&\u0005\u0002\tQ\u0016!B1qa2LXCA.j)\ra&\u000f\u001e\u000b\u0003\u0019uCQA\u0018-A\u0004}\u000b1A\\;n!\r\u0001Gm\u001a\b\u0003C\u000et!!\b2\n\u0003IJ!AI\u0019\n\u0005\u00154'a\u0002(v[\u0016\u0014\u0018n\u0019\u0006\u0003EE\u0002\"\u0001[5\r\u0001\u0011)!\u000e\u0017b\u0001W\n\t\u0011)\u0005\u0002m_B\u0011\u0001'\\\u0005\u0003]F\u0012qAT8uQ&tw\r\u0005\u00021a&\u0011\u0011/\r\u0002\u0004\u0003:L\b\"B:Y\u0001\u00049\u0017!\u00018\t\u000baB\u0006\u0019\u0001\u001e\t\u000be[E\u0011\u0001<\u0015\u0005]l\bc\u0001=|\u00195\t\u0011P\u0003\u0002{c\u0005!Q\u000f^5m\u0013\ta\u0018PA\u0002UefDQ!L;A\u0002=Daa`&\u0005\u0002\u0005\u0005\u0011\u0001\u00028b[\u0016,\"!a\u0001\u0011\t\u0005\u0015\u0011qB\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005!A.\u00198h\u0015\t\ti!\u0001\u0003kCZ\f\u0017\u0002BA\t\u0003\u000f\u0011aa\u0015;sS:<\u0007bBA\u000b\u0017\u0012\u0005\u0011qC\u0001\faJLW.\u0019:z+:LG/\u0006\u0002\u0002\u001a9\u0019Q\"a\u0007\n\u0007\u0005u!!\u0001\fNKR,'o\u001d)feN+7m\u001c8e'F,\u0018M]3e\u0011\u001d\t\tc\u0013C\u0001\u0003/\taa]5V]&$\bbBA\u0013\u0017\u0012\u0005\u0011qE\u0001\u0006k:LGo]\u000b\u0003\u0003S\u0001b!a\u000b\u00026\u0005eRBAA\u0017\u0015\u0011\ty#!\r\u0002\u0013%lW.\u001e;bE2,'bAA\u001ac\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0012Q\u0006\u0002\u0004'\u0016$\b\u0003B\u0005\u0002<1I1!!\u0010\u0005\u00055)f.\u001b;PM6+\u0017m];sK\"I\u0011\u0011I&\u0002\u0002\u0013%\u00111I\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002FA!\u0011QAA$\u0013\u0011\tI%a\u0002\u0003\r=\u0013'.Z2u\u0011!\ti\u0005\u0001C\t\t\u0005=\u0013A\u0004;j[\u0016Le\u000e^3he\u0006$X\rZ\u000b\u0002)!A\u00111\u000b\u0001\u0005\u0012\u0011\t)&A\u0006uS6,G)\u001a:jm\u0016$W#A\u0015\t\u000fE\u0001A\u0011\u0003\u0003\u0002ZU\u0011\u00111\f\t\u0004\u001f\u0005u\u0013bAA0!\t!A+[7f\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003K\na\u0001\n;j[\u0016\u001cH\u0003BA4\u0003[\u00022!DA5\u0013\r\tYG\u0001\u0002\u0006\r>\u00148-\u001a\u0005\t\u0003_\n\t\u00071\u0001\u0002r\u0005!A\u000f[1u!\rY\u00121O\u0005\u0004\u0003k*#\u0001B'bgNDq!a\u0019\u0001\t\u0003\tI\bF\u0002\u001b\u0003wB\u0001\"a\u001c\u0002x\u0001\u0007\u0011Q\u0010\t\u0004\u001f\u0005}\u0014bAAA!\tYA+[7f'F,\u0018M]3e\u0011\u0019\t)\t\u0001C\u0001]\u00051Bo\u001c$fKR\u0004VM]*fG>tGmU9vCJ,G\r\u0003\u0004\u0002\n\u0002!\tAL\u0001\u001ei>l\u0015\u000e\u001c7j[\u0016$XM]:QKJ\u001cVmY8oIN\u000bX/\u0019:fI\"1\u0011Q\u0012\u0001\u0005\u00029\n\u0001\u0004^8NKR,'o\u001d)feN+7m\u001c8e'F,\u0018M]3e\u0011\u0019\t\t\n\u0001C\u0001]\u00059Bo\\+t\u001b&dWm\u001d)fe\"{WO]*rk\u0006\u0014X\r\u001a\u0005\u0007\u0003+\u0003A\u0011\u0001\u0018\u0002!Q|W)\u0019:uQ\u001e\u0013\u0018M^5uS\u0016\u001c\bbBAM\u0001\u0011\u0005\u00111T\u0001\bC:\fG.\u001f>f)\u0011\ti*a)\u0011\rA\ny*a\u0017\u0015\u0013\r\t\t+\r\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005\u0015\u0016q\u0013a\u00015\u0005AA-[:uC:\u001cW\rC\u0004\u0002\u001a\u0002!\t!!+\u0015\t\u0005-\u0016Q\u0016\t\u0006a\u0005}%\u0004\u0006\u0005\t\u0003_\u000b9\u000b1\u0001\u0002\\\u0005\u0001\u0012mY2fY\u0016\u0014\u0018\r^5p]RKW.\u001a\u0005\b\u00033\u0003A\u0011AAZ)\u0011\t),a.\u0011\rA\ny*a\u0017\u001b\u0011\u001d\tI,!-A\u0002Q\t\u0001B^3m_\u000eLG/\u001f")
public final class Acceleration
extends Quantity<Acceleration>
implements TimeDerivative<Velocity>,
SecondTimeDerivative<Length>,
TimeIntegral<Jerk> {
    private final double value;
    private final AccelerationUnit unit;

    public static <N> Try<Acceleration> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Acceleration$.MODULE$.parseTuple(tuple2, numeric);
    }

    public static Try<Acceleration> parseString(String string) {
        return Acceleration$.MODULE$.parseString(string);
    }

    public static Option<UnitOfMeasure<Acceleration>> symbolToUnit(String string) {
        return Acceleration$.MODULE$.symbolToUnit(string);
    }

    public static /* bridge */ UnitOfMeasure siUnit() {
        return Acceleration$.MODULE$.siUnit();
    }

    public static /* bridge */ UnitOfMeasure primaryUnit() {
        return Acceleration$.MODULE$.primaryUnit();
    }

    public static Set<UnitOfMeasure<Acceleration>> units() {
        return Acceleration$.MODULE$.units();
    }

    public static MetersPerSecondSquared$ siUnit() {
        return Acceleration$.MODULE$.siUnit();
    }

    public static MetersPerSecondSquared$ primaryUnit() {
        return Acceleration$.MODULE$.primaryUnit();
    }

    public static String name() {
        return Acceleration$.MODULE$.name();
    }

    public static Try<Acceleration> apply(Object object) {
        return Acceleration$.MODULE$.apply(object);
    }

    @Override
    public Quantity $div(Time that) {
        return TimeIntegral.$div$((TimeIntegral)this, that);
    }

    @Override
    public Quantity per(Time that) {
        return TimeIntegral.per$(this, that);
    }

    @Override
    public Time $div(Quantity that) {
        return TimeIntegral.$div$((TimeIntegral)this, that);
    }

    @Override
    public Quantity $times(Frequency that) {
        return TimeIntegral.$times$(this, that);
    }

    @Override
    public Quantity $times(Time that) {
        return TimeDerivative.$times$(this, that);
    }

    @Override
    public double value() {
        return this.value;
    }

    public AccelerationUnit unit() {
        return this.unit;
    }

    public Acceleration$ dimension() {
        return Acceleration$.MODULE$;
    }

    @Override
    public Velocity timeIntegrated() {
        return MetersPerSecond$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toMetersPerSecondSquared()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Jerk timeDerived() {
        return MetersPerSecondCubed$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toMetersPerSecondSquared()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Seconds$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Force $times(Mass that) {
        return Newtons$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toMetersPerSecondSquared() * that.toKilograms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Length $times(TimeSquared that) {
        return (Length)((TimeDerivative)((Object)this.$times(that.time1()))).$times(that.time2());
    }

    public double toFeetPerSecondSquared() {
        return this.to(FeetPerSecondSquared$.MODULE$);
    }

    public double toMillimetersPerSecondSquared() {
        return this.to(MillimetersPerSecondSquared$.MODULE$);
    }

    public double toMetersPerSecondSquared() {
        return this.to(MetersPerSecondSquared$.MODULE$);
    }

    public double toUsMilesPerHourSquared() {
        return this.to(UsMilesPerHourSquared$.MODULE$);
    }

    public double toEarthGravities() {
        return this.to(EarthGravities$.MODULE$);
    }

    public Tuple2<Time, Velocity> analyze(Length distance) {
        Time timeToDistance = ((Length)distance.$times(2.0)).$div(this).squareRoot();
        Velocity finalVelocity = (Velocity)this.$times(timeToDistance);
        return new Tuple2((Object)timeToDistance, (Object)finalVelocity);
    }

    public Tuple2<Length, Velocity> analyze(Time accelerationTime) {
        Velocity finalVelocity = (Velocity)this.$times(accelerationTime);
        Length distance = (Length)this.$times(accelerationTime.squared()).$times(0.5);
        return new Tuple2((Object)distance, (Object)finalVelocity);
    }

    public Tuple2<Time, Length> analyze(Velocity velocity) {
        Time timeToVelocity = velocity.$div(this);
        Length distance = (Length)this.$times(timeToVelocity.squared()).$times(0.5);
        return new Tuple2((Object)timeToVelocity, (Object)distance);
    }

    public Acceleration(double value, AccelerationUnit unit) {
        this.value = value;
        this.unit = unit;
        TimeDerivative.$init$(this);
        TimeIntegral.$init$(this);
    }
}

