/*
 * Decompiled with CFR 0.152.
 */
package squants.mass;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import squants.Quantity;
import squants.SiBaseUnit;
import squants.UnitOfMeasure;
import squants.energy.Energy;
import squants.energy.Joules$;
import squants.energy.SpecificEnergy;
import squants.mass.AreaDensity;
import squants.mass.Carats$;
import squants.mass.Density;
import squants.mass.Density$;
import squants.mass.ElectronVoltMass$;
import squants.mass.ExaElectronVoltMass$;
import squants.mass.GigaElectronVoltMass$;
import squants.mass.Grams$;
import squants.mass.KiloElectronVoltMass$;
import squants.mass.Kilograms$;
import squants.mass.KilogramsMetersSquared$;
import squants.mass.KilogramsPerSquareMeter$;
import squants.mass.Kilopounds$;
import squants.mass.Mass$;
import squants.mass.MassUnit;
import squants.mass.MegaElectronVoltMass$;
import squants.mass.Megapounds$;
import squants.mass.Micrograms$;
import squants.mass.MilliElectronVoltMass$;
import squants.mass.Milligrams$;
import squants.mass.MomentOfInertia;
import squants.mass.Nanograms$;
import squants.mass.Ounces$;
import squants.mass.Pennyweights$;
import squants.mass.PetaElectronVoltMass$;
import squants.mass.Pounds$;
import squants.mass.SolarMasses$;
import squants.mass.Stone$;
import squants.mass.TeraElectronVoltMass$;
import squants.mass.Tolas$;
import squants.mass.Tonnes$;
import squants.mass.TroyGrains$;
import squants.mass.TroyOunces$;
import squants.mass.TroyPounds$;
import squants.motion.Acceleration;
import squants.motion.Force;
import squants.motion.KilogramsPerSecond$;
import squants.motion.MassFlow;
import squants.motion.Momentum;
import squants.motion.Momentum$;
import squants.motion.Newtons$;
import squants.motion.Velocity;
import squants.package$;
import squants.space.Area;
import squants.space.CubicMeters$;
import squants.space.Length;
import squants.space.SquareMeters$;
import squants.space.Volume;
import squants.time.Frequency;
import squants.time.Time;
import squants.time.TimeIntegral;

@ScalaSignature(bytes="\u0006\u0001\t-c\u0001B\u0001\u0003\u0005\u001d\u0011A!T1tg*\u00111\u0001B\u0001\u0005[\u0006\u001c8OC\u0001\u0006\u0003\u001d\u0019\u0018/^1oiN\u001c\u0001aE\u0002\u0001\u00119\u00012!\u0003\u0006\r\u001b\u0005!\u0011BA\u0006\u0005\u0005!\tV/\u00198uSRL\bCA\u0007\u0001\u001b\u0005\u0011\u0001cA\b\u0013)5\t\u0001C\u0003\u0002\u0012\t\u0005!A/[7f\u0013\t\u0019\u0002C\u0001\u0007US6,\u0017J\u001c;fOJ\fG\u000e\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u00051Qn\u001c;j_:L!!\u0007\f\u0003\u00115\u000b7o\u001d$m_^D\u0001b\u0007\u0001\u0003\u0006\u0004%\t\u0001H\u0001\u0006m\u0006dW/Z\u000b\u0002;A\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1Ai\\;cY\u0016D\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!H\u0001\u0007m\u0006dW/\u001a\u0011\t\u0011\u0019\u0002!Q1A\u0005\u0002\u001d\nA!\u001e8jiV\t\u0001\u0006\u0005\u0002\u000eS%\u0011!F\u0001\u0002\t\u001b\u0006\u001c8/\u00168ji\"AA\u0006\u0001B\u0001B\u0003%\u0001&A\u0003v]&$\b\u0005C\u0003/\u0001\u0011%q&\u0001\u0004=S:LGO\u0010\u000b\u0004\u0019A\n\u0004\"B\u000e.\u0001\u0004i\u0002\"\u0002\u0014.\u0001\u0004A\u0003\"B\u001a\u0001\t\u0003!\u0014!\u00033j[\u0016t7/[8o+\u0005)dBA\u00077\u000f\u00159$\u0001#\u00019\u0003\u0011i\u0015m]:\u0011\u00055Id!B\u0001\u0003\u0011\u0003Q4#B\u001d<}\u0005#\u0005C\u0001\u0010=\u0013\titD\u0001\u0004B]f\u0014VM\u001a\t\u0004\u0013}b\u0011B\u0001!\u0005\u0005%!\u0015.\\3og&|g\u000e\u0005\u0002\n\u0005&\u00111\t\u0002\u0002\u000e\u0005\u0006\u001cX\rR5nK:\u001c\u0018n\u001c8\u0011\u0005y)\u0015B\u0001$ \u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015q\u0013\b\"\u0001I)\u0005A\u0004B\u0002&:\t\u0003\u00111*A\u0003baBd\u00170\u0006\u0002M=R\u0019QjZ5\u0015\u00051q\u0005\"B(J\u0001\b\u0001\u0016a\u00018v[B\u0019\u0011+\u0017/\u000f\u0005I;fBA*W\u001b\u0005!&BA+\u0007\u0003\u0019a$o\\8u}%\t\u0001%\u0003\u0002Y?\u00059\u0001/Y2lC\u001e,\u0017B\u0001.\\\u0005\u001dqU/\\3sS\u000eT!\u0001W\u0010\u0011\u0005usF\u0002\u0001\u0003\u0006?&\u0013\r\u0001\u0019\u0002\u0002\u0003F\u0011\u0011\r\u001a\t\u0003=\tL!aY\u0010\u0003\u000f9{G\u000f[5oOB\u0011a$Z\u0005\u0003M~\u00111!\u00118z\u0011\u0015A\u0017\n1\u0001]\u0003\u0005q\u0007\"\u0002\u0014J\u0001\u0004A\u0003\"\u0002&:\t\u0003YGC\u00017s!\ri\u0007\u000fD\u0007\u0002]*\u0011qnH\u0001\u0005kRLG.\u0003\u0002r]\n\u0019AK]=\t\u000bmQ\u0007\u0019\u00013\t\u000bQLD\u0011A;\u0002\t9\fW.Z\u000b\u0002mB\u0011q\u000f`\u0007\u0002q*\u0011\u0011P_\u0001\u0005Y\u0006twMC\u0001|\u0003\u0011Q\u0017M^1\n\u0005uD(AB*ue&tw\r\u0003\u0004\u0000s\u0011\u0005\u0011\u0011A\u0001\faJLW.\u0019:z+:LG/\u0006\u0002\u0002\u00049\u0019Q\"!\u0002\n\u0007\u0005\u001d!!A\u0003He\u0006l7\u000fC\u0004\u0002\fe\"\t!!\u0004\u0002\rMLWK\\5u+\t\tyAD\u0002\u000e\u0003#I1!a\u0005\u0003\u0003%Y\u0015\u000e\\8he\u0006l7\u000fC\u0004\u0002\u0018e\"\t!!\u0007\u0002\u000bUt\u0017\u000e^:\u0016\u0005\u0005m\u0001CBA\u000f\u0003O\tY#\u0004\u0002\u0002 )!\u0011\u0011EA\u0012\u0003%IW.\\;uC\ndWMC\u0002\u0002&}\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI#a\b\u0003\u0007M+G\u000f\u0005\u0003\n\u0003[a\u0011bAA\u0018\t\tiQK\\5u\u001f\u001alU-Y:ve\u0016Da!a\r:\t\u0003)\u0018a\u00043j[\u0016t7/[8o'fl'm\u001c7\t\u0013\u0005]\u0012(!A\u0005\n\u0005e\u0012a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u000f\u0011\u0007]\fi$C\u0002\u0002@a\u0014aa\u00142kK\u000e$\bbBA\"\u0001\u0011E\u0011QI\u0001\fi&lW\rR3sSZ,G-F\u0001\u0015\u0011\u0019\t\u0002\u0001\"\u0005\u0002JU\u0011\u00111\n\t\u0004\u001f\u00055\u0013bAA(!\t!A+[7f\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+\na\u0001\n;j[\u0016\u001cH\u0003BA,\u0003G\u0002B!!\u0017\u0002`5\u0011\u00111\f\u0006\u0004\u0003;\"\u0011AB3oKJ<\u00170\u0003\u0003\u0002b\u0005m#AB#oKJ<\u0017\u0010\u0003\u0005\u0002f\u0005E\u0003\u0019AA4\u0003\u0011!\b.\u0019;\u0011\t\u0005e\u0013\u0011N\u0005\u0005\u0003W\nYF\u0001\bTa\u0016\u001c\u0017NZ5d\u000b:,'oZ=\t\u000f\u0005M\u0003\u0001\"\u0001\u0002pQ!\u0011\u0011OA<!\r)\u00121O\u0005\u0004\u0003k2\"\u0001C'p[\u0016tG/^7\t\u0011\u0005\u0015\u0014Q\u000ea\u0001\u0003s\u0002B!a\u001f\u0002\u0004:!\u0011QPAA\u001d\r\u0019\u0016qP\u0005\u0002\u000b%\u0011\u0001\fB\u0005\u0005\u0003\u000b\u000b9I\u0001\u0005WK2|7-\u001b;z\u0015\tAF\u0001C\u0004\u0002T\u0001!\t!a#\u0015\t\u00055\u00151\u0013\t\u0004+\u0005=\u0015bAAI-\t)ai\u001c:dK\"A\u0011QMAE\u0001\u0004\t)\n\u0005\u0003\u0002|\u0005]\u0015\u0002BAM\u0003\u000f\u0013A\"Q2dK2,'/\u0019;j_:Dq!!(\u0001\t\u0003\ty*\u0001\u0003%I&4H\u0003BAQ\u0003O\u0003B!a\u001f\u0002$&!\u0011QUAD\u0005\u00191v\u000e\\;nK\"A\u0011QMAN\u0001\u0004\tI\u000bE\u0002\u000e\u0003WK1!!,\u0003\u0005\u001d!UM\\:jifDq!!(\u0001\t\u0003\t\t\f\u0006\u0003\u0002*\u0006M\u0006\u0002CA3\u0003_\u0003\r!!)\t\u000f\u0005u\u0005\u0001\"\u0001\u00028R!\u0011\u0011XA`!\u0011\tY(a/\n\t\u0005u\u0016q\u0011\u0002\u0005\u0003J,\u0017\r\u0003\u0005\u0002f\u0005U\u0006\u0019AAa!\ri\u00111Y\u0005\u0004\u0003\u000b\u0014!aC!sK\u0006$UM\\:jifDq!!(\u0001\t\u0003\tI\r\u0006\u0003\u0002B\u0006-\u0007\u0002CA3\u0003\u000f\u0004\r!!/\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\u0006AqN\u001c*bI&,8\u000f\u0006\u0003\u0002T\u0006e\u0007cA\u0007\u0002V&\u0019\u0011q\u001b\u0002\u0003\u001f5{W.\u001a8u\u001f\u001aLe.\u001a:uS\u0006D\u0001\"a7\u0002N\u0002\u0007\u0011Q\\\u0001\u0007e\u0006$\u0017.^:\u0011\t\u0005m\u0014q\\\u0005\u0005\u0003C\f9I\u0001\u0004MK:<G\u000f\u001b\u0005\u0007\u0003K\u0004A\u0011\u0001\u000f\u0002\u0017Q|g*\u00198pOJ\fWn\u001d\u0005\u0007\u0003S\u0004A\u0011\u0001\u000f\u0002\u0019Q|W*[2s_\u001e\u0014\u0018-\\:\t\r\u00055\b\u0001\"\u0001\u001d\u00031!x.T5mY&<'/Y7t\u0011\u0019\t\t\u0010\u0001C\u00019\u00059Ao\\$sC6\u001c\bBBA{\u0001\u0011\u0005A$A\u0006u_.KGn\\4sC6\u001c\bBBA}\u0001\u0011\u0005A$\u0001\u0005u_R{gN\\3t\u0011\u0019\ti\u0010\u0001C\u00019\u0005AAo\\(v]\u000e,7\u000f\u0003\u0004\u0003\u0002\u0001!\t\u0001H\u0001\ti>\u0004v.\u001e8eg\"1!Q\u0001\u0001\u0005\u0002q\tA\u0002^8LS2|\u0007o\\;oINDaA!\u0003\u0001\t\u0003a\u0012\u0001\u0004;p\u001b\u0016<\u0017\r]8v]\u0012\u001c\bB\u0002B\u0007\u0001\u0011\u0005A$A\u0004u_N#xN\\3\t\r\tE\u0001\u0001\"\u0001\u001d\u00031!x\u000e\u0016:ps\u001e\u0013\u0018-\u001b8t\u0011\u0019\u0011)\u0002\u0001C\u00019\u0005qAo\u001c)f]:Lx/Z5hQR\u001c\bB\u0002B\r\u0001\u0011\u0005A$\u0001\u0007u_R\u0013x._(v]\u000e,7\u000f\u0003\u0004\u0003\u001e\u0001!\t\u0001H\u0001\ri>$&o\\=Q_VtGm\u001d\u0005\u0007\u0005C\u0001A\u0011\u0001\u000f\u0002\u000fQ|Gk\u001c7bg\"1!Q\u0005\u0001\u0005\u0002q\t\u0001\u0002^8DCJ\fGo\u001d\u0005\u0007\u0005S\u0001A\u0011\u0001\u000f\u0002\u001bQ|7k\u001c7be6\u000b7o]3t\u0011\u0019\u0011i\u0003\u0001C\u00019\u0005!Ao\\3W\u0011\u0019\u0011\t\u0004\u0001C\u00019\u0005)Ao\\7f-\"1!Q\u0007\u0001\u0005\u0002q\tQ\u0001^8lKZCaA!\u000f\u0001\t\u0003a\u0012!\u0002;p\u001b\u00164\u0006B\u0002B\u001f\u0001\u0011\u0005A$A\u0003u_\u001e+g\u000b\u0003\u0004\u0003B\u0001!\t\u0001H\u0001\u0006i>$VM\u0016\u0005\u0007\u0005\u000b\u0002A\u0011\u0001\u000f\u0002\u000bQ|\u0007+\u001a,\t\r\t%\u0003\u0001\"\u0001\u001d\u0003\u0015!x.R3W\u0001")
public final class Mass
extends Quantity<Mass>
implements TimeIntegral<MassFlow> {
    private final double value;
    private final MassUnit unit;

    public static <N> Try<Mass> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Mass$.MODULE$.parseTuple(tuple2, numeric);
    }

    public static Try<Mass> parseString(String string) {
        return Mass$.MODULE$.parseString(string);
    }

    public static Option<UnitOfMeasure<Mass>> symbolToUnit(String string) {
        return Mass$.MODULE$.symbolToUnit(string);
    }

    public static /* bridge */ UnitOfMeasure siUnit() {
        return Mass$.MODULE$.siUnit();
    }

    public static /* bridge */ SiBaseUnit siUnit() {
        return Mass$.MODULE$.siUnit();
    }

    public static /* bridge */ UnitOfMeasure primaryUnit() {
        return Mass$.MODULE$.primaryUnit();
    }

    public static String dimensionSymbol() {
        return Mass$.MODULE$.dimensionSymbol();
    }

    public static Set<UnitOfMeasure<Mass>> units() {
        return Mass$.MODULE$.units();
    }

    public static Kilograms$ siUnit() {
        return Mass$.MODULE$.siUnit();
    }

    public static Grams$ primaryUnit() {
        return Mass$.MODULE$.primaryUnit();
    }

    public static String name() {
        return Mass$.MODULE$.name();
    }

    public static Try<Mass> apply(Object object) {
        return Mass$.MODULE$.apply(object);
    }

    @Override
    public Quantity $div(Time that) {
        return TimeIntegral.$div$((TimeIntegral)this, that);
    }

    @Override
    public Quantity per(Time that) {
        return TimeIntegral.per$(this, that);
    }

    @Override
    public Time $div(Quantity that) {
        return TimeIntegral.$div$((TimeIntegral)this, that);
    }

    @Override
    public Quantity $times(Frequency that) {
        return TimeIntegral.$times$(this, that);
    }

    @Override
    public double value() {
        return this.value;
    }

    public MassUnit unit() {
        return this.unit;
    }

    public Mass$ dimension() {
        return Mass$.MODULE$;
    }

    @Override
    public MassFlow timeDerived() {
        return KilogramsPerSecond$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toKilograms()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return package$.MODULE$.Seconds().apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Energy $times(SpecificEnergy that) {
        return Joules$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toKilograms() * that.toGrays())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Momentum $times(Velocity that) {
        return Momentum$.MODULE$.apply(this, that);
    }

    public Force $times(Acceleration that) {
        return Newtons$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toKilograms() * that.toMetersPerSecondSquared())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Volume $div(Density that) {
        return CubicMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toKilograms() / that.toKilogramsPerCubicMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Density $div(Volume that) {
        return Density$.MODULE$.apply(this, that);
    }

    public Area $div(AreaDensity that) {
        return SquareMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toKilograms() / that.toKilogramsPerSquareMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public AreaDensity $div(Area that) {
        return KilogramsPerSquareMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toKilograms() / that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public MomentOfInertia onRadius(Length radius) {
        return KilogramsMetersSquared$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toKilograms() * radius.squared().toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toNanograms() {
        return this.to(Nanograms$.MODULE$);
    }

    public double toMicrograms() {
        return this.to(Micrograms$.MODULE$);
    }

    public double toMilligrams() {
        return this.to(Milligrams$.MODULE$);
    }

    public double toGrams() {
        return this.to(Grams$.MODULE$);
    }

    public double toKilograms() {
        return this.to(Kilograms$.MODULE$);
    }

    public double toTonnes() {
        return this.to(Tonnes$.MODULE$);
    }

    public double toOunces() {
        return this.to(Ounces$.MODULE$);
    }

    public double toPounds() {
        return this.to(Pounds$.MODULE$);
    }

    public double toKilopounds() {
        return this.to(Kilopounds$.MODULE$);
    }

    public double toMegapounds() {
        return this.to(Megapounds$.MODULE$);
    }

    public double toStone() {
        return this.to(Stone$.MODULE$);
    }

    public double toTroyGrains() {
        return this.to(TroyGrains$.MODULE$);
    }

    public double toPennyweights() {
        return this.to(Pennyweights$.MODULE$);
    }

    public double toTroyOunces() {
        return this.to(TroyOunces$.MODULE$);
    }

    public double toTroyPounds() {
        return this.to(TroyPounds$.MODULE$);
    }

    public double toTolas() {
        return this.to(Tolas$.MODULE$);
    }

    public double toCarats() {
        return this.to(Carats$.MODULE$);
    }

    public double toSolarMasses() {
        return this.to(SolarMasses$.MODULE$);
    }

    public double toeV() {
        return this.to(ElectronVoltMass$.MODULE$);
    }

    public double tomeV() {
        return this.to(MilliElectronVoltMass$.MODULE$);
    }

    public double tokeV() {
        return this.to(KiloElectronVoltMass$.MODULE$);
    }

    public double toMeV() {
        return this.to(MegaElectronVoltMass$.MODULE$);
    }

    public double toGeV() {
        return this.to(GigaElectronVoltMass$.MODULE$);
    }

    public double toTeV() {
        return this.to(TeraElectronVoltMass$.MODULE$);
    }

    public double toPeV() {
        return this.to(PetaElectronVoltMass$.MODULE$);
    }

    public double toEeV() {
        return this.to(ExaElectronVoltMass$.MODULE$);
    }

    public Mass(double value, MassUnit unit) {
        this.value = value;
        this.unit = unit;
        TimeIntegral.$init$(this);
    }
}

