/*
 * Decompiled with CFR 0.152.
 */
package squants.energy;

import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.Coulombs$;
import squants.electro.ElectricCharge;
import squants.electro.ElectricPotential;
import squants.electro.Volts$;
import squants.energy.BritishThermalUnits$;
import squants.energy.ElectronVolt$;
import squants.energy.Energy$;
import squants.energy.EnergyDensity;
import squants.energy.EnergyUnit;
import squants.energy.Ergs$;
import squants.energy.ExaElectronVolt$;
import squants.energy.GigaElectronVolt$;
import squants.energy.Gigajoules$;
import squants.energy.GigawattHours$;
import squants.energy.Grays$;
import squants.energy.Joules$;
import squants.energy.JoulesPerCubicMeter$;
import squants.energy.JoulesPerMole$;
import squants.energy.KiloElectronVolt$;
import squants.energy.Kilojoules$;
import squants.energy.KilowattHours$;
import squants.energy.MBtus$;
import squants.energy.MMBtus$;
import squants.energy.MegaElectronVolt$;
import squants.energy.Megajoules$;
import squants.energy.MegawattHours$;
import squants.energy.Microjoules$;
import squants.energy.MilliElectronVolt$;
import squants.energy.Millijoules$;
import squants.energy.MilliwattHours$;
import squants.energy.MolarEnergy;
import squants.energy.Nanojoules$;
import squants.energy.PetaElectronVolt$;
import squants.energy.Picojoules$;
import squants.energy.Power;
import squants.energy.PowerRamp;
import squants.energy.SpecificEnergy;
import squants.energy.TeraElectronVolt$;
import squants.energy.Terajoules$;
import squants.energy.WattHours$;
import squants.energy.Watts$;
import squants.mass.ChemicalAmount;
import squants.mass.Kilograms$;
import squants.mass.Mass;
import squants.motion.Force;
import squants.motion.NewtonMeters$;
import squants.motion.Newtons$;
import squants.motion.Torque;
import squants.package$;
import squants.space.Angle;
import squants.space.Area;
import squants.space.CubicMeters$;
import squants.space.Length;
import squants.space.Volume;
import squants.thermal.JoulesPerKelvin$;
import squants.thermal.Kelvin$;
import squants.thermal.Temperature;
import squants.thermal.ThermalCapacity;
import squants.time.Frequency;
import squants.time.Hours$;
import squants.time.SecondTimeDerivative;
import squants.time.SecondTimeIntegral;
import squants.time.Time;
import squants.time.TimeIntegral;
import squants.time.TimeSquared;

@ScalaSignature(bytes="\u0006\u0001\t%f\u0001B\u0001\u0003\u0005\u001d\u0011a!\u00128fe\u001eL(BA\u0002\u0005\u0003\u0019)g.\u001a:hs*\tQ!A\u0004tcV\fg\u000e^:\u0004\u0001M!\u0001\u0001\u0003\b\u0018!\rI!\u0002D\u0007\u0002\t%\u00111\u0002\u0002\u0002\t#V\fg\u000e^5usB\u0011Q\u0002A\u0007\u0002\u0005A\u0019qB\u0005\u000b\u000e\u0003AQ!!\u0005\u0003\u0002\tQLW.Z\u0005\u0003'A\u0011A\u0002V5nK&sG/Z4sC2\u0004\"!D\u000b\n\u0005Y\u0011!!\u0002)po\u0016\u0014\bcA\b\u00195%\u0011\u0011\u0004\u0005\u0002\u0013'\u0016\u001cwN\u001c3US6,\u0017J\u001c;fOJ\fG\u000e\u0005\u0002\u000e7%\u0011AD\u0001\u0002\n!><XM\u001d*b[BD\u0001B\b\u0001\u0003\u0006\u0004%\taH\u0001\u0006m\u0006dW/Z\u000b\u0002AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1Ai\\;cY\u0016D\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0007m\u0006dW/\u001a\u0011\t\u0011%\u0002!Q1A\u0005\u0002)\nA!\u001e8jiV\t1\u0006\u0005\u0002\u000eY%\u0011QF\u0001\u0002\u000b\u000b:,'oZ=V]&$\b\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u000bUt\u0017\u000e\u001e\u0011\t\u000bE\u0002A\u0011\u0002\u001a\u0002\rqJg.\u001b;?)\ra1\u0007\u000e\u0005\u0006=A\u0002\r\u0001\t\u0005\u0006SA\u0002\ra\u000b\u0005\u0006m\u0001!\taN\u0001\nI&lWM\\:j_:,\u0012\u0001\u000f\b\u0003\u001be:QA\u000f\u0002\t\u0002m\na!\u00128fe\u001eL\bCA\u0007=\r\u0015\t!\u0001#\u0001>'\u0011ad(\u0011#\u0011\u0005\u0005z\u0014B\u0001!#\u0005\u0019\te.\u001f*fMB\u0019\u0011B\u0011\u0007\n\u0005\r#!!\u0003#j[\u0016t7/[8o!\t\tS)\u0003\u0002GE\ta1+\u001a:jC2L'0\u00192mK\")\u0011\u0007\u0010C\u0001\u0011R\t1\b\u0003\u0004Ky\u0011\u0005!aS\u0001\u0006CB\u0004H._\u000b\u0003\u0019z#2!T4j)\taa\nC\u0003P\u0013\u0002\u000f\u0001+A\u0002ok6\u00042!U-]\u001d\t\u0011vK\u0004\u0002T-6\tAK\u0003\u0002V\r\u00051AH]8pizJ\u0011aI\u0005\u00031\n\nq\u0001]1dW\u0006<W-\u0003\u0002[7\n9a*^7fe&\u001c'B\u0001-#!\tif\f\u0004\u0001\u0005\u000b}K%\u0019\u00011\u0003\u0003\u0005\u000b\"!\u00193\u0011\u0005\u0005\u0012\u0017BA2#\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!I3\n\u0005\u0019\u0014#aA!os\")\u0001.\u0013a\u00019\u0006\ta\u000eC\u0003*\u0013\u0002\u00071\u0006C\u0003Ky\u0011\u00051\u000eF\u0002\rY:DQ!\u001c6A\u0002Q\tA\u0001\\8bI\")\u0011C\u001ba\u0001_B\u0011q\u0002]\u0005\u0003cB\u0011A\u0001V5nK\")!\n\u0010C\u0001gR\u0011AO\u001f\t\u0004kbdQ\"\u0001<\u000b\u0005]\u0014\u0013\u0001B;uS2L!!\u001f<\u0003\u0007Q\u0013\u0018\u0010C\u0003\u001fe\u0002\u0007A\rC\u0003}y\u0011\u0005Q0\u0001\u0003oC6,W#\u0001@\u0011\u0007}\fI!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0011\u0001\u00026bm\u0006LA!a\u0003\u0002\u0002\t11\u000b\u001e:j]\u001eDq!a\u0004=\t\u0003\t\t\"A\u0006qe&l\u0017M]=V]&$XCAA\n\u001d\ri\u0011QC\u0005\u0004\u0003/\u0011\u0011!C,biRDu.\u001e:t\u0011\u001d\tY\u0002\u0010C\u0001\u0003;\taa]5V]&$XCAA\u0010\u001d\ri\u0011\u0011E\u0005\u0004\u0003G\u0011\u0011A\u0002&pk2,7\u000fC\u0004\u0002(q\"\t!!\u000b\u0002\u000bUt\u0017\u000e^:\u0016\u0005\u0005-\u0002CBA\u0017\u0003o\tY$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003%IW.\\;uC\ndWMC\u0002\u00026\t\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI$a\f\u0003\u0007M+G\u000f\u0005\u0003\n\u0003{a\u0011bAA \t\tiQK\\5u\u001f\u001alU-Y:ve\u0016D\u0011\"a\u0011=\u0003\u0003%I!!\u0012\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u000f\u00022a`A%\u0013\u0011\tY%!\u0001\u0003\r=\u0013'.Z2u\u0011\u001d\ty\u0005\u0001C\t\u0003#\n1\u0002^5nK\u0012+'/\u001b<fIV\tA\u0003\u0003\u0004\u0012\u0001\u0011E\u0011QK\u000b\u0002_\"9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0013\u0001\u0002\u0013eSZ$B!!\u0018\u0002nA!\u0011qLA4\u001d\u0011\t\t'!\u001a\u000f\u0007M\u000b\u0019'C\u0001\u0006\u0013\tAF!\u0003\u0003\u0002j\u0005-$!\u0002$pe\u000e,'B\u0001-\u0005\u0011!\ty'a\u0016A\u0002\u0005E\u0014\u0001\u0002;iCR\u0004B!a\u0018\u0002t%!\u0011QOA6\u0005\u0019aUM\\4uQ\"9\u0011\u0011\f\u0001\u0005\u0002\u0005eD\u0003BA9\u0003wB\u0001\"a\u001c\u0002x\u0001\u0007\u0011Q\f\u0005\b\u00033\u0002A\u0011AA@)\u0011\t\t)a\"\u0011\u00075\t\u0019)C\u0002\u0002\u0006\n\u0011ab\u00159fG&4\u0017nY#oKJ<\u0017\u0010\u0003\u0005\u0002p\u0005u\u0004\u0019AAE!\u0011\ty&a#\n\t\u00055\u00151\u000e\u0002\u0005\u001b\u0006\u001c8\u000fC\u0004\u0002Z\u0001!\t!!%\u0015\t\u0005%\u00151\u0013\u0005\t\u0003_\ny\t1\u0001\u0002\u0002\"9\u0011\u0011\f\u0001\u0005\u0002\u0005]E\u0003BAM\u0003?\u00032!DAN\u0013\r\tiJ\u0001\u0002\u000e\u000b:,'oZ=EK:\u001c\u0018\u000e^=\t\u0011\u0005=\u0014Q\u0013a\u0001\u0003C\u0003B!a\u0018\u0002$&!\u0011QUA6\u0005\u00191v\u000e\\;nK\"9\u0011\u0011\f\u0001\u0005\u0002\u0005%F\u0003BAQ\u0003WC\u0001\"a\u001c\u0002(\u0002\u0007\u0011\u0011\u0014\u0005\b\u00033\u0002A\u0011AAX)\u0011\t\t,!0\u0011\t\u0005M\u0016\u0011X\u0007\u0003\u0003kS1!a.\u0005\u0003\u001d)G.Z2ue>LA!a/\u00026\n\tR\t\\3diJL7\rU8uK:$\u0018.\u00197\t\u0011\u0005=\u0014Q\u0016a\u0001\u0003\u007f\u0003B!a-\u0002B&!\u00111YA[\u00059)E.Z2ue&\u001c7\t[1sO\u0016Dq!!\u0017\u0001\t\u0003\t9\r\u0006\u0003\u0002@\u0006%\u0007\u0002CA8\u0003\u000b\u0004\r!!-\t\u000f\u0005e\u0003\u0001\"\u0001\u0002NR!\u0011qZAn!\u0011\t\t.a6\u000e\u0005\u0005M'bAAk\t\u00059A\u000f[3s[\u0006d\u0017\u0002BAm\u0003'\u0014q\u0002\u00165fe6\fGnQ1qC\u000eLG/\u001f\u0005\t\u0003_\nY\r1\u0001\u0002^B!\u0011qLAp\u0013\u0011\t\t/a\u001b\u0003\u0017Q+W\u000e]3sCR,(/\u001a\u0005\b\u00033\u0002A\u0011AAs)\u0011\t9/a;\u0011\t\u0005E\u0017\u0011^\u0005\u0005\u0003C\f\u0019\u000e\u0003\u0005\u0002p\u0005\r\b\u0019AAh\u0011\u001d\tI\u0006\u0001C\u0001\u0003_$B!!=\u0002xB\u0019Q\"a=\n\u0007\u0005U(AA\u0006N_2\f'/\u00128fe\u001eL\b\u0002CA8\u0003[\u0004\r!!?\u0011\t\u0005m(\u0011A\u0007\u0003\u0003{T1!a@\u0005\u0003\u0011i\u0017m]:\n\t\t\r\u0011Q \u0002\u000f\u0007\",W.[2bY\u0006kw.\u001e8u\u0011\u001d\tI\u0006\u0001C\u0001\u0005\u000f!BA!\u0003\u0003\u0016A!!1\u0002B\t\u001b\t\u0011iAC\u0002\u0003\u0010\u0011\ta!\\8uS>t\u0017\u0002\u0002B\n\u0005\u001b\u0011a\u0001V8scV,\u0007\u0002CA8\u0005\u000b\u0001\rAa\u0006\u0011\t\u0005}#\u0011D\u0005\u0005\u00057\tYGA\u0003B]\u001edW\rC\u0004\u0002Z\u0001!\tAa\b\u0015\u0007\u0005\u0014\t\u0003\u0003\u0005\u0002p\tu\u0001\u0019\u0001B\u0012!\u0011\tyF!\n\n\t\t\u001d\u00121\u000e\u0002\u0005\u0003J,\u0017\rC\u0004\u0002Z\u0001!\tAa\u000b\u0015\u0007i\u0011i\u0003\u0003\u0005\u0002p\t%\u0002\u0019\u0001B\u0018!\ry!\u0011G\u0005\u0004\u0005g\u0001\"a\u0003+j[\u0016\u001c\u0016/^1sK\u0012Dq!!\u0017\u0001\t\u0003\u00119\u0004\u0006\u0003\u00030\te\u0002bBA8\u0005k\u0001\rA\u0007\u0005\u0007\u0005{\u0001A\u0011A\u0010\u0002\u0017Q|w+\u0019;u\u0011>,(o\u001d\u0005\u0007\u0005\u0003\u0002A\u0011A\u0010\u0002!Q|W*\u001b7mS^\fG\u000f\u001e%pkJ\u001c\bB\u0002B#\u0001\u0011\u0005q$A\bu_.KGn\\<biRDu.\u001e:t\u0011\u0019\u0011I\u0005\u0001C\u0001?\u0005yAo\\'fO\u0006<\u0018\r\u001e;I_V\u00148\u000f\u0003\u0004\u0003N\u0001!\taH\u0001\u0010i><\u0015nZ1xCR$\bj\\;sg\"1!\u0011\u000b\u0001\u0005\u0002}\t\u0001\u0002^8K_VdWm\u001d\u0005\u0007\u0005+\u0002A\u0011A\u0010\u0002\u0019Q|\u0007+[2pU>,H.Z:\t\r\te\u0003\u0001\"\u0001 \u00031!xNT1o_*|W\u000f\\3t\u0011\u0019\u0011i\u0006\u0001C\u0001?\u0005iAo\\'jGJ|'n\\;mKNDaA!\u0019\u0001\t\u0003y\u0012!\u0004;p\u001b&dG.\u001b6pk2,7\u000f\u0003\u0004\u0003f\u0001!\taH\u0001\ri>\\\u0015\u000e\\8k_VdWm\u001d\u0005\u0007\u0005S\u0002A\u0011A\u0010\u0002\u0019Q|W*Z4bU>,H.Z:\t\r\t5\u0004\u0001\"\u0001 \u00031!xnR5hC*|W\u000f\\3t\u0011\u0019\u0011\t\b\u0001C\u0001?\u0005aAo\u001c+fe\u0006Tw.\u001e7fg\"1!Q\u000f\u0001\u0005\u0002}\tA\u0001^8f-\"1!\u0011\u0010\u0001\u0005\u0002}\tQ\u0001^8nKZCaA! \u0001\t\u0003y\u0012!\u0002;pW\u00164\u0006B\u0002BA\u0001\u0011\u0005q$A\u0003u_6+g\u000b\u0003\u0004\u0003\u0006\u0002!\taH\u0001\u0006i><UM\u0016\u0005\u0007\u0005\u0013\u0003A\u0011A\u0010\u0002\u000bQ|G+\u001a,\t\r\t5\u0005\u0001\"\u0001 \u0003\u0015!x\u000eU3W\u0011\u0019\u0011\t\n\u0001C\u0001?\u0005)Ao\\#f-\"1!Q\u0013\u0001\u0005\u0002}\ta\u0001^8CiV\u001c\bB\u0002BM\u0001\u0011\u0005q$A\u0004u_6\u0013E/^:\t\r\tu\u0005\u0001\"\u0001 \u0003!!x.T'CiV\u001c\bB\u0002BQ\u0001\u0011\u0005q$\u0001\u0004u_\u0016\u0013xm\u001d\u0005\b\u0005K\u0003A\u0011\u0001BT\u0003!\t7\u000fV8scV,WC\u0001B\u0005\u0001")
public final class Energy
extends Quantity<Energy>
implements TimeIntegral<Power>,
SecondTimeIntegral<PowerRamp> {
    private final double value;
    private final EnergyUnit unit;

    public static <N> Try<Energy> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Energy$.MODULE$.parseTuple(tuple2, numeric);
    }

    public static Try<Energy> parseString(String string) {
        return Energy$.MODULE$.parseString(string);
    }

    public static Option<UnitOfMeasure<Energy>> symbolToUnit(String string) {
        return Energy$.MODULE$.symbolToUnit(string);
    }

    public static /* bridge */ UnitOfMeasure siUnit() {
        return Energy$.MODULE$.siUnit();
    }

    public static /* bridge */ UnitOfMeasure primaryUnit() {
        return Energy$.MODULE$.primaryUnit();
    }

    public static Set<UnitOfMeasure<Energy>> units() {
        return Energy$.MODULE$.units();
    }

    public static Joules$ siUnit() {
        return Energy$.MODULE$.siUnit();
    }

    public static WattHours$ primaryUnit() {
        return Energy$.MODULE$.primaryUnit();
    }

    public static String name() {
        return Energy$.MODULE$.name();
    }

    public static Try<Energy> apply(Object object) {
        return Energy$.MODULE$.apply(object);
    }

    public static Energy apply(Power power, Time time) {
        return Energy$.MODULE$.apply(power, time);
    }

    @Override
    public SecondTimeDerivative per(TimeSquared that) {
        return SecondTimeIntegral.per$(this, that);
    }

    @Override
    public Quantity $div(Time that) {
        return TimeIntegral.$div$((TimeIntegral)this, that);
    }

    @Override
    public Quantity per(Time that) {
        return TimeIntegral.per$(this, that);
    }

    @Override
    public Time $div(Quantity that) {
        return TimeIntegral.$div$((TimeIntegral)this, that);
    }

    @Override
    public Quantity $times(Frequency that) {
        return TimeIntegral.$times$(this, that);
    }

    @Override
    public double value() {
        return this.value;
    }

    public EnergyUnit unit() {
        return this.unit;
    }

    public Energy$ dimension() {
        return Energy$.MODULE$;
    }

    @Override
    public Power timeDerived() {
        return Watts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toWattHours()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Hours$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Force $div(Length that) {
        return Newtons$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Length $div(Force that) {
        return package$.MODULE$.Meters().apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toNewtons())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public SpecificEnergy $div(Mass that) {
        return Grays$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toKilograms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Mass $div(SpecificEnergy that) {
        return Kilograms$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toGrays())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public EnergyDensity $div(Volume that) {
        return JoulesPerCubicMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toCubicMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Volume $div(EnergyDensity that) {
        return CubicMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toJoulesPerCubicMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricPotential $div(ElectricCharge that) {
        return Volts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toCoulombs())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricCharge $div(ElectricPotential that) {
        return Coulombs$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toVolts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ThermalCapacity $div(Temperature that) {
        return JoulesPerKelvin$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toKelvinDegrees())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Temperature $div(ThermalCapacity that) {
        return Kelvin$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toJoulesPerKelvin())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public MolarEnergy $div(ChemicalAmount that) {
        return JoulesPerMole$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toMoles())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Torque $div(Angle that) {
        return NewtonMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toJoules() / that.toRadians())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Nothing$ $div(Area that) {
        return Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public PowerRamp $div(TimeSquared that) {
        return (PowerRamp)((TimeIntegral)((Object)this.$div(that.time1()))).$div(that.time2());
    }

    @Override
    public TimeSquared $div(PowerRamp that) {
        return this.$div(that.timeIntegrated()).$times(this.time());
    }

    public double toWattHours() {
        return this.to(WattHours$.MODULE$);
    }

    public double toMilliwattHours() {
        return this.to(MilliwattHours$.MODULE$);
    }

    public double toKilowattHours() {
        return this.to(KilowattHours$.MODULE$);
    }

    public double toMegawattHours() {
        return this.to(MegawattHours$.MODULE$);
    }

    public double toGigawattHours() {
        return this.to(GigawattHours$.MODULE$);
    }

    public double toJoules() {
        return this.to(Joules$.MODULE$);
    }

    public double toPicojoules() {
        return this.to(Picojoules$.MODULE$);
    }

    public double toNanojoules() {
        return this.to(Nanojoules$.MODULE$);
    }

    public double toMicrojoules() {
        return this.to(Microjoules$.MODULE$);
    }

    public double toMillijoules() {
        return this.to(Millijoules$.MODULE$);
    }

    public double toKilojoules() {
        return this.to(Kilojoules$.MODULE$);
    }

    public double toMegajoules() {
        return this.to(Megajoules$.MODULE$);
    }

    public double toGigajoules() {
        return this.to(Gigajoules$.MODULE$);
    }

    public double toTerajoules() {
        return this.to(Terajoules$.MODULE$);
    }

    public double toeV() {
        return this.to(ElectronVolt$.MODULE$);
    }

    public double tomeV() {
        return this.to(MilliElectronVolt$.MODULE$);
    }

    public double tokeV() {
        return this.to(KiloElectronVolt$.MODULE$);
    }

    public double toMeV() {
        return this.to(MegaElectronVolt$.MODULE$);
    }

    public double toGeV() {
        return this.to(GigaElectronVolt$.MODULE$);
    }

    public double toTeV() {
        return this.to(TeraElectronVolt$.MODULE$);
    }

    public double toPeV() {
        return this.to(PetaElectronVolt$.MODULE$);
    }

    public double toEeV() {
        return this.to(ExaElectronVolt$.MODULE$);
    }

    public double toBtus() {
        return this.to(BritishThermalUnits$.MODULE$);
    }

    public double toMBtus() {
        return this.to(MBtus$.MODULE$);
    }

    public double toMMBtus() {
        return this.to(MMBtus$.MODULE$);
    }

    public double toErgs() {
        return this.to(Ergs$.MODULE$);
    }

    public Torque asTorque() {
        return NewtonMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toJoules()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Energy(double value, EnergyUnit unit) {
        this.value = value;
        this.unit = unit;
        TimeIntegral.$init$(this);
        SecondTimeIntegral.$init$(this);
    }
}

