/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.Conductivity;
import squants.electro.ElectricalResistance;
import squants.electro.OhmMeters$;
import squants.electro.Ohms$;
import squants.electro.Resistivity$;
import squants.electro.ResistivityUnit;
import squants.electro.SiemensPerMeter$;
import squants.package$;
import squants.space.Length;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u0005\u001d\u00111BU3tSN$\u0018N^5us*\u00111\u0001B\u0001\bK2,7\r\u001e:p\u0015\u0005)\u0011aB:rk\u0006tGo]\u0002\u0001'\t\u0001\u0001\u0002E\u0002\n\u00151i\u0011\u0001B\u0005\u0003\u0017\u0011\u0011\u0001\"U;b]RLG/\u001f\t\u0003\u001b\u0001i\u0011A\u0001\u0005\t\u001f\u0001\u0011)\u0019!C\u0001!\u0005)a/\u00197vKV\t\u0011\u0003\u0005\u0002\u0013+5\t1CC\u0001\u0015\u0003\u0015\u00198-\u00197b\u0013\t12C\u0001\u0004E_V\u0014G.\u001a\u0005\t1\u0001\u0011\t\u0011)A\u0005#\u00051a/\u00197vK\u0002B\u0001B\u0007\u0001\u0003\u0006\u0004%\taG\u0001\u0005k:LG/F\u0001\u001d!\tiQ$\u0003\u0002\u001f\u0005\ty!+Z:jgRLg/\u001b;z+:LG\u000f\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\u0015)h.\u001b;!\u0011\u0015\u0011\u0003\u0001\"\u0003$\u0003\u0019a\u0014N\\5u}Q\u0019A\u0002J\u0013\t\u000b=\t\u0003\u0019A\t\t\u000bi\t\u0003\u0019\u0001\u000f\t\u000b\u001d\u0002A\u0011\u0001\u0015\u0002\u0013\u0011LW.\u001a8tS>tW#A\u0015\u000f\u00055Qs!B\u0016\u0003\u0011\u0003a\u0013a\u0003*fg&\u001cH/\u001b<jif\u0004\"!D\u0017\u0007\u000b\u0005\u0011\u0001\u0012\u0001\u0018\u0014\t5z#'\u000e\t\u0003%AJ!!M\n\u0003\r\u0005s\u0017PU3g!\rI1\u0007D\u0005\u0003i\u0011\u0011\u0011\u0002R5nK:\u001c\u0018n\u001c8\u0011\u0005I1\u0014BA\u001c\u0014\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015\u0011S\u0006\"\u0001:)\u0005a\u0003BB\u001e.\t\u0003\u0011A(A\u0003baBd\u00170\u0006\u0002>\u001fR\u0019a\b\u0017.\u0015\u00051y\u0004\"\u0002!;\u0001\b\t\u0015a\u00018v[B\u0019!IS'\u000f\u0005\rCeB\u0001#H\u001b\u0005)%B\u0001$\u0007\u0003\u0019a$o\\8u}%\tA#\u0003\u0002J'\u00059\u0001/Y2lC\u001e,\u0017BA&M\u0005\u001dqU/\\3sS\u000eT!!S\n\u0011\u00059{E\u0002\u0001\u0003\u0006!j\u0012\r!\u0015\u0002\u0002\u0003F\u0011!+\u0016\t\u0003%MK!\u0001V\n\u0003\u000f9{G\u000f[5oOB\u0011!CV\u0005\u0003/N\u00111!\u00118z\u0011\u0015I&\b1\u0001N\u0003\u0005q\u0007\"\u0002\u000e;\u0001\u0004a\u0002\"B\u001e.\t\u0003aFCA/d!\rq\u0016\rD\u0007\u0002?*\u0011\u0001mE\u0001\u0005kRLG.\u0003\u0002c?\n\u0019AK]=\t\u000b=Y\u0006\u0019A+\t\u000b\u0015lC\u0011\u00014\u0002\t9\fW.Z\u000b\u0002OB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\u0005Y\u0006twMC\u0001m\u0003\u0011Q\u0017M^1\n\u00059L'AB*ue&tw\rC\u0003q[\u0011\u0005\u0011/A\u0006qe&l\u0017M]=V]&$X#\u0001:\u000f\u00055\u0019\u0018B\u0001;\u0003\u0003%y\u0005.\\'fi\u0016\u00148\u000fC\u0003w[\u0011\u0005\u0011/\u0001\u0004tSVs\u0017\u000e\u001e\u0005\u0006q6\"\t!_\u0001\u0006k:LGo]\u000b\u0002uB)10!\u0001\u0002\u00065\tAP\u0003\u0002~}\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u007fN\t!bY8mY\u0016\u001cG/[8o\u0013\r\t\u0019\u0001 \u0002\u0004'\u0016$\b\u0003B\u0005\u0002\b1I1!!\u0003\u0005\u00055)f.\u001b;PM6+\u0017m];sK\"I\u0011QB\u0017\u0002\u0002\u0013%\u0011qB\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0012A\u0019\u0001.a\u0005\n\u0007\u0005U\u0011N\u0001\u0004PE*,7\r\u001e\u0005\b\u00033\u0001A\u0011AA\u000e\u0003\u0011!C-\u001b<\u0015\t\u0005u\u00111\u0005\t\u0004\u001b\u0005}\u0011bAA\u0011\u0005\t!R\t\\3diJL7-\u00197SKNL7\u000f^1oG\u0016D\u0001\"!\n\u0002\u0018\u0001\u0007\u0011qE\u0001\u0005i\"\fG\u000f\u0005\u0003\u0002*\u0005Eb\u0002BA\u0016\u0003_q1\u0001RA\u0017\u0013\u0005)\u0011BA%\u0005\u0013\u0011\t\u0019$!\u000e\u0003\r1+gn\u001a;i\u0015\tIE\u0001C\u0004\u0002\u001a\u0001!\t!!\u000f\u0015\t\u0005\u001d\u00121\b\u0005\t\u0003K\t9\u00041\u0001\u0002\u001e!1\u0011q\b\u0001\u0005\u0002A\t1\u0002^8PQ6lU\r^3sg\"9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0013!E5o'&,W.\u001a8t!\u0016\u0014X*\u001a;feV\u0011\u0011q\t\t\u0004\u001b\u0005%\u0013bAA&\u0005\ta1i\u001c8ek\u000e$\u0018N^5us\u0002")
public final class Resistivity
extends Quantity<Resistivity> {
    private final double value;
    private final ResistivityUnit unit;

    public static <N> Try<Resistivity> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Resistivity$.MODULE$.parseTuple(tuple2, numeric);
    }

    public static Try<Resistivity> parseString(String string) {
        return Resistivity$.MODULE$.parseString(string);
    }

    public static Option<UnitOfMeasure<Resistivity>> symbolToUnit(String string) {
        return Resistivity$.MODULE$.symbolToUnit(string);
    }

    public static /* bridge */ UnitOfMeasure siUnit() {
        return Resistivity$.MODULE$.siUnit();
    }

    public static /* bridge */ UnitOfMeasure primaryUnit() {
        return Resistivity$.MODULE$.primaryUnit();
    }

    public static Set<UnitOfMeasure<Resistivity>> units() {
        return Resistivity$.MODULE$.units();
    }

    public static OhmMeters$ siUnit() {
        return Resistivity$.MODULE$.siUnit();
    }

    public static OhmMeters$ primaryUnit() {
        return Resistivity$.MODULE$.primaryUnit();
    }

    public static String name() {
        return Resistivity$.MODULE$.name();
    }

    public static Try<Resistivity> apply(Object object) {
        return Resistivity$.MODULE$.apply(object);
    }

    @Override
    public double value() {
        return this.value;
    }

    public ResistivityUnit unit() {
        return this.unit;
    }

    public Resistivity$ dimension() {
        return Resistivity$.MODULE$;
    }

    public ElectricalResistance $div(Length that) {
        return Ohms$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toOhmMeters() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Length $div(ElectricalResistance that) {
        return package$.MODULE$.Meters().apply(BoxesRunTime.boxToDouble((double)(this.toOhmMeters() / that.toOhms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toOhmMeters() {
        return this.to(OhmMeters$.MODULE$);
    }

    public Conductivity inSiemensPerMeter() {
        return SiemensPerMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(1.0 / this.toOhmMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Resistivity(double value, ResistivityUnit unit) {
        this.value = value;
        this.unit = unit;
    }
}

