/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.Amperes$;
import squants.electro.ElectricCurrent;
import squants.electro.ElectricPotential;
import squants.electro.Henry$;
import squants.electro.Inductance;
import squants.electro.MagneticFlux$;
import squants.electro.MagneticFluxDensity;
import squants.electro.MagneticFluxUnit;
import squants.electro.Teslas$;
import squants.electro.Volts$;
import squants.electro.Webers$;
import squants.package$;
import squants.space.Area;
import squants.space.SquareMeters$;
import squants.time.Frequency;
import squants.time.Time;
import squants.time.TimeIntegral;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0005\u001d\u0011A\"T1h]\u0016$\u0018n\u0019$mkbT!a\u0001\u0003\u0002\u000f\u0015dWm\u0019;s_*\tQ!A\u0004tcV\fg\u000e^:\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0007%QA\"D\u0001\u0005\u0013\tYAA\u0001\u0005Rk\u0006tG/\u001b;z!\ti\u0001!D\u0001\u0003!\ry!\u0003F\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0005i&lW-\u0003\u0002\u0014!\taA+[7f\u0013:$Xm\u001a:bYB\u0011Q\"F\u0005\u0003-\t\u0011\u0011#\u00127fGR\u0014\u0018n\u0019)pi\u0016tG/[1m\u0011!A\u0002A!b\u0001\n\u0003I\u0012!\u0002<bYV,W#\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0011{WO\u00197f\u0011!\t\u0003A!A!\u0002\u0013Q\u0012A\u0002<bYV,\u0007\u0005\u0003\u0005$\u0001\t\u0015\r\u0011\"\u0001%\u0003\u0011)h.\u001b;\u0016\u0003\u0015\u0002\"!\u0004\u0014\n\u0005\u001d\u0012!\u0001E'bO:,G/[2GYVDXK\\5u\u0011!I\u0003A!A!\u0002\u0013)\u0013!B;oSR\u0004\u0003\"B\u0016\u0001\t\u0013a\u0013A\u0002\u001fj]&$h\bF\u0002\r[9BQ\u0001\u0007\u0016A\u0002iAQa\t\u0016A\u0002\u0015BQ\u0001\r\u0001\u0005\u0002E\n\u0011\u0002Z5nK:\u001c\u0018n\u001c8\u0016\u0003Ir!!D\u001a\b\u000bQ\u0012\u0001\u0012A\u001b\u0002\u00195\u000bwM\\3uS\u000e4E.\u001e=\u0011\u000551d!B\u0001\u0003\u0011\u000394\u0003\u0002\u001c9wy\u0002\"aG\u001d\n\u0005ib\"AB!osJ+g\rE\u0002\ny1I!!\u0010\u0003\u0003\u0013\u0011KW.\u001a8tS>t\u0007CA\u000e@\u0013\t\u0001ED\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003,m\u0011\u0005!\tF\u00016\u0011\u0019!e\u0007\"\u0001\u0003\u000b\u0006)\u0011\r\u001d9msV\u0011a\t\u0017\u000b\u0004\u000f\u0006\u001cGC\u0001\u0007I\u0011\u0015I5\tq\u0001K\u0003\rqW/\u001c\t\u0004\u0017N3fB\u0001'R\u001d\ti\u0005+D\u0001O\u0015\tye!\u0001\u0004=e>|GOP\u0005\u0002;%\u0011!\u000bH\u0001\ba\u0006\u001c7.Y4f\u0013\t!VKA\u0004Ok6,'/[2\u000b\u0005Ic\u0002CA,Y\u0019\u0001!Q!W\"C\u0002i\u0013\u0011!Q\t\u00037z\u0003\"a\u0007/\n\u0005uc\"a\u0002(pi\"Lgn\u001a\t\u00037}K!\u0001\u0019\u000f\u0003\u0007\u0005s\u0017\u0010C\u0003c\u0007\u0002\u0007a+A\u0001o\u0011\u0015\u00193\t1\u0001&\u0011\u0015!e\u0007\"\u0001f)\t1G\u000eE\u0002hU2i\u0011\u0001\u001b\u0006\u0003Sr\tA!\u001e;jY&\u00111\u000e\u001b\u0002\u0004)JL\b\"\u0002\re\u0001\u0004q\u0006\"\u000287\t\u0003y\u0017\u0001\u00028b[\u0016,\u0012\u0001\u001d\t\u0003cZl\u0011A\u001d\u0006\u0003gR\fA\u0001\\1oO*\tQ/\u0001\u0003kCZ\f\u0017BA<s\u0005\u0019\u0019FO]5oO\")\u0011P\u000eC\u0001u\u0006Y\u0001O]5nCJLXK\\5u+\u0005YhBA\u0007}\u0013\ti(!\u0001\u0004XK\n,'o\u001d\u0005\u0006\u007fZ\"\tA_\u0001\u0007g&,f.\u001b;\t\u000f\u0005\ra\u0007\"\u0001\u0002\u0006\u0005)QO\\5ugV\u0011\u0011q\u0001\t\u0007\u0003\u0013\t\u0019\"a\u0006\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005EA$\u0001\u0006d_2dWm\u0019;j_:LA!!\u0006\u0002\f\t\u00191+\u001a;\u0011\t%\tI\u0002D\u0005\u0004\u00037!!!D+oSR|e-T3bgV\u0014X\rC\u0005\u0002 Y\n\t\u0011\"\u0003\u0002\"\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\u0019\u0003E\u0002r\u0003KI1!a\ns\u0005\u0019y%M[3di\"9\u00111\u0006\u0001\u0005\u0012\u00055\u0012a\u0003;j[\u0016$UM]5wK\u0012,\u0012\u0001\u0006\u0005\u0007#\u0001!\t\"!\r\u0016\u0005\u0005M\u0002cA\b\u00026%\u0019\u0011q\u0007\t\u0003\tQKW.\u001a\u0005\b\u0003w\u0001A\u0011AA\u001f\u0003\u0011!C-\u001b<\u0015\t\u0005}\u0012Q\t\t\u0004\u001b\u0005\u0005\u0013bAA\"\u0005\t\u0019R*Y4oKRL7M\u00127vq\u0012+gn]5us\"A\u0011qIA\u001d\u0001\u0004\tI%\u0001\u0003uQ\u0006$\b\u0003BA&\u0003'rA!!\u0014\u0002R9\u0019Q*a\u0014\n\u0003\u0015I!A\u0015\u0003\n\t\u0005U\u0013q\u000b\u0002\u0005\u0003J,\u0017M\u0003\u0002S\t!9\u00111\b\u0001\u0005\u0002\u0005mC\u0003BA%\u0003;B\u0001\"a\u0012\u0002Z\u0001\u0007\u0011q\b\u0005\b\u0003w\u0001A\u0011AA1)\u0011\t\u0019'!\u001b\u0011\u00075\t)'C\u0002\u0002h\t\u0011!\"\u00138ek\u000e$\u0018M\\2f\u0011!\t9%a\u0018A\u0002\u0005-\u0004cA\u0007\u0002n%\u0019\u0011q\u000e\u0002\u0003\u001f\u0015cWm\u0019;sS\u000e\u001cUO\u001d:f]RDq!a\u000f\u0001\t\u0003\t\u0019\b\u0006\u0003\u0002l\u0005U\u0004\u0002CA$\u0003c\u0002\r!a\u0019\t\r\u0005e\u0004\u0001\"\u0001\u001a\u0003!!xnV3cKJ\u001c\b")
public final class MagneticFlux
extends Quantity<MagneticFlux>
implements TimeIntegral<ElectricPotential> {
    private final double value;
    private final MagneticFluxUnit unit;

    public static <N> Try<MagneticFlux> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return MagneticFlux$.MODULE$.parseTuple(tuple2, numeric);
    }

    public static Try<MagneticFlux> parseString(String string) {
        return MagneticFlux$.MODULE$.parseString(string);
    }

    public static Option<UnitOfMeasure<MagneticFlux>> symbolToUnit(String string) {
        return MagneticFlux$.MODULE$.symbolToUnit(string);
    }

    public static /* bridge */ UnitOfMeasure siUnit() {
        return MagneticFlux$.MODULE$.siUnit();
    }

    public static /* bridge */ UnitOfMeasure primaryUnit() {
        return MagneticFlux$.MODULE$.primaryUnit();
    }

    public static Set<UnitOfMeasure<MagneticFlux>> units() {
        return MagneticFlux$.MODULE$.units();
    }

    public static Webers$ siUnit() {
        return MagneticFlux$.MODULE$.siUnit();
    }

    public static Webers$ primaryUnit() {
        return MagneticFlux$.MODULE$.primaryUnit();
    }

    public static String name() {
        return MagneticFlux$.MODULE$.name();
    }

    public static Try<MagneticFlux> apply(Object object) {
        return MagneticFlux$.MODULE$.apply(object);
    }

    @Override
    public Quantity $div(Time that) {
        return TimeIntegral.$div$((TimeIntegral)this, that);
    }

    @Override
    public Quantity per(Time that) {
        return TimeIntegral.per$(this, that);
    }

    @Override
    public Time $div(Quantity that) {
        return TimeIntegral.$div$((TimeIntegral)this, that);
    }

    @Override
    public Quantity $times(Frequency that) {
        return TimeIntegral.$times$(this, that);
    }

    @Override
    public double value() {
        return this.value;
    }

    public MagneticFluxUnit unit() {
        return this.unit;
    }

    public MagneticFlux$ dimension() {
        return MagneticFlux$.MODULE$;
    }

    @Override
    public ElectricPotential timeDerived() {
        return Volts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toWebers()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return package$.MODULE$.Seconds().apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public MagneticFluxDensity $div(Area that) {
        return Teslas$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWebers() / that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Area $div(MagneticFluxDensity that) {
        return SquareMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWebers() / that.toTeslas())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Inductance $div(ElectricCurrent that) {
        return Henry$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWebers() / that.toAmperes())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricCurrent $div(Inductance that) {
        return Amperes$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWebers() / that.toHenry())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toWebers() {
        return this.to(Webers$.MODULE$);
    }

    public MagneticFlux(double value, MagneticFluxUnit unit) {
        this.value = value;
        this.unit = unit;
        TimeIntegral.$init$(this);
    }
}

