/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.ElectricCurrent;
import squants.electro.HenriesPerMeter$;
import squants.electro.Henry$;
import squants.electro.Inductance$;
import squants.electro.InductanceUnit;
import squants.electro.MagneticFlux;
import squants.electro.Microhenry$;
import squants.electro.Millihenry$;
import squants.electro.Nanohenry$;
import squants.electro.Permeability;
import squants.electro.Picohenry$;
import squants.electro.Webers$;
import squants.space.Length;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u0001\u0003\u0005\u001d\u0011!\"\u00138ek\u000e$\u0018M\\2f\u0015\t\u0019A!A\u0004fY\u0016\u001cGO]8\u000b\u0003\u0015\tqa]9vC:$8o\u0001\u0001\u0014\u0005\u0001A\u0001cA\u0005\u000b\u00195\tA!\u0003\u0002\f\t\tA\u0011+^1oi&$\u0018\u0010\u0005\u0002\u000e\u00015\t!\u0001\u0003\u0005\u0010\u0001\t\u0015\r\u0011\"\u0001\u0011\u0003\u00151\u0018\r\\;f+\u0005\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"A\u0002#pk\ndW\r\u0003\u0005\u0019\u0001\t\u0005\t\u0015!\u0003\u0012\u0003\u00191\u0018\r\\;fA!A!\u0004\u0001BC\u0002\u0013\u00051$\u0001\u0003v]&$X#\u0001\u000f\u0011\u00055i\u0012B\u0001\u0010\u0003\u00059Ie\u000eZ;di\u0006t7-Z+oSRD\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0006k:LG\u000f\t\u0005\u0006E\u0001!IaI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071!S\u0005C\u0003\u0010C\u0001\u0007\u0011\u0003C\u0003\u001bC\u0001\u0007A\u0004C\u0003(\u0001\u0011\u0005\u0001&A\u0005eS6,gn]5p]V\t\u0011F\u0004\u0002\u000eU\u001d)1F\u0001E\u0001Y\u0005Q\u0011J\u001c3vGR\fgnY3\u0011\u00055ic!B\u0001\u0003\u0011\u0003q3\u0003B\u00170eU\u0002\"A\u0005\u0019\n\u0005E\u001a\"AB!osJ+g\rE\u0002\ng1I!\u0001\u000e\u0003\u0003\u0013\u0011KW.\u001a8tS>t\u0007C\u0001\n7\u0013\t94C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003#[\u0011\u0005\u0011\bF\u0001-\u0011\u0019YT\u0006\"\u0001\u0003y\u0005)\u0011\r\u001d9msV\u0011Qh\u0014\u000b\u0004}aSFC\u0001\u0007@\u0011\u0015\u0001%\bq\u0001B\u0003\rqW/\u001c\t\u0004\u0005*keBA\"I\u001d\t!u)D\u0001F\u0015\t1e!\u0001\u0004=e>|GOP\u0005\u0002)%\u0011\u0011jE\u0001\ba\u0006\u001c7.Y4f\u0013\tYEJA\u0004Ok6,'/[2\u000b\u0005%\u001b\u0002C\u0001(P\u0019\u0001!Q\u0001\u0015\u001eC\u0002E\u0013\u0011!Q\t\u0003%V\u0003\"AE*\n\u0005Q\u001b\"a\u0002(pi\"Lgn\u001a\t\u0003%YK!aV\n\u0003\u0007\u0005s\u0017\u0010C\u0003Zu\u0001\u0007Q*A\u0001o\u0011\u0015Q\"\b1\u0001\u001d\u0011\u0015YT\u0006\"\u0001])\ti6\rE\u0002_C2i\u0011a\u0018\u0006\u0003AN\tA!\u001e;jY&\u0011!m\u0018\u0002\u0004)JL\b\"B\b\\\u0001\u0004)\u0006\"B3.\t\u00031\u0017\u0001\u00028b[\u0016,\u0012a\u001a\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\fA\u0001\\1oO*\tA.\u0001\u0003kCZ\f\u0017B\u00018j\u0005\u0019\u0019FO]5oO\")\u0001/\fC\u0001c\u0006Y\u0001O]5nCJLXK\\5u+\u0005\u0011hBA\u0007t\u0013\t!(!A\u0003IK:\u0014\u0018\u0010C\u0003w[\u0011\u0005\u0011/\u0001\u0004tSVs\u0017\u000e\u001e\u0005\u0006q6\"\t!_\u0001\u0006k:LGo]\u000b\u0002uB)10!\u0001\u0002\u00065\tAP\u0003\u0002~}\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u007fN\t!bY8mY\u0016\u001cG/[8o\u0013\r\t\u0019\u0001 \u0002\u0004'\u0016$\b\u0003B\u0005\u0002\b1I1!!\u0003\u0005\u00055)f.\u001b;PM6+\u0017m];sK\"I\u0011QB\u0017\u0002\u0002\u0013%\u0011qB\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0012A\u0019\u0001.a\u0005\n\u0007\u0005U\u0011N\u0001\u0004PE*,7\r\u001e\u0005\b\u00033\u0001A\u0011AA\u000e\u0003\u0019!C/[7fgR!\u0011QDA\u0012!\ri\u0011qD\u0005\u0004\u0003C\u0011!\u0001D'bO:,G/[2GYVD\b\u0002CA\u0013\u0003/\u0001\r!a\n\u0002\tQD\u0017\r\u001e\t\u0004\u001b\u0005%\u0012bAA\u0016\u0005\tyQ\t\\3diJL7mQ;se\u0016tG\u000fC\u0004\u00020\u0001!\t!!\r\u0002\t\u0011\"\u0017N\u001e\u000b\u0005\u0003g\tI\u0004E\u0002\u000e\u0003kI1!a\u000e\u0003\u00051\u0001VM]7fC\nLG.\u001b;z\u0011!\t)#!\fA\u0002\u0005m\u0002\u0003BA\u001f\u0003\u000brA!a\u0010\u0002D9\u0019A)!\u0011\n\u0003\u0015I!!\u0013\u0003\n\t\u0005\u001d\u0013\u0011\n\u0002\u0007\u0019\u0016tw\r\u001e5\u000b\u0005%#\u0001BBA'\u0001\u0011\u0005\u0001#A\u0004u_\"+gN]=\t\r\u0005E\u0003\u0001\"\u0001\u0011\u00031!x.T5mY&DWM\u001c:z\u0011\u0019\t)\u0006\u0001C\u0001!\u0005aAo\\'jGJ|\u0007.\u001a8ss\"1\u0011\u0011\f\u0001\u0005\u0002A\t1\u0002^8OC:|\u0007.\u001a8ss\"1\u0011Q\f\u0001\u0005\u0002A\t1\u0002^8QS\u000e|\u0007.\u001a8ss\u0002")
public final class Inductance
extends Quantity<Inductance> {
    private final double value;
    private final InductanceUnit unit;

    public static <N> Try<Inductance> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Inductance$.MODULE$.parseTuple(tuple2, numeric);
    }

    public static Try<Inductance> parseString(String string) {
        return Inductance$.MODULE$.parseString(string);
    }

    public static Option<UnitOfMeasure<Inductance>> symbolToUnit(String string) {
        return Inductance$.MODULE$.symbolToUnit(string);
    }

    public static /* bridge */ UnitOfMeasure siUnit() {
        return Inductance$.MODULE$.siUnit();
    }

    public static /* bridge */ UnitOfMeasure primaryUnit() {
        return Inductance$.MODULE$.primaryUnit();
    }

    public static Set<UnitOfMeasure<Inductance>> units() {
        return Inductance$.MODULE$.units();
    }

    public static Henry$ siUnit() {
        return Inductance$.MODULE$.siUnit();
    }

    public static Henry$ primaryUnit() {
        return Inductance$.MODULE$.primaryUnit();
    }

    public static String name() {
        return Inductance$.MODULE$.name();
    }

    public static Try<Inductance> apply(Object object) {
        return Inductance$.MODULE$.apply(object);
    }

    @Override
    public double value() {
        return this.value;
    }

    public InductanceUnit unit() {
        return this.unit;
    }

    public Inductance$ dimension() {
        return Inductance$.MODULE$;
    }

    public MagneticFlux $times(ElectricCurrent that) {
        return Webers$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toHenry() * that.toAmperes())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Permeability $div(Length that) {
        return HenriesPerMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toHenry() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toHenry() {
        return this.to(Henry$.MODULE$);
    }

    public double toMillihenry() {
        return this.to(Millihenry$.MODULE$);
    }

    public double toMicrohenry() {
        return this.to(Microhenry$.MODULE$);
    }

    public double toNanohenry() {
        return this.to(Nanohenry$.MODULE$);
    }

    public double toPicohenry() {
        return this.to(Picohenry$.MODULE$);
    }

    public Inductance(double value, InductanceUnit unit) {
        this.value = value;
        this.unit = unit;
    }
}

