/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.ElectricCurrent;
import squants.electro.ElectricPotential;
import squants.electro.ElectricalConductance;
import squants.electro.ElectricalResistance$;
import squants.electro.ElectricalResistanceUnit;
import squants.electro.Gigohms$;
import squants.electro.Kilohms$;
import squants.electro.Megohms$;
import squants.electro.Microohms$;
import squants.electro.Milliohms$;
import squants.electro.Nanohms$;
import squants.electro.OhmMeters$;
import squants.electro.Ohms$;
import squants.electro.Resistivity;
import squants.electro.Siemens$;
import squants.electro.Volts$;
import squants.space.Length;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0005\u001d\u0011A#\u00127fGR\u0014\u0018nY1m%\u0016\u001c\u0018n\u001d;b]\u000e,'BA\u0002\u0005\u0003\u001d)G.Z2ue>T\u0011!B\u0001\bgF,\u0018M\u001c;t\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0007%QA\"D\u0001\u0005\u0013\tYAA\u0001\u0005Rk\u0006tG/\u001b;z!\ti\u0001!D\u0001\u0003\u0011!y\u0001A!b\u0001\n\u0003\u0001\u0012!\u0002<bYV,W#A\t\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0011{WO\u00197f\u0011!A\u0002A!A!\u0002\u0013\t\u0012A\u0002<bYV,\u0007\u0005\u0003\u0005\u001b\u0001\t\u0015\r\u0011\"\u0001\u001c\u0003\u0011)h.\u001b;\u0016\u0003q\u0001\"!D\u000f\n\u0005y\u0011!\u0001G#mK\u000e$(/[2bYJ+7/[:uC:\u001cW-\u00168ji\"A\u0001\u0005\u0001B\u0001B\u0003%A$A\u0003v]&$\b\u0005C\u0003#\u0001\u0011%1%\u0001\u0004=S:LGO\u0010\u000b\u0004\u0019\u0011*\u0003\"B\b\"\u0001\u0004\t\u0002\"\u0002\u000e\"\u0001\u0004a\u0002\"B\u0014\u0001\t\u0003A\u0013!\u00033j[\u0016t7/[8o+\u0005IcBA\u0007+\u000f\u0015Y#\u0001#\u0001-\u0003Q)E.Z2ue&\u001c\u0017\r\u001c*fg&\u001cH/\u00198dKB\u0011Q\"\f\u0004\u0006\u0003\tA\tAL\n\u0005[=\u0012T\u0007\u0005\u0002\u0013a%\u0011\u0011g\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0007%\u0019D\"\u0003\u00025\t\tIA)[7f]NLwN\u001c\t\u0003%YJ!aN\n\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000b\tjC\u0011A\u001d\u0015\u00031BaaO\u0017\u0005\u0002\ta\u0014!B1qa2LXCA\u001fP)\rq\u0004L\u0017\u000b\u0003\u0019}BQ\u0001\u0011\u001eA\u0004\u0005\u000b1A\\;n!\r\u0011%*\u0014\b\u0003\u0007\"s!\u0001R$\u000e\u0003\u0015S!A\u0012\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0012BA%\u0014\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0013'\u0003\u000f9+X.\u001a:jG*\u0011\u0011j\u0005\t\u0003\u001d>c\u0001\u0001B\u0003Qu\t\u0007\u0011KA\u0001B#\t\u0011V\u000b\u0005\u0002\u0013'&\u0011Ak\u0005\u0002\b\u001d>$\b.\u001b8h!\t\u0011b+\u0003\u0002X'\t\u0019\u0011I\\=\t\u000beS\u0004\u0019A'\u0002\u00039DQA\u0007\u001eA\u0002qAQaO\u0017\u0005\u0002q#\"!X2\u0011\u0007y\u000bG\"D\u0001`\u0015\t\u00017#\u0001\u0003vi&d\u0017B\u00012`\u0005\r!&/\u001f\u0005\u0006\u001fm\u0003\r!\u0016\u0005\u0006K6\"\tAZ\u0001\u0005]\u0006lW-F\u0001h!\tAW.D\u0001j\u0015\tQ7.\u0001\u0003mC:<'\"\u00017\u0002\t)\fg/Y\u0005\u0003]&\u0014aa\u0015;sS:<\u0007\"\u00029.\t\u0003\t\u0018a\u00039sS6\f'/_+oSR,\u0012A\u001d\b\u0003\u001bML!\u0001\u001e\u0002\u0002\t=CWn\u001d\u0005\u0006m6\"\t!]\u0001\u0007g&,f.\u001b;\t\u000balC\u0011A=\u0002\u000bUt\u0017\u000e^:\u0016\u0003i\u0004Ra_A\u0001\u0003\u000bi\u0011\u0001 \u0006\u0003{z\f\u0011\"[7nkR\f'\r\\3\u000b\u0005}\u001c\u0012AC2pY2,7\r^5p]&\u0019\u00111\u0001?\u0003\u0007M+G\u000f\u0005\u0003\n\u0003\u000fa\u0011bAA\u0005\t\tiQK\\5u\u001f\u001alU-Y:ve\u0016D\u0011\"!\u0004.\u0003\u0003%I!a\u0004\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003#\u00012\u0001[A\n\u0013\r\t)\"\u001b\u0002\u0007\u001f\nTWm\u0019;\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c\u00051A\u0005^5nKN$B!!\b\u0002$A\u0019Q\"a\b\n\u0007\u0005\u0005\"AA\tFY\u0016\u001cGO]5d!>$XM\u001c;jC2D\u0001\"!\n\u0002\u0018\u0001\u0007\u0011qE\u0001\u0005i\"\fG\u000fE\u0002\u000e\u0003SI1!a\u000b\u0003\u0005=)E.Z2ue&\u001c7)\u001e:sK:$\bbBA\r\u0001\u0011\u0005\u0011q\u0006\u000b\u0005\u0003c\t9\u0004E\u0002\u000e\u0003gI1!!\u000e\u0003\u0005-\u0011Vm]5ti&4\u0018\u000e^=\t\u0011\u0005\u0015\u0012Q\u0006a\u0001\u0003s\u0001B!a\u000f\u0002D9!\u0011QHA!\u001d\r!\u0015qH\u0005\u0002\u000b%\u0011\u0011\nB\u0005\u0005\u0003\u000b\n9E\u0001\u0004MK:<G\u000f\u001b\u0006\u0003\u0013\u0012Aa!a\u0013\u0001\t\u0003\u0001\u0012A\u0002;p\u001f\"l7\u000f\u0003\u0004\u0002P\u0001!\t\u0001E\u0001\ni>t\u0015M\\8i[NDa!a\u0015\u0001\t\u0003\u0001\u0012A\u0003;p\u001b&\u001c'o\u001c5ng\"1\u0011q\u000b\u0001\u0005\u0002A\t!\u0002^8NS2dw\u000e[7t\u0011\u0019\tY\u0006\u0001C\u0001!\u0005IAo\\&jY>DWn\u001d\u0005\u0007\u0003?\u0002A\u0011\u0001\t\u0002\u0013Q|W*Z4pQ6\u001c\bBBA2\u0001\u0011\u0005\u0001#A\u0005u_\u001eKwm\u001c5ng\"9\u0011q\r\u0001\u0005\u0002\u0005%\u0014!C5o'&,W.\u001a8t+\t\tY\u0007E\u0002\u000e\u0003[J1!a\u001c\u0003\u0005U)E.Z2ue&\u001c\u0017\r\\\"p]\u0012,8\r^1oG\u0016\u0004")
public final class ElectricalResistance
extends Quantity<ElectricalResistance> {
    private final double value;
    private final ElectricalResistanceUnit unit;

    public static <N> Try<ElectricalResistance> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return ElectricalResistance$.MODULE$.parseTuple(tuple2, numeric);
    }

    public static Try<ElectricalResistance> parseString(String string) {
        return ElectricalResistance$.MODULE$.parseString(string);
    }

    public static Option<UnitOfMeasure<ElectricalResistance>> symbolToUnit(String string) {
        return ElectricalResistance$.MODULE$.symbolToUnit(string);
    }

    public static /* bridge */ UnitOfMeasure siUnit() {
        return ElectricalResistance$.MODULE$.siUnit();
    }

    public static /* bridge */ UnitOfMeasure primaryUnit() {
        return ElectricalResistance$.MODULE$.primaryUnit();
    }

    public static Set<UnitOfMeasure<ElectricalResistance>> units() {
        return ElectricalResistance$.MODULE$.units();
    }

    public static Ohms$ siUnit() {
        return ElectricalResistance$.MODULE$.siUnit();
    }

    public static Ohms$ primaryUnit() {
        return ElectricalResistance$.MODULE$.primaryUnit();
    }

    public static String name() {
        return ElectricalResistance$.MODULE$.name();
    }

    public static Try<ElectricalResistance> apply(Object object) {
        return ElectricalResistance$.MODULE$.apply(object);
    }

    @Override
    public double value() {
        return this.value;
    }

    public ElectricalResistanceUnit unit() {
        return this.unit;
    }

    public ElectricalResistance$ dimension() {
        return ElectricalResistance$.MODULE$;
    }

    public ElectricPotential $times(ElectricCurrent that) {
        return Volts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toOhms() * that.toAmperes())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Resistivity $times(Length that) {
        return OhmMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toOhms() * that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toOhms() {
        return this.to(Ohms$.MODULE$);
    }

    public double toNanohms() {
        return this.to(Nanohms$.MODULE$);
    }

    public double toMicrohms() {
        return this.to(Microohms$.MODULE$);
    }

    public double toMillohms() {
        return this.to(Milliohms$.MODULE$);
    }

    public double toKilohms() {
        return this.to(Kilohms$.MODULE$);
    }

    public double toMegohms() {
        return this.to(Megohms$.MODULE$);
    }

    public double toGigohms() {
        return this.to(Gigohms$.MODULE$);
    }

    public ElectricalConductance inSiemens() {
        return Siemens$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(1.0 / this.to(Ohms$.MODULE$))), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricalResistance(double value, ElectricalResistanceUnit unit) {
        this.value = value;
        this.unit = unit;
    }
}

