/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.Conductivity;
import squants.electro.ElectricalConductance$;
import squants.electro.ElectricalConductanceUnit;
import squants.electro.ElectricalResistance;
import squants.electro.Ohms$;
import squants.electro.Siemens$;
import squants.electro.SiemensPerMeter$;
import squants.package$;
import squants.space.Length;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u0005\u001d\u0011Q#\u00127fGR\u0014\u0018nY1m\u0007>tG-^2uC:\u001cWM\u0003\u0002\u0004\t\u00059Q\r\\3diJ|'\"A\u0003\u0002\u000fM\fX/\u00198ug\u000e\u00011C\u0001\u0001\t!\rI!\u0002D\u0007\u0002\t%\u00111\u0002\u0002\u0002\t#V\fg\u000e^5usB\u0011Q\u0002A\u0007\u0002\u0005!Aq\u0002\u0001BC\u0002\u0013\u0005\u0001#A\u0003wC2,X-F\u0001\u0012!\t\u0011R#D\u0001\u0014\u0015\u0005!\u0012!B:dC2\f\u0017B\u0001\f\u0014\u0005\u0019!u.\u001e2mK\"A\u0001\u0004\u0001B\u0001B\u0003%\u0011#\u0001\u0004wC2,X\r\t\u0005\t5\u0001\u0011)\u0019!C\u00017\u0005!QO\\5u+\u0005a\u0002CA\u0007\u001e\u0013\tq\"AA\rFY\u0016\u001cGO]5dC2\u001cuN\u001c3vGR\fgnY3V]&$\b\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u000bUt\u0017\u000e\u001e\u0011\t\u000b\t\u0002A\u0011B\u0012\u0002\rqJg.\u001b;?)\raA%\n\u0005\u0006\u001f\u0005\u0002\r!\u0005\u0005\u00065\u0005\u0002\r\u0001\b\u0005\u0006O\u0001!\t\u0001K\u0001\nI&lWM\\:j_:,\u0012!\u000b\b\u0003\u001b):Qa\u000b\u0002\t\u00021\nQ#\u00127fGR\u0014\u0018nY1m\u0007>tG-^2uC:\u001cW\r\u0005\u0002\u000e[\u0019)\u0011A\u0001E\u0001]M!Qf\f\u001a6!\t\u0011\u0002'\u0003\u00022'\t1\u0011I\\=SK\u001a\u00042!C\u001a\r\u0013\t!DAA\u0005ES6,gn]5p]B\u0011!CN\u0005\u0003oM\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQAI\u0017\u0005\u0002e\"\u0012\u0001\f\u0005\u0007w5\"\tA\u0001\u001f\u0002\u000b\u0005\u0004\b\u000f\\=\u0016\u0005uzEc\u0001 Y5R\u0011Ab\u0010\u0005\u0006\u0001j\u0002\u001d!Q\u0001\u0004]Vl\u0007c\u0001\"K\u001b:\u00111\t\u0013\b\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r\u001a\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000b\n\u0005%\u001b\u0012a\u00029bG.\fw-Z\u0005\u0003\u00172\u0013qAT;nKJL7M\u0003\u0002J'A\u0011aj\u0014\u0007\u0001\t\u0015\u0001&H1\u0001R\u0005\u0005\t\u0015C\u0001*V!\t\u00112+\u0003\u0002U'\t9aj\u001c;iS:<\u0007C\u0001\nW\u0013\t96CA\u0002B]fDQ!\u0017\u001eA\u00025\u000b\u0011A\u001c\u0005\u00065i\u0002\r\u0001\b\u0005\u0006w5\"\t\u0001\u0018\u000b\u0003;\u000e\u00042AX1\r\u001b\u0005y&B\u00011\u0014\u0003\u0011)H/\u001b7\n\u0005\t|&a\u0001+ss\")qb\u0017a\u0001+\")Q-\fC\u0001M\u0006!a.Y7f+\u00059\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003\u0011a\u0017M\\4\u000b\u00031\fAA[1wC&\u0011a.\u001b\u0002\u0007'R\u0014\u0018N\\4\t\u000bAlC\u0011A9\u0002\u0017A\u0014\u0018.\\1ssVs\u0017\u000e^\u000b\u0002e:\u0011Qb]\u0005\u0003i\n\tqaU5f[\u0016t7\u000fC\u0003w[\u0011\u0005\u0011/\u0001\u0004tSVs\u0017\u000e\u001e\u0005\u0006q6\"\t!_\u0001\u0006k:LGo]\u000b\u0002uB)10!\u0001\u0002\u00065\tAP\u0003\u0002~}\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003\u007fN\t!bY8mY\u0016\u001cG/[8o\u0013\r\t\u0019\u0001 \u0002\u0004'\u0016$\b\u0003B\u0005\u0002\b1I1!!\u0003\u0005\u00055)f.\u001b;PM6+\u0017m];sK\"I\u0011QB\u0017\u0002\u0002\u0013%\u0011qB\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0012A\u0019\u0001.a\u0005\n\u0007\u0005U\u0011N\u0001\u0004PE*,7\r\u001e\u0005\b\u00033\u0001A\u0011AA\u000e\u0003\u0011!C-\u001b<\u0015\t\u0005u\u00111\u0005\t\u0004\u001b\u0005}\u0011bAA\u0011\u0005\ta1i\u001c8ek\u000e$\u0018N^5us\"A\u0011QEA\f\u0001\u0004\t9#\u0001\u0003uQ\u0006$\b\u0003BA\u0015\u0003cqA!a\u000b\u000209\u0019A)!\f\n\u0003\u0015I!!\u0013\u0003\n\t\u0005M\u0012Q\u0007\u0002\u0007\u0019\u0016tw\r\u001e5\u000b\u0005%#\u0001bBA\r\u0001\u0011\u0005\u0011\u0011\b\u000b\u0005\u0003O\tY\u0004\u0003\u0005\u0002&\u0005]\u0002\u0019AA\u000f\u0011\u0019\ty\u0004\u0001C\u0001!\u0005IAo\\*jK6,gn\u001d\u0005\b\u0003\u0007\u0002A\u0011AA#\u0003\u0019Ign\u00145ngV\u0011\u0011q\t\t\u0004\u001b\u0005%\u0013bAA&\u0005\t!R\t\\3diJL7-\u00197SKNL7\u000f^1oG\u0016\u0004")
public final class ElectricalConductance
extends Quantity<ElectricalConductance> {
    private final double value;
    private final ElectricalConductanceUnit unit;

    public static <N> Try<ElectricalConductance> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return ElectricalConductance$.MODULE$.parseTuple(tuple2, numeric);
    }

    public static Try<ElectricalConductance> parseString(String string) {
        return ElectricalConductance$.MODULE$.parseString(string);
    }

    public static Option<UnitOfMeasure<ElectricalConductance>> symbolToUnit(String string) {
        return ElectricalConductance$.MODULE$.symbolToUnit(string);
    }

    public static /* bridge */ UnitOfMeasure siUnit() {
        return ElectricalConductance$.MODULE$.siUnit();
    }

    public static /* bridge */ UnitOfMeasure primaryUnit() {
        return ElectricalConductance$.MODULE$.primaryUnit();
    }

    public static Set<UnitOfMeasure<ElectricalConductance>> units() {
        return ElectricalConductance$.MODULE$.units();
    }

    public static Siemens$ siUnit() {
        return ElectricalConductance$.MODULE$.siUnit();
    }

    public static Siemens$ primaryUnit() {
        return ElectricalConductance$.MODULE$.primaryUnit();
    }

    public static String name() {
        return ElectricalConductance$.MODULE$.name();
    }

    public static Try<ElectricalConductance> apply(Object object) {
        return ElectricalConductance$.MODULE$.apply(object);
    }

    @Override
    public double value() {
        return this.value;
    }

    public ElectricalConductanceUnit unit() {
        return this.unit;
    }

    public ElectricalConductance$ dimension() {
        return ElectricalConductance$.MODULE$;
    }

    public Conductivity $div(Length that) {
        return SiemensPerMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSiemens() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Length $div(Conductivity that) {
        return package$.MODULE$.Meters().apply(BoxesRunTime.boxToDouble((double)(this.toSiemens() / that.toSiemensPerMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toSiemens() {
        return this.to(Siemens$.MODULE$);
    }

    public ElectricalResistance inOhms() {
        return Ohms$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(1.0 / this.value())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricalConductance(double value, ElectricalConductanceUnit unit) {
        this.value = value;
        this.unit = unit;
    }
}

