/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import squants.Quantity;
import squants.SiBaseUnit;
import squants.UnitOfMeasure;
import squants.electro.Amperes$;
import squants.electro.AmperesPerMeter$;
import squants.electro.AmperesPerSquareMeter$;
import squants.electro.Coulombs$;
import squants.electro.ElectricCharge;
import squants.electro.ElectricCurrent$;
import squants.electro.ElectricCurrentDensity;
import squants.electro.ElectricCurrentUnit;
import squants.electro.ElectricPotential;
import squants.electro.ElectricalConductance;
import squants.electro.ElectricalResistance;
import squants.electro.Inductance;
import squants.electro.MagneticFieldStrength;
import squants.electro.MagneticFlux;
import squants.electro.Milliamperes$;
import squants.electro.Siemens$;
import squants.electro.Volts$;
import squants.electro.Webers$;
import squants.energy.Power;
import squants.energy.Watts$;
import squants.space.Area;
import squants.space.Length;
import squants.time.Seconds$;
import squants.time.Time;
import squants.time.TimeDerivative;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001B\u0001\u0003\u0005\u001d\u0011q\"\u00127fGR\u0014\u0018nY\"veJ,g\u000e\u001e\u0006\u0003\u0007\u0011\tq!\u001a7fGR\u0014xNC\u0001\u0006\u0003\u001d\u0019\u0018/^1oiN\u001c\u0001aE\u0002\u0001\u00119\u00012!\u0003\u0006\r\u001b\u0005!\u0011BA\u0006\u0005\u0005!\tV/\u00198uSRL\bCA\u0007\u0001\u001b\u0005\u0011\u0001cA\b\u0013)5\t\u0001C\u0003\u0002\u0012\t\u0005!A/[7f\u0013\t\u0019\u0002C\u0001\bUS6,G)\u001a:jm\u0006$\u0018N^3\u0011\u00055)\u0012B\u0001\f\u0003\u00059)E.Z2ue&\u001c7\t[1sO\u0016D\u0001\u0002\u0007\u0001\u0003\u0006\u0004%\t!G\u0001\u0006m\u0006dW/Z\u000b\u00025A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1Ai\\;cY\u0016D\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0007m\u0006dW/\u001a\u0011\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\nA!\u001e8jiV\tQ\u0005\u0005\u0002\u000eM%\u0011qE\u0001\u0002\u0014\u000b2,7\r\u001e:jG\u000e+(O]3oiVs\u0017\u000e\u001e\u0005\tS\u0001\u0011\t\u0011)A\u0005K\u0005)QO\\5uA!)1\u0006\u0001C\u0005Y\u00051A(\u001b8jiz\"2\u0001D\u0017/\u0011\u0015A\"\u00061\u0001\u001b\u0011\u0015\u0019#\u00061\u0001&\u0011\u0015\u0001\u0004\u0001\"\u00012\u0003%!\u0017.\\3og&|g.F\u00013\u001d\ti1gB\u00035\u0005!\u0005Q'A\bFY\u0016\u001cGO]5d\u0007V\u0014(/\u001a8u!\tiaGB\u0003\u0002\u0005!\u0005qgE\u00037qmr\u0014\t\u0005\u0002\u001cs%\u0011!\b\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0007%aD\"\u0003\u0002>\t\tIA)[7f]NLwN\u001c\t\u0003\u0013}J!\u0001\u0011\u0003\u0003\u001b\t\u000b7/\u001a#j[\u0016t7/[8o!\tY\")\u0003\u0002D9\ta1+\u001a:jC2L'0\u00192mK\")1F\u000eC\u0001\u000bR\tQ\u0007\u0003\u0004Hm\u0011\u0005!\u0001S\u0001\u0006CB\u0004H._\u000b\u0003\u0013n#2A\u00133g)\ta1\nC\u0003M\r\u0002\u000fQ*A\u0002ok6\u00042A\u0014,Z\u001d\tyEK\u0004\u0002Q'6\t\u0011K\u0003\u0002S\r\u00051AH]8pizJ\u0011!H\u0005\u0003+r\tq\u0001]1dW\u0006<W-\u0003\u0002X1\n9a*^7fe&\u001c'BA+\u001d!\tQ6\f\u0004\u0001\u0005\u000bq3%\u0019A/\u0003\u0003\u0005\u000b\"AX1\u0011\u0005my\u0016B\u00011\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"a\u00072\n\u0005\rd\"aA!os\")QM\u0012a\u00013\u0006\ta\u000eC\u0003$\r\u0002\u0007Q\u0005C\u0003Hm\u0011\u0005\u0001\u000e\u0006\u0002j_B\u0019!.\u001c\u0007\u000e\u0003-T!\u0001\u001c\u000f\u0002\tU$\u0018\u000e\\\u0005\u0003].\u00141\u0001\u0016:z\u0011\u0015Ar\r1\u0001b\u0011\u0015\th\u0007\"\u0001s\u0003\u0011q\u0017-\\3\u0016\u0003M\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\t1\fgn\u001a\u0006\u0002q\u0006!!.\u0019<b\u0013\tQXO\u0001\u0004TiJLgn\u001a\u0005\u0006yZ\"\t!`\u0001\faJLW.\u0019:z+:LG/F\u0001\u007f\u001d\tiq0C\u0002\u0002\u0002\t\tq!Q7qKJ,7\u000f\u0003\u0004\u0002\u0006Y\"\t!`\u0001\u0007g&,f.\u001b;\t\u000f\u0005%a\u0007\"\u0001\u0002\f\u0005)QO\\5ugV\u0011\u0011Q\u0002\t\u0007\u0003\u001f\tI\"!\b\u000e\u0005\u0005E!\u0002BA\n\u0003+\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005]A$\u0001\u0006d_2dWm\u0019;j_:LA!a\u0007\u0002\u0012\t\u00191+\u001a;\u0011\t%\ty\u0002D\u0005\u0004\u0003C!!!D+oSR|e-T3bgV\u0014X\r\u0003\u0004\u0002&Y\"\tA]\u0001\u0010I&lWM\\:j_:\u001c\u00160\u001c2pY\"I\u0011\u0011\u0006\u001c\u0002\u0002\u0013%\u00111F\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002.A\u0019A/a\f\n\u0007\u0005ERO\u0001\u0004PE*,7\r\u001e\u0005\t\u0003k\u0001A\u0011\u0003\u0003\u00028\u0005qA/[7f\u0013:$Xm\u001a:bi\u0016$W#\u0001\u000b\t\u000fE\u0001A\u0011\u0003\u0003\u0002<U\u0011\u0011Q\b\t\u0004\u001f\u0005}\u0012bAA!!\t!A+[7f\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000f\na\u0001\n;j[\u0016\u001cH\u0003BA%\u0003\u001f\u00022!DA&\u0013\r\tiE\u0001\u0002\u0012\u000b2,7\r\u001e:jGB{G/\u001a8uS\u0006d\u0007\u0002CA)\u0003\u0007\u0002\r!a\u0015\u0002\tQD\u0017\r\u001e\t\u0004\u001b\u0005U\u0013bAA,\u0005\t!R\t\\3diJL7-\u00197SKNL7\u000f^1oG\u0016Dq!!\u0012\u0001\t\u0003\tY\u0006\u0006\u0003\u0002^\u00055\u0004\u0003BA0\u0003OrA!!\u0019\u0002f9\u0019\u0001+a\u0019\n\u0003\u0015I!!\u0016\u0003\n\t\u0005%\u00141\u000e\u0002\u0006!><XM\u001d\u0006\u0003+\u0012A\u0001\"!\u0015\u0002Z\u0001\u0007\u0011\u0011\n\u0005\b\u0003\u000b\u0002A\u0011AA9)\u0011\t\u0019(!\u001f\u0011\u00075\t)(C\u0002\u0002x\t\u0011A\"T1h]\u0016$\u0018n\u0019$mkbD\u0001\"!\u0015\u0002p\u0001\u0007\u00111\u0010\t\u0004\u001b\u0005u\u0014bAA@\u0005\tQ\u0011J\u001c3vGR\fgnY3\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\u0006!A\u0005Z5w)\u0011\t9)!$\u0011\u00075\tI)C\u0002\u0002\f\n\u0011Q#\u00127fGR\u0014\u0018nY1m\u0007>tG-^2uC:\u001cW\r\u0003\u0005\u0002R\u0005\u0005\u0005\u0019AA%\u0011\u001d\t\u0019\t\u0001C\u0001\u0003##B!a%\u0002\u001aB\u0019Q\"!&\n\u0007\u0005]%AA\u000bNC\u001etW\r^5d\r&,G\u000eZ*ue\u0016tw\r\u001e5\t\u0011\u0005E\u0013q\u0012a\u0001\u00037\u0003B!a\u0018\u0002\u001e&!\u0011qTA6\u0005\u0019aUM\\4uQ\"9\u00111\u0011\u0001\u0005\u0002\u0005\rF\u0003BAS\u0003W\u00032!DAT\u0013\r\tIK\u0001\u0002\u0017\u000b2,7\r\u001e:jG\u000e+(O]3oi\u0012+gn]5us\"A\u0011\u0011KAQ\u0001\u0004\ti\u000b\u0005\u0003\u0002`\u0005=\u0016\u0002BAY\u0003W\u0012A!\u0011:fC\"1\u0011Q\u0017\u0001\u0005\u0002e\t\u0011\u0002^8B[B,'/Z:\t\r\u0005e\u0006\u0001\"\u0001\u001a\u00039!x.T5mY&\fW\u000e]3sKN\u0004")
public final class ElectricCurrent
extends Quantity<ElectricCurrent>
implements TimeDerivative<ElectricCharge> {
    private final double value;
    private final ElectricCurrentUnit unit;

    public static <N> Try<ElectricCurrent> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return ElectricCurrent$.MODULE$.parseTuple(tuple2, numeric);
    }

    public static Try<ElectricCurrent> parseString(String string) {
        return ElectricCurrent$.MODULE$.parseString(string);
    }

    public static Option<UnitOfMeasure<ElectricCurrent>> symbolToUnit(String string) {
        return ElectricCurrent$.MODULE$.symbolToUnit(string);
    }

    public static /* bridge */ UnitOfMeasure siUnit() {
        return ElectricCurrent$.MODULE$.siUnit();
    }

    public static /* bridge */ SiBaseUnit siUnit() {
        return ElectricCurrent$.MODULE$.siUnit();
    }

    public static /* bridge */ UnitOfMeasure primaryUnit() {
        return ElectricCurrent$.MODULE$.primaryUnit();
    }

    public static String dimensionSymbol() {
        return ElectricCurrent$.MODULE$.dimensionSymbol();
    }

    public static Set<UnitOfMeasure<ElectricCurrent>> units() {
        return ElectricCurrent$.MODULE$.units();
    }

    public static Amperes$ siUnit() {
        return ElectricCurrent$.MODULE$.siUnit();
    }

    public static Amperes$ primaryUnit() {
        return ElectricCurrent$.MODULE$.primaryUnit();
    }

    public static String name() {
        return ElectricCurrent$.MODULE$.name();
    }

    public static Try<ElectricCurrent> apply(Object object) {
        return ElectricCurrent$.MODULE$.apply(object);
    }

    @Override
    public Quantity $times(Time that) {
        return TimeDerivative.$times$(this, that);
    }

    @Override
    public double value() {
        return this.value;
    }

    public ElectricCurrentUnit unit() {
        return this.unit;
    }

    public ElectricCurrent$ dimension() {
        return ElectricCurrent$.MODULE$;
    }

    @Override
    public ElectricCharge timeIntegrated() {
        return Coulombs$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toAmperes()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Seconds$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public ElectricPotential $times(ElectricalResistance that) {
        return Volts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() * that.toOhms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Power $times(ElectricPotential that) {
        return Watts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() * that.toVolts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public MagneticFlux $times(Inductance that) {
        return Webers$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() * that.toHenry())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricalConductance $div(ElectricPotential that) {
        return Siemens$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() / that.toVolts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public MagneticFieldStrength $div(Length that) {
        return AmperesPerMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricCurrentDensity $div(Area that) {
        return AmperesPerSquareMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toAmperes() / that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toAmperes() {
        return this.to(Amperes$.MODULE$);
    }

    public double toMilliamperes() {
        return this.to(Milliamperes$.MODULE$);
    }

    public ElectricCurrent(double value, ElectricCurrentUnit unit) {
        this.value = value;
        this.unit = unit;
        TimeDerivative.$init$(this);
    }
}

