/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.Conductivity$;
import squants.electro.ConductivityUnit;
import squants.electro.ElectricalConductance;
import squants.electro.OhmMeters$;
import squants.electro.Resistivity;
import squants.electro.Siemens$;
import squants.electro.SiemensPerMeter$;
import squants.space.Length;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u0001\u0003\u0005\u001d\u0011AbQ8oIV\u001cG/\u001b<jifT!a\u0001\u0003\u0002\u000f\u0015dWm\u0019;s_*\tQ!A\u0004tcV\fg\u000e^:\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0004\u0013)aQ\"\u0001\u0003\n\u0005-!!\u0001C)vC:$\u0018\u000e^=\u0011\u00055\u0001Q\"\u0001\u0002\t\u0011=\u0001!Q1A\u0005\u0002A\tQA^1mk\u0016,\u0012!\u0005\t\u0003%Ui\u0011a\u0005\u0006\u0002)\u0005)1oY1mC&\u0011ac\u0005\u0002\u0007\t>,(\r\\3\t\u0011a\u0001!\u0011!Q\u0001\nE\taA^1mk\u0016\u0004\u0003\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011A\u000e\u0002\tUt\u0017\u000e^\u000b\u00029A\u0011Q\"H\u0005\u0003=\t\u0011\u0001cQ8oIV\u001cG/\u001b<jif,f.\u001b;\t\u0011\u0001\u0002!\u0011!Q\u0001\nq\tQ!\u001e8ji\u0002BQA\t\u0001\u0005\n\r\na\u0001P5oSRtDc\u0001\u0007%K!)q\"\ta\u0001#!)!$\ta\u00019!)q\u0005\u0001C\u0001Q\u0005IA-[7f]NLwN\\\u000b\u0002S9\u0011QBK\u0004\u0006W\tA\t\u0001L\u0001\r\u0007>tG-^2uSZLG/\u001f\t\u0003\u001b52Q!\u0001\u0002\t\u00029\u001aB!L\u00183kA\u0011!\u0003M\u0005\u0003cM\u0011a!\u00118z%\u00164\u0007cA\u00054\u0019%\u0011A\u0007\u0002\u0002\n\t&lWM\\:j_:\u0004\"A\u0005\u001c\n\u0005]\u001a\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\u0012.\t\u0003ID#\u0001\u0017\t\rmjC\u0011\u0001\u0002=\u0003\u0015\t\u0007\u000f\u001d7z+\tit\nF\u0002?1j#\"\u0001D \t\u000b\u0001S\u00049A!\u0002\u00079,X\u000eE\u0002C\u00156s!a\u0011%\u000f\u0005\u0011;U\"A#\u000b\u0005\u00193\u0011A\u0002\u001fs_>$h(C\u0001\u0015\u0013\tI5#A\u0004qC\u000e\\\u0017mZ3\n\u0005-c%a\u0002(v[\u0016\u0014\u0018n\u0019\u0006\u0003\u0013N\u0001\"AT(\r\u0001\u0011)\u0001K\u000fb\u0001#\n\t\u0011)\u0005\u0002S+B\u0011!cU\u0005\u0003)N\u0011qAT8uQ&tw\r\u0005\u0002\u0013-&\u0011qk\u0005\u0002\u0004\u0003:L\b\"B-;\u0001\u0004i\u0015!\u00018\t\u000biQ\u0004\u0019\u0001\u000f\t\u000bmjC\u0011\u0001/\u0015\u0005u\u001b\u0007c\u00010b\u00195\tqL\u0003\u0002a'\u0005!Q\u000f^5m\u0013\t\u0011wLA\u0002UefDQaD.A\u0002UCQ!Z\u0017\u0005\u0002\u0019\fAA\\1nKV\tq\r\u0005\u0002i[6\t\u0011N\u0003\u0002kW\u0006!A.\u00198h\u0015\u0005a\u0017\u0001\u00026bm\u0006L!A\\5\u0003\rM#(/\u001b8h\u0011\u0015\u0001X\u0006\"\u0001r\u0003-\u0001(/[7bef,f.\u001b;\u0016\u0003It!!D:\n\u0005Q\u0014\u0011aD*jK6,gn\u001d)fe6+G/\u001a:\t\u000bYlC\u0011A9\u0002\rMLWK\\5u\u0011\u0015AX\u0006\"\u0001z\u0003\u0015)h.\u001b;t+\u0005Q\b#B>\u0002\u0002\u0005\u0015Q\"\u0001?\u000b\u0005ut\u0018!C5n[V$\u0018M\u00197f\u0015\ty8#\u0001\u0006d_2dWm\u0019;j_:L1!a\u0001}\u0005\r\u0019V\r\u001e\t\u0005\u0013\u0005\u001dA\"C\u0002\u0002\n\u0011\u0011Q\"\u00168ji>3W*Z1tkJ,\u0007\"CA\u0007[\u0005\u0005I\u0011BA\b\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005E\u0001c\u00015\u0002\u0014%\u0019\u0011QC5\u0003\r=\u0013'.Z2u\u0011\u001d\tI\u0002\u0001C\u0001\u00037\ta\u0001\n;j[\u0016\u001cH\u0003BA\u000f\u0003G\u00012!DA\u0010\u0013\r\t\tC\u0001\u0002\u0016\u000b2,7\r\u001e:jG\u0006d7i\u001c8ek\u000e$\u0018M\\2f\u0011!\t)#a\u0006A\u0002\u0005\u001d\u0012\u0001\u0002;iCR\u0004B!!\u000b\u000205\u0011\u00111\u0006\u0006\u0004\u0003[!\u0011!B:qC\u000e,\u0017\u0002BA\u0019\u0003W\u0011a\u0001T3oORD\u0007BBA\u001b\u0001\u0011\u0005\u0001#A\tu_NKW-\\3ogB+'/T3uKJDq!!\u000f\u0001\t\u0003\tY$A\u0006j]>CW.T3uKJ\u001cXCAA\u001f!\ri\u0011qH\u0005\u0004\u0003\u0003\u0012!a\u0003*fg&\u001cH/\u001b<jif\u0004")
public final class Conductivity
extends Quantity<Conductivity> {
    private final double value;
    private final ConductivityUnit unit;

    public static <N> Try<Conductivity> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Conductivity$.MODULE$.parseTuple(tuple2, numeric);
    }

    public static Try<Conductivity> parseString(String string) {
        return Conductivity$.MODULE$.parseString(string);
    }

    public static Option<UnitOfMeasure<Conductivity>> symbolToUnit(String string) {
        return Conductivity$.MODULE$.symbolToUnit(string);
    }

    public static /* bridge */ UnitOfMeasure siUnit() {
        return Conductivity$.MODULE$.siUnit();
    }

    public static /* bridge */ UnitOfMeasure primaryUnit() {
        return Conductivity$.MODULE$.primaryUnit();
    }

    public static Set<UnitOfMeasure<Conductivity>> units() {
        return Conductivity$.MODULE$.units();
    }

    public static SiemensPerMeter$ siUnit() {
        return Conductivity$.MODULE$.siUnit();
    }

    public static SiemensPerMeter$ primaryUnit() {
        return Conductivity$.MODULE$.primaryUnit();
    }

    public static String name() {
        return Conductivity$.MODULE$.name();
    }

    public static Try<Conductivity> apply(Object object) {
        return Conductivity$.MODULE$.apply(object);
    }

    @Override
    public double value() {
        return this.value;
    }

    public ConductivityUnit unit() {
        return this.unit;
    }

    public Conductivity$ dimension() {
        return Conductivity$.MODULE$;
    }

    public ElectricalConductance $times(Length that) {
        return Siemens$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toSiemensPerMeter() * that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toSiemensPerMeter() {
        return this.to(SiemensPerMeter$.MODULE$);
    }

    public Resistivity inOhmMeters() {
        return OhmMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(1.0 / this.toSiemensPerMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Conductivity(double value, ConductivityUnit unit) {
        this.value = value;
        this.unit = unit;
    }
}

