/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import squants.Quantity;
import squants.UnitOfMeasure;
import squants.electro.Capacitance$;
import squants.electro.CapacitanceUnit;
import squants.electro.Coulombs$;
import squants.electro.ElectricCharge;
import squants.electro.ElectricPotential;
import squants.electro.Farads$;
import squants.electro.FaradsPerMeter$;
import squants.electro.Kilofarads$;
import squants.electro.Microfarads$;
import squants.electro.Millifarads$;
import squants.electro.Nanofarads$;
import squants.electro.Permittivity;
import squants.electro.Picofarads$;
import squants.space.Length;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u0005\u001d\u00111bQ1qC\u000eLG/\u00198dK*\u00111\u0001B\u0001\bK2,7\r\u001e:p\u0015\u0005)\u0011aB:rk\u0006tGo]\u0002\u0001'\t\u0001\u0001\u0002E\u0002\n\u00151i\u0011\u0001B\u0005\u0003\u0017\u0011\u0011\u0001\"U;b]RLG/\u001f\t\u0003\u001b\u0001i\u0011A\u0001\u0005\t\u001f\u0001\u0011)\u0019!C\u0001!\u0005)a/\u00197vKV\t\u0011\u0003\u0005\u0002\u0013+5\t1CC\u0001\u0015\u0003\u0015\u00198-\u00197b\u0013\t12C\u0001\u0004E_V\u0014G.\u001a\u0005\t1\u0001\u0011\t\u0011)A\u0005#\u00051a/\u00197vK\u0002B\u0001B\u0007\u0001\u0003\u0006\u0004%\taG\u0001\u0005k:LG/F\u0001\u001d!\tiQ$\u0003\u0002\u001f\u0005\ty1)\u00199bG&$\u0018M\\2f+:LG\u000f\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\u0015)h.\u001b;!\u0011\u0015\u0011\u0003\u0001\"\u0003$\u0003\u0019a\u0014N\\5u}Q\u0019A\u0002J\u0013\t\u000b=\t\u0003\u0019A\t\t\u000bi\t\u0003\u0019\u0001\u000f\t\u000b\u001d\u0002A\u0011\u0001\u0015\u0002\u0013\u0011LW.\u001a8tS>tW#A\u0015\u000f\u00055Qs!B\u0016\u0003\u0011\u0003a\u0013aC\"ba\u0006\u001c\u0017\u000e^1oG\u0016\u0004\"!D\u0017\u0007\u000b\u0005\u0011\u0001\u0012\u0001\u0018\u0014\t5z#'\u000e\t\u0003%AJ!!M\n\u0003\r\u0005s\u0017PU3g!\rI1\u0007D\u0005\u0003i\u0011\u0011\u0011\u0002R5nK:\u001c\u0018n\u001c8\u0011\u0005I1\u0014BA\u001c\u0014\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015\u0011S\u0006\"\u0001:)\u0005a\u0003BB\u001e.\t\u0003\u0011A(A\u0003baBd\u00170\u0006\u0002>\u001fR\u0019a\b\u0017.\u0015\u00051y\u0004\"\u0002!;\u0001\b\t\u0015a\u00018v[B\u0019!IS'\u000f\u0005\rCeB\u0001#H\u001b\u0005)%B\u0001$\u0007\u0003\u0019a$o\\8u}%\tA#\u0003\u0002J'\u00059\u0001/Y2lC\u001e,\u0017BA&M\u0005\u001dqU/\\3sS\u000eT!!S\n\u0011\u00059{E\u0002\u0001\u0003\u0006!j\u0012\r!\u0015\u0002\u0002\u0003F\u0011!+\u0016\t\u0003%MK!\u0001V\n\u0003\u000f9{G\u000f[5oOB\u0011!CV\u0005\u0003/N\u00111!\u00118z\u0011\u0015I&\b1\u0001N\u0003\u0005q\u0007\"\u0002\u000e;\u0001\u0004a\u0002\"B\u001e.\t\u0003aFCA/d!\rq\u0016\rD\u0007\u0002?*\u0011\u0001mE\u0001\u0005kRLG.\u0003\u0002c?\n\u0019AK]=\t\u000b=Y\u0006\u0019A+\t\u000b\u0015lC\u0011\u00014\u0002\t9\fW.Z\u000b\u0002OB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\u0005Y\u0006twMC\u0001m\u0003\u0011Q\u0017M^1\n\u00059L'AB*ue&tw\rC\u0003q[\u0011\u0005\u0011/A\u0006qe&l\u0017M]=V]&$X#\u0001:\u000f\u00055\u0019\u0018B\u0001;\u0003\u0003\u00191\u0015M]1eg\")a/\fC\u0001c\u000611/[+oSRDQ\u0001_\u0017\u0005\u0002e\fQ!\u001e8jiN,\u0012A\u001f\t\u0006w\u0006\u0005\u0011QA\u0007\u0002y*\u0011QP`\u0001\nS6lW\u000f^1cY\u0016T!a`\n\u0002\u0015\r|G\u000e\\3di&|g.C\u0002\u0002\u0004q\u00141aU3u!\u0011I\u0011q\u0001\u0007\n\u0007\u0005%AAA\u0007V]&$xJZ'fCN,(/\u001a\u0005\n\u0003\u001bi\u0013\u0011!C\u0005\u0003\u001f\t1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0003\t\u0004Q\u0006M\u0011bAA\u000bS\n1qJ\u00196fGRDq!!\u0007\u0001\t\u0003\tY\"\u0001\u0004%i&lWm\u001d\u000b\u0005\u0003;\t\u0019\u0003E\u0002\u000e\u0003?I1!!\t\u0003\u00059)E.Z2ue&\u001c7\t[1sO\u0016D\u0001\"!\n\u0002\u0018\u0001\u0007\u0011qE\u0001\u0005i\"\fG\u000fE\u0002\u000e\u0003SI1!a\u000b\u0003\u0005E)E.Z2ue&\u001c\u0007k\u001c;f]RL\u0017\r\u001c\u0005\b\u0003_\u0001A\u0011AA\u0019\u0003\u0011!C-\u001b<\u0015\t\u0005M\u0012\u0011\b\t\u0004\u001b\u0005U\u0012bAA\u001c\u0005\ta\u0001+\u001a:nSR$\u0018N^5us\"A\u0011QEA\u0017\u0001\u0004\tY\u0004\u0005\u0003\u0002>\u0005\u0015c\u0002BA \u0003\u0007r1\u0001RA!\u0013\u0005)\u0011BA%\u0005\u0013\u0011\t9%!\u0013\u0003\r1+gn\u001a;i\u0015\tIE\u0001\u0003\u0004\u0002N\u0001!\t\u0001E\u0001\ti>4\u0015M]1eg\"1\u0011\u0011\u000b\u0001\u0005\u0002A\tA\u0002^8QS\u000e|g-\u0019:bINDa!!\u0016\u0001\t\u0003\u0001\u0012\u0001\u0004;p\u001d\u0006twNZ1sC\u0012\u001c\bBBA-\u0001\u0011\u0005\u0001#A\u0007u_6K7M]8gCJ\fGm\u001d\u0005\u0007\u0003;\u0002A\u0011\u0001\t\u0002\u001bQ|W*\u001b7mS\u001a\f'/\u00193t\u0011\u0019\t\t\u0007\u0001C\u0001!\u0005aAo\\&jY>4\u0017M]1eg\u0002")
public final class Capacitance
extends Quantity<Capacitance> {
    private final double value;
    private final CapacitanceUnit unit;

    public static <N> Try<Capacitance> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Capacitance$.MODULE$.parseTuple(tuple2, numeric);
    }

    public static Try<Capacitance> parseString(String string) {
        return Capacitance$.MODULE$.parseString(string);
    }

    public static Option<UnitOfMeasure<Capacitance>> symbolToUnit(String string) {
        return Capacitance$.MODULE$.symbolToUnit(string);
    }

    public static /* bridge */ UnitOfMeasure siUnit() {
        return Capacitance$.MODULE$.siUnit();
    }

    public static /* bridge */ UnitOfMeasure primaryUnit() {
        return Capacitance$.MODULE$.primaryUnit();
    }

    public static Set<UnitOfMeasure<Capacitance>> units() {
        return Capacitance$.MODULE$.units();
    }

    public static Farads$ siUnit() {
        return Capacitance$.MODULE$.siUnit();
    }

    public static Farads$ primaryUnit() {
        return Capacitance$.MODULE$.primaryUnit();
    }

    public static String name() {
        return Capacitance$.MODULE$.name();
    }

    public static Try<Capacitance> apply(Object object) {
        return Capacitance$.MODULE$.apply(object);
    }

    @Override
    public double value() {
        return this.value;
    }

    public CapacitanceUnit unit() {
        return this.unit;
    }

    public Capacitance$ dimension() {
        return Capacitance$.MODULE$;
    }

    public ElectricCharge $times(ElectricPotential that) {
        return Coulombs$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toFarads() * that.toVolts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Permittivity $div(Length that) {
        return FaradsPerMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toFarads() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toFarads() {
        return this.to(Farads$.MODULE$);
    }

    public double toPicofarads() {
        return this.to(Picofarads$.MODULE$);
    }

    public double toNanofarads() {
        return this.to(Nanofarads$.MODULE$);
    }

    public double toMicrofarads() {
        return this.to(Microfarads$.MODULE$);
    }

    public double toMillifarads() {
        return this.to(Millifarads$.MODULE$);
    }

    public double toKilofarads() {
        return this.to(Kilofarads$.MODULE$);
    }

    public Capacitance(double value, CapacitanceUnit unit) {
        this.value = value;
        this.unit = unit;
    }
}

