/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.SortedSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomains;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timeline.EntityIdentifier;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManagerMetrics;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimelineDataManager
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineDataManager.class);
    @VisibleForTesting
    public static final String DEFAULT_DOMAIN_ID = "DEFAULT";
    private TimelineDataManagerMetrics metrics;
    private TimelineStore store;
    private TimelineACLsManager timelineACLsManager;

    public TimelineDataManager(TimelineStore store, TimelineACLsManager timelineACLsManager) {
        super(TimelineDataManager.class.getName());
        this.store = store;
        this.timelineACLsManager = timelineACLsManager;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.metrics = TimelineDataManagerMetrics.create();
        TimelineDomain domain = this.store.getDomain(DEFAULT_DOMAIN_ID);
        if (domain == null) {
            domain = new TimelineDomain();
            domain.setId(DEFAULT_DOMAIN_ID);
            domain.setDescription("System Default Domain");
            domain.setOwner(UserGroupInformation.getCurrentUser().getShortUserName());
            domain.setReaders("*");
            domain.setWriters("*");
            this.store.put(domain);
        }
        super.serviceInit(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimelineEntities getEntities(String entityType, NameValuePair primaryFilter, Collection<NameValuePair> secondaryFilter, Long windowStart, Long windowEnd, String fromId, Long fromTs, Long limit, EnumSet<TimelineReader.Field> fields, UserGroupInformation callerUGI) throws YarnException, IOException {
        long startTime = Time.monotonicNow();
        this.metrics.incrGetEntitiesOps();
        try {
            TimelineEntities entities = this.doGetEntities(entityType, primaryFilter, secondaryFilter, windowStart, windowEnd, fromId, fromTs, limit, fields, callerUGI);
            this.metrics.incrGetEntitiesTotal(entities.getEntities().size());
            TimelineEntities timelineEntities = entities;
            return timelineEntities;
        }
        finally {
            this.metrics.addGetEntitiesTime(Time.monotonicNow() - startTime);
        }
    }

    private TimelineEntities doGetEntities(String entityType, NameValuePair primaryFilter, Collection<NameValuePair> secondaryFilter, Long windowStart, Long windowEnd, String fromId, Long fromTs, Long limit, EnumSet<TimelineReader.Field> fields, UserGroupInformation callerUGI) throws YarnException, IOException {
        TimelineEntities entities = null;
        entities = this.store.getEntities(entityType, limit, windowStart, windowEnd, fromId, fromTs, primaryFilter, secondaryFilter, fields, new CheckAclImpl(callerUGI));
        if (entities == null) {
            return new TimelineEntities();
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimelineEntity getEntity(String entityType, String entityId, EnumSet<TimelineReader.Field> fields, UserGroupInformation callerUGI) throws YarnException, IOException {
        long startTime = Time.monotonicNow();
        this.metrics.incrGetEntityOps();
        try {
            TimelineEntity timelineEntity = this.doGetEntity(entityType, entityId, fields, callerUGI);
            return timelineEntity;
        }
        finally {
            this.metrics.addGetEntityTime(Time.monotonicNow() - startTime);
        }
    }

    private TimelineEntity doGetEntity(String entityType, String entityId, EnumSet<TimelineReader.Field> fields, UserGroupInformation callerUGI) throws YarnException, IOException {
        TimelineEntity entity = null;
        entity = this.store.getEntity(entityId, entityType, fields);
        if (entity != null) {
            TimelineDataManager.addDefaultDomainIdIfAbsent(entity);
            if (!this.timelineACLsManager.checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, entity)) {
                String user = callerUGI != null ? callerUGI.getShortUserName() : null;
                throw new YarnException(user + " is not allowed to get the timeline entity { id: " + entity.getEntityId() + ", type: " + entity.getEntityType() + " }.");
            }
        }
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimelineEvents getEvents(String entityType, SortedSet<String> entityIds, SortedSet<String> eventTypes, Long windowStart, Long windowEnd, Long limit, UserGroupInformation callerUGI) throws YarnException, IOException {
        long startTime = Time.monotonicNow();
        this.metrics.incrGetEventsOps();
        try {
            TimelineEvents events = this.doGetEvents(entityType, entityIds, eventTypes, windowStart, windowEnd, limit, callerUGI);
            this.metrics.incrGetEventsTotal(events.getAllEvents().size());
            TimelineEvents timelineEvents = events;
            return timelineEvents;
        }
        finally {
            this.metrics.addGetEventsTime(Time.monotonicNow() - startTime);
        }
    }

    private TimelineEvents doGetEvents(String entityType, SortedSet<String> entityIds, SortedSet<String> eventTypes, Long windowStart, Long windowEnd, Long limit, UserGroupInformation callerUGI) throws YarnException, IOException {
        TimelineEvents events = null;
        events = this.store.getEntityTimelines(entityType, entityIds, limit, windowStart, windowEnd, eventTypes);
        if (events != null) {
            Iterator eventsItr = events.getAllEvents().iterator();
            while (eventsItr.hasNext()) {
                TimelineEvents.EventsOfOneEntity eventsOfOneEntity = (TimelineEvents.EventsOfOneEntity)eventsItr.next();
                try {
                    TimelineEntity entity = this.store.getEntity(eventsOfOneEntity.getEntityId(), eventsOfOneEntity.getEntityType(), EnumSet.of(TimelineReader.Field.PRIMARY_FILTERS));
                    TimelineDataManager.addDefaultDomainIdIfAbsent(entity);
                    if (this.timelineACLsManager.checkAccess(callerUGI, ApplicationAccessType.VIEW_APP, entity)) continue;
                    eventsItr.remove();
                }
                catch (Exception e) {
                    LOG.warn("Error when verifying access for user " + callerUGI + " on the events of the timeline entity " + new EntityIdentifier(eventsOfOneEntity.getEntityId(), eventsOfOneEntity.getEntityType()), (Throwable)e);
                    eventsItr.remove();
                }
            }
        }
        if (events == null) {
            return new TimelineEvents();
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimelinePutResponse postEntities(TimelineEntities entities, UserGroupInformation callerUGI) throws YarnException, IOException {
        long startTime = Time.monotonicNow();
        this.metrics.incrPostEntitiesOps();
        try {
            TimelinePutResponse timelinePutResponse = this.doPostEntities(entities, callerUGI);
            return timelinePutResponse;
        }
        finally {
            this.metrics.addPostEntitiesTime(Time.monotonicNow() - startTime);
        }
    }

    private TimelinePutResponse doPostEntities(TimelineEntities entities, UserGroupInformation callerUGI) throws YarnException, IOException {
        if (entities == null) {
            return new TimelinePutResponse();
        }
        this.metrics.incrPostEntitiesTotal(entities.getEntities().size());
        TimelineEntities entitiesToPut = new TimelineEntities();
        ArrayList<TimelinePutResponse.TimelinePutError> errors = new ArrayList<TimelinePutResponse.TimelinePutError>();
        for (TimelineEntity entity : entities.getEntities()) {
            if (entity.getDomainId() == null || entity.getDomainId().length() == 0) {
                entity.setDomainId(DEFAULT_DOMAIN_ID);
            }
            if (entity.getEntityId() == null || entity.getEntityType() == null) {
                throw new BadRequestException("Incomplete entity without entity id/type");
            }
            TimelineEntity existingEntity = null;
            try {
                existingEntity = this.store.getEntity(entity.getEntityId(), entity.getEntityType(), EnumSet.of(TimelineReader.Field.PRIMARY_FILTERS));
                if (existingEntity != null) {
                    TimelineDataManager.addDefaultDomainIdIfAbsent(existingEntity);
                    if (!existingEntity.getDomainId().equals(entity.getDomainId())) {
                        throw new YarnException("The domain of the timeline entity { id: " + entity.getEntityId() + ", type: " + entity.getEntityType() + " } is not allowed to be changed from " + existingEntity.getDomainId() + " to " + entity.getDomainId());
                    }
                }
                if (!this.timelineACLsManager.checkAccess(callerUGI, ApplicationAccessType.MODIFY_APP, entity)) {
                    throw new YarnException(callerUGI + " is not allowed to put the timeline entity { id: " + entity.getEntityId() + ", type: " + entity.getEntityType() + " } into the domain " + entity.getDomainId() + ".");
                }
            }
            catch (Exception e) {
                LOG.warn("Skip the timeline entity: { id: " + entity.getEntityId() + ", type: " + entity.getEntityType() + " }", (Throwable)e);
                TimelinePutResponse.TimelinePutError error = new TimelinePutResponse.TimelinePutError();
                error.setEntityId(entity.getEntityId());
                error.setEntityType(entity.getEntityType());
                error.setErrorCode(4);
                errors.add(error);
                continue;
            }
            entitiesToPut.addEntity(entity);
        }
        TimelinePutResponse response = this.store.put(entitiesToPut);
        response.addErrors(errors);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDomain(TimelineDomain domain, UserGroupInformation callerUGI) throws YarnException, IOException {
        long startTime = Time.monotonicNow();
        this.metrics.incrPutDomainOps();
        try {
            this.doPutDomain(domain, callerUGI);
        }
        finally {
            this.metrics.addPutDomainTime(Time.monotonicNow() - startTime);
        }
    }

    private void doPutDomain(TimelineDomain domain, UserGroupInformation callerUGI) throws YarnException, IOException {
        TimelineDomain existingDomain = this.store.getDomain(domain.getId());
        if (existingDomain != null) {
            if (!this.timelineACLsManager.checkAccess(callerUGI, existingDomain)) {
                throw new YarnException(callerUGI.getShortUserName() + " is not allowed to override an existing domain " + existingDomain.getId());
            }
            domain.setOwner(existingDomain.getOwner());
        }
        this.store.put(domain);
        if (existingDomain != null) {
            this.timelineACLsManager.replaceIfExist(domain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimelineDomain getDomain(String domainId, UserGroupInformation callerUGI) throws YarnException, IOException {
        long startTime = Time.monotonicNow();
        this.metrics.incrGetDomainOps();
        try {
            TimelineDomain timelineDomain = this.doGetDomain(domainId, callerUGI);
            return timelineDomain;
        }
        finally {
            this.metrics.addGetDomainTime(Time.monotonicNow() - startTime);
        }
    }

    private TimelineDomain doGetDomain(String domainId, UserGroupInformation callerUGI) throws YarnException, IOException {
        TimelineDomain domain = this.store.getDomain(domainId);
        if (domain != null && this.timelineACLsManager.checkAccess(callerUGI, domain)) {
            return domain;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimelineDomains getDomains(String owner, UserGroupInformation callerUGI) throws YarnException, IOException {
        long startTime = Time.monotonicNow();
        this.metrics.incrGetDomainsOps();
        try {
            TimelineDomains domains = this.doGetDomains(owner, callerUGI);
            this.metrics.incrGetDomainsTotal(domains.getDomains().size());
            TimelineDomains timelineDomains = domains;
            return timelineDomains;
        }
        finally {
            this.metrics.addGetDomainsTime(Time.monotonicNow() - startTime);
        }
    }

    private TimelineDomains doGetDomains(String owner, UserGroupInformation callerUGI) throws YarnException, IOException {
        TimelineDomains domains = this.store.getDomains(owner);
        boolean hasAccess = true;
        if (domains.getDomains().size() > 0) {
            hasAccess = this.timelineACLsManager.checkAccess(callerUGI, (TimelineDomain)domains.getDomains().get(0));
        }
        if (hasAccess) {
            return domains;
        }
        return new TimelineDomains();
    }

    private static void addDefaultDomainIdIfAbsent(TimelineEntity entity) {
        if (entity.getDomainId() == null) {
            entity.setDomainId(DEFAULT_DOMAIN_ID);
        }
    }

    class CheckAclImpl
    implements CheckAcl {
        final UserGroupInformation ugi;

        public CheckAclImpl(UserGroupInformation callerUGI) {
            this.ugi = callerUGI;
        }

        @Override
        public boolean check(TimelineEntity entity) throws IOException {
            try {
                return TimelineDataManager.this.timelineACLsManager.checkAccess(this.ugi, ApplicationAccessType.VIEW_APP, entity);
            }
            catch (YarnException e) {
                LOG.info("Error when verifying access for user " + this.ugi + " on the events of the timeline entity " + new EntityIdentifier(entity.getEntityId(), entity.getEntityType()), (Throwable)e);
                return false;
            }
        }
    }

    public static interface CheckAcl {
        public boolean check(TimelineEntity var1) throws IOException;
    }
}

