/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ConfigurationMutationACLPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ConfigurationMutationACLPolicyFactory;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.MutableConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.CSConfigurationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.InMemoryConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.LeveldbConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStore;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.YarnConfigurationStoreFactory;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.conf.ZKConfigurationStore;
import org.apache.hadoop.yarn.webapp.dao.QueueConfigInfo;
import org.apache.hadoop.yarn.webapp.dao.SchedConfUpdateInfo;

public class MutableCSConfigurationProvider
implements CSConfigurationProvider,
MutableConfigurationProvider {
    public static final Log LOG = LogFactory.getLog(MutableCSConfigurationProvider.class);
    private Configuration schedConf;
    private Configuration oldConf;
    private YarnConfigurationStore confStore;
    private ConfigurationMutationACLPolicy aclMutationPolicy;
    private RMContext rmContext;

    public MutableCSConfigurationProvider(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    @Override
    public void init(Configuration config) throws IOException {
        String store;
        switch (store = config.get("yarn.scheduler.configuration.store.class", "memory")) {
            case "memory": {
                this.confStore = new InMemoryConfigurationStore();
                break;
            }
            case "leveldb": {
                this.confStore = new LeveldbConfigurationStore();
                break;
            }
            case "zk": {
                this.confStore = new ZKConfigurationStore();
                break;
            }
            default: {
                this.confStore = YarnConfigurationStoreFactory.getStore(config);
            }
        }
        Configuration initialSchedConf = new Configuration(false);
        initialSchedConf.addResource("capacity-scheduler.xml");
        this.schedConf = new Configuration(false);
        for (Map.Entry kv : initialSchedConf) {
            this.schedConf.set((String)kv.getKey(), (String)kv.getValue());
        }
        try {
            this.confStore.initialize(config, this.schedConf, this.rmContext);
            this.confStore.checkVersion();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.schedConf = this.confStore.retrieve();
        this.aclMutationPolicy = ConfigurationMutationACLPolicyFactory.getPolicy(config);
        this.aclMutationPolicy.init(config, this.rmContext);
    }

    @Override
    public void close() throws IOException {
        this.confStore.close();
    }

    @VisibleForTesting
    public YarnConfigurationStore getConfStore() {
        return this.confStore;
    }

    @Override
    public CapacitySchedulerConfiguration loadConfiguration(Configuration configuration) throws IOException {
        Configuration loadedConf = new Configuration(this.schedConf);
        loadedConf.addResource(configuration);
        return new CapacitySchedulerConfiguration(loadedConf, false);
    }

    @Override
    public Configuration getConfiguration() {
        return new Configuration(this.schedConf);
    }

    @Override
    public ConfigurationMutationACLPolicy getAclMutationPolicy() {
        return this.aclMutationPolicy;
    }

    @Override
    public void logAndApplyMutation(UserGroupInformation user, SchedConfUpdateInfo confUpdate) throws Exception {
        this.oldConf = new Configuration(this.schedConf);
        Map<String, String> kvUpdate = this.constructKeyValueConfUpdate(confUpdate);
        YarnConfigurationStore.LogMutation log = new YarnConfigurationStore.LogMutation(kvUpdate, user.getShortUserName());
        this.confStore.logMutation(log);
        for (Map.Entry<String, String> kv : kvUpdate.entrySet()) {
            if (kv.getValue() == null) {
                this.schedConf.unset(kv.getKey());
                continue;
            }
            this.schedConf.set(kv.getKey(), kv.getValue());
        }
    }

    @Override
    public void confirmPendingMutation(boolean isValid) throws Exception {
        this.confStore.confirmMutation(isValid);
        if (!isValid) {
            this.schedConf = this.oldConf;
        }
    }

    @Override
    public void reloadConfigurationFromStore() throws Exception {
        this.schedConf = this.confStore.retrieve();
    }

    private List<String> getSiblingQueues(String queuePath, Configuration conf) {
        String parentQueue = queuePath.substring(0, queuePath.lastIndexOf(46));
        String childQueuesKey = "yarn.scheduler.capacity." + parentQueue + "." + "queues";
        return new ArrayList<String>(conf.getStringCollection(childQueuesKey));
    }

    private Map<String, String> constructKeyValueConfUpdate(SchedConfUpdateInfo mutationInfo) throws IOException {
        CapacitySchedulerConfiguration proposedConf = new CapacitySchedulerConfiguration(this.schedConf, false);
        HashMap<String, String> confUpdate = new HashMap<String, String>();
        for (String string : mutationInfo.getRemoveQueueInfo()) {
            this.removeQueue(string, proposedConf, confUpdate);
        }
        for (QueueConfigInfo queueConfigInfo : mutationInfo.getAddQueueInfo()) {
            this.addQueue(queueConfigInfo, proposedConf, confUpdate);
        }
        for (QueueConfigInfo queueConfigInfo : mutationInfo.getUpdateQueueInfo()) {
            this.updateQueue(queueConfigInfo, proposedConf, confUpdate);
        }
        for (Map.Entry entry : mutationInfo.getGlobalParams().entrySet()) {
            confUpdate.put((String)entry.getKey(), (String)entry.getValue());
        }
        return confUpdate;
    }

    private void removeQueue(String queueToRemove, CapacitySchedulerConfiguration proposedConf, Map<String, String> confUpdate) throws IOException {
        if (queueToRemove == null) {
            return;
        }
        String queueName = queueToRemove.substring(queueToRemove.lastIndexOf(46) + 1);
        if (queueToRemove.lastIndexOf(46) == -1) {
            throw new IOException("Can't remove queue " + queueToRemove);
        }
        List<String> siblingQueues = this.getSiblingQueues(queueToRemove, proposedConf);
        if (!siblingQueues.contains(queueName)) {
            throw new IOException("Queue " + queueToRemove + " not found");
        }
        siblingQueues.remove(queueName);
        String parentQueuePath = queueToRemove.substring(0, queueToRemove.lastIndexOf(46));
        proposedConf.setQueues(parentQueuePath, siblingQueues.toArray(new String[0]));
        String queuesConfig = "yarn.scheduler.capacity." + parentQueuePath + "." + "queues";
        if (siblingQueues.size() == 0) {
            confUpdate.put(queuesConfig, null);
        } else {
            confUpdate.put(queuesConfig, Joiner.on((char)',').join(siblingQueues));
        }
        for (Map.Entry confRemove : proposedConf.getValByRegex(".*" + queueToRemove.replaceAll("\\.", "\\.") + "\\..*").entrySet()) {
            proposedConf.unset((String)confRemove.getKey());
            confUpdate.put((String)confRemove.getKey(), (String)null);
        }
    }

    private void addQueue(QueueConfigInfo addInfo, CapacitySchedulerConfiguration proposedConf, Map<String, String> confUpdate) throws IOException {
        if (addInfo == null) {
            return;
        }
        String queuePath = addInfo.getQueue();
        String queueName = queuePath.substring(queuePath.lastIndexOf(46) + 1);
        if (queuePath.lastIndexOf(46) == -1) {
            throw new IOException("Can't add invalid queue " + queuePath);
        }
        if (this.getSiblingQueues(queuePath, proposedConf).contains(queueName)) {
            throw new IOException("Can't add existing queue " + queuePath);
        }
        String parentQueue = queuePath.substring(0, queuePath.lastIndexOf(46));
        String[] siblings = proposedConf.getQueues(parentQueue);
        ArrayList<String> siblingQueues = siblings == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(siblings));
        siblingQueues.add(queuePath.substring(queuePath.lastIndexOf(46) + 1));
        proposedConf.setQueues(parentQueue, siblingQueues.toArray(new String[0]));
        confUpdate.put("yarn.scheduler.capacity." + parentQueue + "." + "queues", Joiner.on((char)',').join(siblingQueues));
        String keyPrefix = "yarn.scheduler.capacity." + queuePath + ".";
        for (Map.Entry kv : addInfo.getParams().entrySet()) {
            if (kv.getValue() == null) {
                proposedConf.unset(keyPrefix + (String)kv.getKey());
            } else {
                proposedConf.set(keyPrefix + (String)kv.getKey(), (String)kv.getValue());
            }
            confUpdate.put(keyPrefix + (String)kv.getKey(), (String)kv.getValue());
        }
    }

    private void updateQueue(QueueConfigInfo updateInfo, CapacitySchedulerConfiguration proposedConf, Map<String, String> confUpdate) {
        if (updateInfo == null) {
            return;
        }
        String queuePath = updateInfo.getQueue();
        String keyPrefix = "yarn.scheduler.capacity." + queuePath + ".";
        for (Map.Entry kv : updateInfo.getParams().entrySet()) {
            if (kv.getValue() == null) {
                proposedConf.unset(keyPrefix + (String)kv.getKey());
            } else {
                proposedConf.set(keyPrefix + (String)kv.getKey(), (String)kv.getValue());
            }
            confUpdate.put(keyPrefix + (String)kv.getKey(), (String)kv.getValue());
        }
    }
}

