/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga;

import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.fpga.FpgaResourceAllocator;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.fpga.AbstractFpgaVendorPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FpgaDiscoverer {
    public static final Logger LOG = LoggerFactory.getLogger(FpgaDiscoverer.class);
    private static FpgaDiscoverer instance = new FpgaDiscoverer();
    private Configuration conf = null;
    private AbstractFpgaVendorPlugin plugin = null;
    private List<FpgaResourceAllocator.FpgaDevice> currentFpgaInfo = null;
    private static final int MAX_EXEC_TIMEOUT_MS = 10000;

    public static FpgaDiscoverer getInstance() {
        return instance;
    }

    @VisibleForTesting
    public static synchronized FpgaDiscoverer setInstance(FpgaDiscoverer newInstance) {
        instance = newInstance;
        return instance;
    }

    @VisibleForTesting
    public synchronized void setConf(Configuration conf) {
        this.conf = conf;
    }

    public List<FpgaResourceAllocator.FpgaDevice> getCurrentFpgaInfo() {
        return this.currentFpgaInfo;
    }

    public synchronized void setResourceHanderPlugin(AbstractFpgaVendorPlugin plugin) {
        this.plugin = plugin;
    }

    public synchronized boolean diagnose() {
        return this.plugin.diagnose(10000);
    }

    public synchronized void initialize(Configuration conf) throws YarnException {
        this.conf = conf;
        this.plugin.initPlugin(conf);
        LOG.info("Trying to diagnose FPGA information ...");
        if (!this.diagnose()) {
            LOG.warn("Failed to pass FPGA devices diagnose");
        }
    }

    public synchronized List<FpgaResourceAllocator.FpgaDevice> discover() throws ResourceHandlerException {
        String allowed = this.conf.get("yarn.nodemanager.resource-plugins.fpga.allowed-fpga-devices");
        List<FpgaResourceAllocator.FpgaDevice> list = this.plugin.discover(10000);
        if (0 == list.size()) {
            throw new ResourceHandlerException("No FPGA devices detected!");
        }
        this.currentFpgaInfo = list;
        if (allowed.equalsIgnoreCase("auto")) {
            return list;
        }
        if (allowed.matches("(\\d,)*\\d")) {
            String[] minors = allowed.split(",");
            Iterator<FpgaResourceAllocator.FpgaDevice> iterator = list.iterator();
            while (iterator.hasNext()) {
                boolean valid = false;
                FpgaResourceAllocator.FpgaDevice t = iterator.next();
                for (String minorNumber : minors) {
                    if (!t.getMinor().toString().equals(minorNumber)) continue;
                    valid = true;
                    break;
                }
                if (valid) continue;
                iterator.remove();
            }
            if (list.size() != minors.length) {
                LOG.warn("We continue although there're mistakes in user's configuration yarn.nodemanager.resource-plugins.fpga.allowed-fpga-devicesuser configured:" + allowed + ", while the real:" + list.toString());
            }
        } else {
            throw new ResourceHandlerException("Invalid value configured for yarn.nodemanager.resource-plugins.fpga.allowed-fpga-devices:\"" + allowed + "\"");
        }
        return list;
    }
}

