/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.yarn.api.ApplicationHistoryProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.timeline.security.authorize.TimelinePolicyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationHistoryClientService
extends AbstractService
implements ApplicationHistoryProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationHistoryClientService.class);
    private ApplicationHistoryManager history;
    private Server server;
    private InetSocketAddress bindAddress;

    public ApplicationHistoryClientService(ApplicationHistoryManager history) {
        super("ApplicationHistoryClientService");
        this.history = history;
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress address = conf.getSocketAddr("yarn.timeline-service.bind-host", "yarn.timeline-service.address", "0.0.0.0:10200", 10200);
        Preconditions.checkArgument((conf.getInt("yarn.timeline-service.handler-thread-count", 10) > 0 ? 1 : 0) != 0, (String)"%s property value should be greater than zero", (Object)"yarn.timeline-service.handler-thread-count");
        this.server = rpc.getServer(ApplicationHistoryProtocol.class, (Object)this, address, conf, null, conf.getInt("yarn.timeline-service.handler-thread-count", 10));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(conf, new TimelinePolicyProvider());
        }
        this.server.start();
        this.bindAddress = conf.updateConnectAddr("yarn.timeline-service.bind-host", "yarn.timeline-service.address", "0.0.0.0:10200", this.server.getListenerAddress());
        LOG.info("Instantiated ApplicationHistoryClientService at " + this.bindAddress);
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    @InterfaceAudience.Private
    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    private void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws YarnException, IOException {
        return null;
    }

    public GetApplicationAttemptReportResponse getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
        ApplicationAttemptId appAttemptId = request.getApplicationAttemptId();
        try {
            GetApplicationAttemptReportResponse response = GetApplicationAttemptReportResponse.newInstance((ApplicationAttemptReport)this.history.getApplicationAttempt(appAttemptId));
            return response;
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public GetApplicationAttemptsResponse getApplicationAttempts(GetApplicationAttemptsRequest request) throws YarnException, IOException {
        GetApplicationAttemptsResponse response = GetApplicationAttemptsResponse.newInstance(new ArrayList<ApplicationAttemptReport>(this.history.getApplicationAttempts(request.getApplicationId()).values()));
        return response;
    }

    public GetApplicationReportResponse getApplicationReport(GetApplicationReportRequest request) throws YarnException, IOException {
        ApplicationId applicationId = request.getApplicationId();
        try {
            GetApplicationReportResponse response = GetApplicationReportResponse.newInstance((ApplicationReport)this.history.getApplication(applicationId));
            return response;
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public GetApplicationsResponse getApplications(GetApplicationsRequest request) throws YarnException, IOException {
        long startedBegin = request.getStartRange() == null ? 0L : request.getStartRange().getMinimumLong();
        long startedEnd = request.getStartRange() == null ? Long.MAX_VALUE : request.getStartRange().getMaximumLong();
        GetApplicationsResponse response = GetApplicationsResponse.newInstance(new ArrayList<ApplicationReport>(this.history.getApplications(request.getLimit(), startedBegin, startedEnd).values()));
        return response;
    }

    public GetContainerReportResponse getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
        ContainerId containerId = request.getContainerId();
        try {
            GetContainerReportResponse response = GetContainerReportResponse.newInstance((ContainerReport)this.history.getContainer(containerId));
            return response;
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public GetContainersResponse getContainers(GetContainersRequest request) throws YarnException, IOException {
        GetContainersResponse response = GetContainersResponse.newInstance(new ArrayList<ContainerReport>(this.history.getContainers(request.getApplicationAttemptId()).values()));
        return response;
    }

    public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws YarnException, IOException {
        return null;
    }

    public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws YarnException, IOException {
        return null;
    }
}

