/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.com.google.protobuf.MessageOrBuilder;
import org.apache.hadoop.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.TokenPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonServiceProtos;
import org.apache.hadoop.yarn.server.api.records.AppCollectorData;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AppCollectorDataPBImpl
extends AppCollectorData {
    private YarnServerCommonServiceProtos.AppCollectorDataProto proto = YarnServerCommonServiceProtos.AppCollectorDataProto.getDefaultInstance();
    private YarnServerCommonServiceProtos.AppCollectorDataProto.Builder builder = null;
    private boolean viaProto = false;
    private ApplicationId appId = null;
    private String collectorAddr = null;
    private Long rmIdentifier = null;
    private Long version = null;
    private Token collectorToken = null;

    public AppCollectorDataPBImpl() {
        this.builder = YarnServerCommonServiceProtos.AppCollectorDataProto.newBuilder();
    }

    public AppCollectorDataPBImpl(YarnServerCommonServiceProtos.AppCollectorDataProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServerCommonServiceProtos.AppCollectorDataProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((AppCollectorDataPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    @Override
    public ApplicationId getApplicationId() {
        YarnServerCommonServiceProtos.AppCollectorDataProtoOrBuilder p;
        YarnServerCommonServiceProtos.AppCollectorDataProtoOrBuilder appCollectorDataProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.appId == null && p.hasAppId()) {
            this.appId = this.convertFromProtoFormat(p.getAppId());
        }
        return this.appId;
    }

    @Override
    public String getCollectorAddr() {
        YarnServerCommonServiceProtos.AppCollectorDataProtoOrBuilder p;
        YarnServerCommonServiceProtos.AppCollectorDataProtoOrBuilder appCollectorDataProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.collectorAddr == null && p.hasAppCollectorAddr()) {
            this.collectorAddr = p.getAppCollectorAddr();
        }
        return this.collectorAddr;
    }

    @Override
    public void setApplicationId(ApplicationId id) {
        this.maybeInitBuilder();
        if (id == null) {
            this.builder.clearAppId();
        }
        this.appId = id;
    }

    @Override
    public void setCollectorAddr(String collectorAddr) {
        this.maybeInitBuilder();
        if (collectorAddr == null) {
            this.builder.clearAppCollectorAddr();
        }
        this.collectorAddr = collectorAddr;
    }

    @Override
    public long getRMIdentifier() {
        YarnServerCommonServiceProtos.AppCollectorDataProtoOrBuilder p;
        YarnServerCommonServiceProtos.AppCollectorDataProtoOrBuilder appCollectorDataProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.rmIdentifier == null && p.hasRmIdentifier()) {
            this.rmIdentifier = p.getRmIdentifier();
        }
        if (this.rmIdentifier != null) {
            return this.rmIdentifier;
        }
        return -1L;
    }

    @Override
    public void setRMIdentifier(long rmId) {
        this.maybeInitBuilder();
        this.rmIdentifier = rmId;
        this.builder.setRmIdentifier(rmId);
    }

    @Override
    public long getVersion() {
        YarnServerCommonServiceProtos.AppCollectorDataProtoOrBuilder p;
        YarnServerCommonServiceProtos.AppCollectorDataProtoOrBuilder appCollectorDataProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.version == null && p.hasRmIdentifier()) {
            this.version = p.getRmIdentifier();
        }
        if (this.version != null) {
            return this.version;
        }
        return -1L;
    }

    @Override
    public void setVersion(long version) {
        this.maybeInitBuilder();
        this.version = version;
        this.builder.setVersion(version);
    }

    @Override
    public Token getCollectorToken() {
        YarnServerCommonServiceProtos.AppCollectorDataProtoOrBuilder p;
        YarnServerCommonServiceProtos.AppCollectorDataProtoOrBuilder appCollectorDataProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.collectorToken != null) {
            return this.collectorToken;
        }
        if (!p.hasAppCollectorToken()) {
            return null;
        }
        this.collectorToken = new TokenPBImpl(p.getAppCollectorToken());
        return this.collectorToken;
    }

    @Override
    public void setCollectorToken(Token token) {
        this.maybeInitBuilder();
        if (token == null) {
            this.builder.clearAppCollectorToken();
        }
        this.collectorToken = token;
    }

    private ApplicationIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationIdProto p) {
        return new ApplicationIdPBImpl(p);
    }

    private YarnProtos.ApplicationIdProto convertToProtoFormat(ApplicationId t) {
        return ((ApplicationIdPBImpl)t).getProto();
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerCommonServiceProtos.AppCollectorDataProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void mergeLocalToBuilder() {
        if (this.appId != null) {
            this.builder.setAppId(this.convertToProtoFormat(this.appId));
        }
        if (this.collectorAddr != null) {
            this.builder.setAppCollectorAddr(this.collectorAddr);
        }
        if (this.rmIdentifier != null) {
            this.builder.setRmIdentifier(this.rmIdentifier);
        }
        if (this.version != null) {
            this.builder.setVersion(this.version);
        }
        if (this.collectorToken != null) {
            this.builder.setAppCollectorToken(((TokenPBImpl)this.collectorToken).getProto());
        }
    }
}

