/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.verification.checkers;

import java.util.List;
import org.apache.hadoop.shaded.org.mockito.exceptions.Reporter;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.Invocation;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.InvocationMatcher;
import org.apache.hadoop.shaded.org.mockito.internal.invocation.InvocationsFinder;
import org.apache.hadoop.shaded.org.mockito.internal.reporting.SmartPrinter;
import org.apache.hadoop.shaded.org.mockito.internal.verification.api.InOrderContext;
import org.apache.hadoop.shaded.org.mockito.internal.verification.argumentmatching.ArgumentMatchingTool;
import org.apache.hadoop.shaded.org.mockito.verification.VerificationMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingInvocationInOrderChecker {
    private final Reporter reporter;
    private final InvocationsFinder finder;

    public MissingInvocationInOrderChecker() {
        this(new InvocationsFinder(), new Reporter());
    }

    MissingInvocationInOrderChecker(InvocationsFinder finder, Reporter reporter) {
        this.finder = finder;
        this.reporter = reporter;
    }

    public void check(List<Invocation> invocations, InvocationMatcher wanted, VerificationMode mode, InOrderContext context) {
        List<Invocation> chunk = this.finder.findAllMatchingUnverifiedChunks(invocations, wanted, context);
        if (!chunk.isEmpty()) {
            return;
        }
        Invocation previousInOrder = this.finder.findPreviousVerifiedInOrder(invocations, context);
        if (previousInOrder == null) {
            List<Invocation> actualInvocations = this.finder.findInvocations(invocations, wanted);
            if (actualInvocations == null || actualInvocations.isEmpty()) {
                Invocation similar = this.finder.findSimilarInvocation(invocations, wanted);
                if (similar != null) {
                    Integer[] indicesOfSimilarMatchingArguments = new ArgumentMatchingTool().getSuspiciouslyNotMatchingArgsIndexes(wanted.getMatchers(), similar.getArguments());
                    SmartPrinter smartPrinter = new SmartPrinter(wanted, similar, indicesOfSimilarMatchingArguments);
                    this.reporter.argumentsAreDifferent(smartPrinter.getWanted(), smartPrinter.getActual(), similar.getLocation());
                } else {
                    this.reporter.wantedButNotInvoked(wanted);
                }
            }
        } else {
            this.reporter.wantedButNotInvokedInOrder(wanted, previousInOrder);
        }
    }
}

