/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.flexible;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.hadoop.shaded.org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumHierarchical
implements QuorumVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumHierarchical.class);
    HashMap<Long, Long> serverWeight;
    HashMap<Long, Long> serverGroup;
    HashMap<Long, Long> groupWeight;
    int numGroups;

    public QuorumHierarchical(String filename) throws QuorumPeerConfig.ConfigException {
        this.serverWeight = new HashMap();
        this.serverGroup = new HashMap();
        this.groupWeight = new HashMap();
        this.numGroups = 0;
        this.readConfigFile(filename);
    }

    public QuorumHierarchical(Properties qp) throws QuorumPeerConfig.ConfigException {
        this.serverWeight = new HashMap();
        this.serverGroup = new HashMap();
        this.groupWeight = new HashMap();
        this.numGroups = 0;
        this.parse(qp);
        LOG.info(this.serverWeight.size() + ", " + this.serverGroup.size() + ", " + this.groupWeight.size());
    }

    public QuorumHierarchical(int numGroups, HashMap<Long, Long> serverWeight, HashMap<Long, Long> serverGroup) {
        this.serverWeight = serverWeight;
        this.serverGroup = serverGroup;
        this.groupWeight = new HashMap();
        this.numGroups = numGroups;
        this.computeGroupWeight();
    }

    @Override
    public long getWeight(long id) {
        return this.serverWeight.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConfigFile(String filename) throws QuorumPeerConfig.ConfigException {
        File configFile = new File(filename);
        LOG.info("Reading configuration from: " + configFile);
        try {
            if (!configFile.exists()) {
                throw new IllegalArgumentException(configFile.toString() + " file is missing");
            }
            Properties cfg = new Properties();
            FileInputStream in = new FileInputStream(configFile);
            try {
                cfg.load(in);
            }
            finally {
                in.close();
            }
            this.parse(cfg);
        }
        catch (IOException e) {
            throw new QuorumPeerConfig.ConfigException("Error processing " + filename, e);
        }
        catch (IllegalArgumentException e) {
            throw new QuorumPeerConfig.ConfigException("Error processing " + filename, e);
        }
    }

    private void parse(Properties quorumProp) {
        for (Map.Entry<Object, Object> entry : quorumProp.entrySet()) {
            int dot;
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (key.startsWith("group")) {
                String[] parts;
                dot = key.indexOf(46);
                long gid = Long.parseLong(key.substring(dot + 1));
                ++this.numGroups;
                for (String s : parts = value.split(":")) {
                    long sid = Long.parseLong(s);
                    this.serverGroup.put(sid, gid);
                }
                continue;
            }
            if (!key.startsWith("weight")) continue;
            dot = key.indexOf(46);
            long sid = Long.parseLong(key.substring(dot + 1));
            this.serverWeight.put(sid, Long.parseLong(value));
        }
        this.computeGroupWeight();
    }

    private void computeGroupWeight() {
        for (Map.Entry<Long, Long> entry : this.serverGroup.entrySet()) {
            Long sid = entry.getKey();
            Long gid = entry.getValue();
            if (!this.groupWeight.containsKey(gid)) {
                this.groupWeight.put(gid, this.serverWeight.get(sid));
                continue;
            }
            long totalWeight = this.serverWeight.get(sid) + this.groupWeight.get(gid);
            this.groupWeight.put(gid, totalWeight);
        }
        Iterator<Object> iterator = this.groupWeight.values().iterator();
        while (iterator.hasNext()) {
            long weight = (Long)iterator.next();
            LOG.debug("Group weight: " + weight);
            if (weight != 0L) continue;
            --this.numGroups;
            LOG.debug("One zero-weight group: 1, " + this.numGroups);
        }
    }

    @Override
    public boolean containsQuorum(Set<Long> set) {
        Long gid;
        HashMap<Long, Long> expansion = new HashMap<Long, Long>();
        if (set.size() == 0) {
            return false;
        }
        LOG.debug("Set size: " + set.size());
        for (long sid : set) {
            gid = this.serverGroup.get(sid);
            if (!expansion.containsKey(gid)) {
                expansion.put(gid, this.serverWeight.get(sid));
                continue;
            }
            long totalWeight = this.serverWeight.get(sid) + (Long)expansion.get(gid);
            expansion.put(gid, totalWeight);
        }
        int majGroupCounter = 0;
        for (Map.Entry entry : expansion.entrySet()) {
            gid = (Long)entry.getKey();
            LOG.debug("Group info: " + entry.getValue() + ", " + gid + ", " + this.groupWeight.get(gid));
            if ((Long)entry.getValue() <= this.groupWeight.get(gid) / 2L) continue;
            ++majGroupCounter;
        }
        LOG.debug("Majority group counter: " + majGroupCounter + ", " + this.numGroups);
        if (majGroupCounter > this.numGroups / 2) {
            LOG.debug("Positive set size: " + set.size());
            return true;
        }
        LOG.debug("Negative set size: " + set.size());
        return false;
    }
}

