/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.io.netty.handler.codec.http;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import org.apache.hadoop.shaded.io.netty.buffer.ByteBuf;
import org.apache.hadoop.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.hadoop.shaded.io.netty.channel.CombinedChannelDuplexHandler;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpMethod;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpRequest;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpRequestDecoder;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpResponse;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpResponseEncoder;

public final class HttpServerCodec
extends CombinedChannelDuplexHandler<HttpRequestDecoder, HttpResponseEncoder> {
    private final Queue<HttpMethod> queue = new ArrayDeque<HttpMethod>();

    public HttpServerCodec() {
        this(4096, 8192, 8192);
    }

    public HttpServerCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
        this.init(new HttpServerRequestDecoder(maxInitialLineLength, maxHeaderSize, maxChunkSize), new HttpServerResponseEncoder());
    }

    public HttpServerCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean validateHeaders) {
        this.init(new HttpServerRequestDecoder(maxInitialLineLength, maxHeaderSize, maxChunkSize, validateHeaders), new HttpServerResponseEncoder());
    }

    public HttpServerCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean validateHeaders, int initialBufferSize) {
        this.init(new HttpServerRequestDecoder(maxInitialLineLength, maxHeaderSize, maxChunkSize, validateHeaders, initialBufferSize), new HttpServerResponseEncoder());
    }

    private final class HttpServerResponseEncoder
    extends HttpResponseEncoder {
        private HttpMethod method;

        private HttpServerResponseEncoder() {
        }

        @Override
        protected void sanitizeHeadersBeforeEncode(HttpResponse msg, boolean isAlwaysEmpty) {
            int code = msg.getStatus().code();
            if (!isAlwaysEmpty && this.method == HttpMethod.CONNECT && code >= 200 && code <= 299) {
                msg.headers().remove("Transfer-Encoding");
                return;
            }
            super.sanitizeHeadersBeforeEncode(msg, isAlwaysEmpty);
        }

        @Override
        protected boolean isContentAlwaysEmpty(HttpResponse msg) {
            this.method = (HttpMethod)HttpServerCodec.this.queue.poll();
            return HttpMethod.HEAD.equals(this.method) || super.isContentAlwaysEmpty(msg);
        }
    }

    private final class HttpServerRequestDecoder
    extends HttpRequestDecoder {
        HttpServerRequestDecoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
            super(maxInitialLineLength, maxHeaderSize, maxChunkSize);
        }

        HttpServerRequestDecoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean validateHeaders) {
            super(maxInitialLineLength, maxHeaderSize, maxChunkSize, validateHeaders);
        }

        HttpServerRequestDecoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean validateHeaders, int initialBufferSize) {
            super(maxInitialLineLength, maxHeaderSize, maxChunkSize, validateHeaders, initialBufferSize);
        }

        @Override
        protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
            int oldSize = out.size();
            super.decode(ctx, buffer, out);
            int size = out.size();
            for (int i = oldSize; i < size; ++i) {
                Object obj = out.get(i);
                if (!(obj instanceof HttpRequest)) continue;
                HttpServerCodec.this.queue.add(((HttpRequest)obj).getMethod());
            }
        }
    }
}

