/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.io.netty.channel.oio;

import java.net.SocketAddress;
import org.apache.hadoop.shaded.io.netty.channel.AbstractChannel;
import org.apache.hadoop.shaded.io.netty.channel.Channel;
import org.apache.hadoop.shaded.io.netty.channel.ChannelPromise;
import org.apache.hadoop.shaded.io.netty.channel.EventLoop;
import org.apache.hadoop.shaded.io.netty.channel.ThreadPerChannelEventLoop;

public abstract class AbstractOioChannel
extends AbstractChannel {
    protected static final int SO_TIMEOUT = 1000;
    private volatile boolean readPending;
    private final Runnable readTask = new Runnable(){

        @Override
        public void run() {
            if (!AbstractOioChannel.this.isReadPending() && !AbstractOioChannel.this.config().isAutoRead()) {
                return;
            }
            AbstractOioChannel.this.setReadPending(false);
            AbstractOioChannel.this.doRead();
        }
    };

    protected AbstractOioChannel(Channel parent) {
        super(parent);
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new DefaultOioUnsafe();
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof ThreadPerChannelEventLoop;
    }

    protected abstract void doConnect(SocketAddress var1, SocketAddress var2) throws Exception;

    @Override
    protected void doBeginRead() throws Exception {
        if (this.isReadPending()) {
            return;
        }
        this.setReadPending(true);
        this.eventLoop().execute(this.readTask);
    }

    protected abstract void doRead();

    protected boolean isReadPending() {
        return this.readPending;
    }

    protected void setReadPending(boolean readPending) {
        this.readPending = readPending;
    }

    private final class DefaultOioUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private DefaultOioUnsafe() {
            super(AbstractOioChannel.this);
        }

        @Override
        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            if (!promise.setUncancellable() || !this.ensureOpen(promise)) {
                return;
            }
            try {
                boolean wasActive = AbstractOioChannel.this.isActive();
                AbstractOioChannel.this.doConnect(remoteAddress, localAddress);
                boolean active = AbstractOioChannel.this.isActive();
                this.safeSetSuccess(promise);
                if (!wasActive && active) {
                    AbstractOioChannel.this.pipeline().fireChannelActive();
                }
            }
            catch (Throwable t) {
                this.safeSetFailure(promise, this.annotateConnectException(t, remoteAddress));
                this.closeIfClosed();
            }
        }
    }
}

