/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.App;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.ReduceTaskAttemptInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskAttemptInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.hamlet2.HamletSpec;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class HsTasksBlock
extends HtmlBlock {
    final App app;

    @Inject
    HsTasksBlock(App app) {
        this.app = app;
    }

    protected void render(HtmlBlock.Block html) {
        if (this.app.getJob() == null) {
            html.h2(this.$("title"));
            return;
        }
        TaskType type = null;
        String symbol = this.$("task.type");
        if (!symbol.isEmpty()) {
            type = MRApps.taskType((String)symbol);
        }
        Hamlet.THEAD thead = type != null ? html.table("#" + this.app.getJob().getID() + type).$class("dt-tasks").thead() : html.table("#tasks").thead();
        int attemptColSpan = type == TaskType.REDUCE ? 8 : 3;
        ((Hamlet.TR)((Hamlet.TR)thead.tr().th().$colspan(5).$class("ui-state-default").__(new Object[]{"Task"}).__()).th().$colspan(attemptColSpan).$class("ui-state-default").__(new Object[]{"Successful Attempt"}).__()).__();
        Hamlet.TR theadRow = thead.tr().th("Name").th("State").th("Start Time").th("Finish Time").th("Elapsed Time").th("Start Time");
        if (type == TaskType.REDUCE) {
            theadRow.th("Shuffle Finish Time");
            theadRow.th("Merge Finish Time");
        }
        theadRow.th("Finish Time");
        if (type == TaskType.REDUCE) {
            theadRow.th("Elapsed Time Shuffle");
            theadRow.th("Elapsed Time Merge");
            theadRow.th("Elapsed Time Reduce");
        }
        theadRow.th("Elapsed Time");
        Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)theadRow.__()).__()).tbody();
        StringBuilder tasksTableData = new StringBuilder("[\n");
        for (Task task : this.app.getJob().getTasks().values()) {
            if (type != null && task.getType() != type) continue;
            TaskInfo info = new TaskInfo(task);
            String tid = info.getId();
            long startTime = info.getStartTime();
            long finishTime = info.getFinishTime();
            long elapsed = info.getElapsedTime();
            long attemptStartTime = -1L;
            long shuffleFinishTime = -1L;
            long sortFinishTime = -1L;
            long attemptFinishTime = -1L;
            long elapsedShuffleTime = -1L;
            long elapsedSortTime = -1L;
            long elapsedReduceTime = -1L;
            long attemptElapsed = -1L;
            TaskAttempt successful = info.getSuccessful();
            if (successful != null) {
                TaskAttemptInfo ta;
                if (type == TaskType.REDUCE) {
                    ReduceTaskAttemptInfo rta = new ReduceTaskAttemptInfo(successful, type);
                    shuffleFinishTime = rta.getShuffleFinishTime();
                    sortFinishTime = rta.getMergeFinishTime();
                    elapsedShuffleTime = rta.getElapsedShuffleTime();
                    elapsedSortTime = rta.getElapsedMergeTime();
                    elapsedReduceTime = rta.getElapsedReduceTime();
                    ta = rta;
                } else {
                    ta = new TaskAttemptInfo(successful, type, Boolean.valueOf(false));
                }
                attemptStartTime = ta.getStartTime();
                attemptFinishTime = ta.getFinishTime();
                attemptElapsed = ta.getElapsedTime();
            }
            tasksTableData.append("[\"").append("<a href='" + this.url(new String[]{"task", tid})).append("'>").append(tid).append("</a>\",\"").append(info.getState()).append("\",\"").append(startTime).append("\",\"").append(finishTime).append("\",\"").append(elapsed).append("\",\"").append(attemptStartTime).append("\",\"");
            if (type == TaskType.REDUCE) {
                tasksTableData.append(shuffleFinishTime).append("\",\"").append(sortFinishTime).append("\",\"");
            }
            tasksTableData.append(attemptFinishTime).append("\",\"");
            if (type == TaskType.REDUCE) {
                tasksTableData.append(elapsedShuffleTime).append("\",\"").append(elapsedSortTime).append("\",\"").append(elapsedReduceTime).append("\",\"");
            }
            tasksTableData.append(attemptElapsed).append("\"],\n");
        }
        if (tasksTableData.charAt(tasksTableData.length() - 2) == ',') {
            tasksTableData.delete(tasksTableData.length() - 2, tasksTableData.length() - 1);
        }
        tasksTableData.append("]");
        html.script().$type("text/javascript").__(new Object[]{"var tasksTableData=" + tasksTableData}).__();
        Hamlet.TR footRow = ((Hamlet.TABLE)tbody.__()).tfoot().tr();
        ((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("task").$value("ID").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("state").$value("State").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("start_time").$value("Start Time").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("finish_time").$value("Finish Time").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("elapsed_time").$value("Elapsed Time").__()).__()).th().input("search_init").$type(HamletSpec.InputType.text).$name("attempt_start_time").$value("Start Time").__()).__();
        if (type == TaskType.REDUCE) {
            ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("shuffle_time").$value("Shuffle Time").__()).__();
            ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("merge_time").$value("Merge Time").__()).__();
        }
        ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("attempt_finish").$value("Finish Time").__()).__();
        if (type == TaskType.REDUCE) {
            ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("elapsed_shuffle_time").$value("Elapsed Shuffle Time").__()).__();
            ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("elapsed_merge_time").$value("Elapsed Merge Time").__()).__();
            ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("elapsed_reduce_time").$value("Elapsed Reduce Time").__()).__();
        }
        ((Hamlet.TH)footRow.th().input("search_init").$type(HamletSpec.InputType.text).$name("attempt_elapsed").$value("Elapsed Time").__()).__();
        ((Hamlet.TABLE)((Hamlet.TFOOT)footRow.__()).__()).__();
    }
}

