/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.hdfs.util.FoldedTreeSet;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class FoldedTreeSetTest {
    private static Random srand;

    @BeforeClass
    public static void setUpClass() {
        long seed = System.nanoTime();
        System.out.println("This run uses the random seed " + seed);
        srand = new Random(seed);
    }

    @AfterClass
    public static void tearDownClass() {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testComparator() {
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        Assert.assertEquals(null, new FoldedTreeSet().comparator());
        Assert.assertEquals((Object)comparator, new FoldedTreeSet<String>(comparator).comparator());
        FoldedTreeSet<String> set = new FoldedTreeSet<String>(comparator);
        set.add("apa3");
        set.add("apa2");
        set.add("apa");
        set.add("apa5");
        set.add("apa4");
        Assert.assertEquals((long)5L, (long)set.size());
        Assert.assertEquals((Object)"apa", (Object)set.get("apa"));
    }

    @Test
    public void testFirst() {
        int i;
        FoldedTreeSet<Integer> tree = new FoldedTreeSet<Integer>();
        for (i = 0; i < 256; ++i) {
            tree.add(1024 + i);
            Assert.assertEquals((long)1024L, (long)((Integer)tree.first()).intValue());
        }
        for (i = 1; i < 256; ++i) {
            tree.remove(1024 + i);
            Assert.assertEquals((long)1024L, (long)((Integer)tree.first()).intValue());
        }
    }

    @Test
    public void testLast() {
        int i;
        FoldedTreeSet<Integer> tree = new FoldedTreeSet<Integer>();
        for (i = 0; i < 256; ++i) {
            tree.add(1024 + i);
            Assert.assertEquals((long)(1024 + i), (long)((Integer)tree.last()).intValue());
        }
        for (i = 0; i < 255; ++i) {
            tree.remove(1024 + i);
            Assert.assertEquals((long)1279L, (long)((Integer)tree.last()).intValue());
        }
    }

    @Test
    public void testSize() {
        FoldedTreeSet<String> instance = new FoldedTreeSet<String>();
        String entry = "apa";
        Assert.assertEquals((long)0L, (long)instance.size());
        instance.add(entry);
        Assert.assertEquals((long)1L, (long)instance.size());
        instance.remove(entry);
        Assert.assertEquals((long)0L, (long)instance.size());
    }

    @Test
    public void testIsEmpty() {
        FoldedTreeSet<String> instance = new FoldedTreeSet<String>();
        boolean expResult = true;
        boolean result = instance.isEmpty();
        Assert.assertEquals((Object)expResult, (Object)result);
        instance.add("apa");
        instance.remove("apa");
        Assert.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    public void testContains() {
        FoldedTreeSet<String> instance = new FoldedTreeSet<String>();
        String entry = "apa";
        Assert.assertEquals((Object)false, (Object)instance.contains(entry));
        instance.add(entry);
        Assert.assertEquals((Object)true, (Object)instance.contains(entry));
        Assert.assertEquals((Object)false, (Object)instance.contains(entry + entry));
    }

    @Test
    public void testIterator() {
        for (int iter = 0; iter < 10; ++iter) {
            FoldedTreeSet<Holder> set = new FoldedTreeSet<Holder>();
            long[] longs = new long[64723];
            for (int i = 0; i < longs.length; ++i) {
                Holder val = new Holder(srand.nextLong());
                while (set.contains(val)) {
                    val = new Holder(srand.nextLong());
                }
                longs[i] = val.getId();
                set.add(val);
            }
            Assert.assertEquals((long)longs.length, (long)set.size());
            Arrays.sort(longs);
            Iterator it = set.iterator();
            for (int i = 0; i < longs.length; ++i) {
                Assert.assertTrue((boolean)it.hasNext());
                Holder val = (Holder)it.next();
                Assert.assertEquals((long)longs[i], (long)val.getId());
                if (!srand.nextBoolean()) continue;
                it.remove();
            }
        }
    }

    @Test
    public void testToArray() {
        FoldedTreeSet tree = new FoldedTreeSet();
        ArrayList<Integer> list = new ArrayList<Integer>(256);
        for (int i = 0; i < 256; ++i) {
            list.add(1024 + i);
        }
        tree.addAll(list);
        Assert.assertArrayEquals((Object[])list.toArray(), (Object[])tree.toArray());
    }

    @Test
    public void testToArray_GenericType() {
        FoldedTreeSet tree = new FoldedTreeSet();
        ArrayList<Integer> list = new ArrayList<Integer>(256);
        for (int i = 0; i < 256; ++i) {
            list.add(1024 + i);
        }
        tree.addAll(list);
        Assert.assertArrayEquals((Object[])list.toArray(new Integer[tree.size()]), (Object[])tree.toArray(new Integer[tree.size()]));
        Assert.assertArrayEquals((Object[])list.toArray(new Integer[tree.size() + 100]), (Object[])tree.toArray(new Integer[tree.size() + 100]));
    }

    @Test
    public void testAdd() {
        int i;
        FoldedTreeSet<String> simpleSet = new FoldedTreeSet<String>();
        String entry = "apa";
        Assert.assertTrue((boolean)simpleSet.add(entry));
        Assert.assertFalse((boolean)simpleSet.add(entry));
        FoldedTreeSet<Integer> intSet = new FoldedTreeSet<Integer>();
        for (i = 512; i < 1024; ++i) {
            Assert.assertTrue((boolean)intSet.add(i));
        }
        for (i = -1024; i < -512; ++i) {
            Assert.assertTrue((boolean)intSet.add(i));
        }
        for (i = 0; i < 512; ++i) {
            Assert.assertTrue((boolean)intSet.add(i));
        }
        for (i = -512; i < 0; ++i) {
            Assert.assertTrue((boolean)intSet.add(i));
        }
        Assert.assertEquals((long)2048L, (long)intSet.size());
        FoldedTreeSet<Holder> set = new FoldedTreeSet<Holder>();
        long[] longs = new long[23432];
        for (int i2 = 0; i2 < longs.length; ++i2) {
            Holder val = new Holder(srand.nextLong());
            while (set.contains(val)) {
                val = new Holder(srand.nextLong());
            }
            longs[i2] = val.getId();
            Assert.assertTrue((boolean)set.add(val));
        }
        Assert.assertEquals((long)longs.length, (long)set.size());
        Arrays.sort(longs);
        Iterator it = set.iterator();
        for (int i3 = 0; i3 < longs.length; ++i3) {
            Assert.assertTrue((boolean)it.hasNext());
            Holder val = (Holder)it.next();
            Assert.assertEquals((long)longs[i3], (long)val.getId());
        }
        FoldedTreeSet<Integer> specialAdds = new FoldedTreeSet<Integer>();
        for (int i4 = 0; i4 < 128; i4 += 2) {
            Assert.assertTrue((boolean)specialAdds.add(i4));
        }
        Assert.assertTrue((boolean)specialAdds.remove(0));
        Assert.assertTrue((boolean)specialAdds.add(-1));
        Assert.assertTrue((boolean)specialAdds.remove(-1));
        Assert.assertTrue((boolean)specialAdds.add(127));
        Assert.assertTrue((boolean)specialAdds.remove(127));
        Assert.assertTrue((boolean)specialAdds.add(0));
        Assert.assertTrue((boolean)specialAdds.remove(0));
        Assert.assertTrue((boolean)specialAdds.remove(126));
        Assert.assertTrue((boolean)specialAdds.add(11));
        Assert.assertTrue((boolean)specialAdds.remove(11));
        Assert.assertTrue((boolean)specialAdds.add(99));
        Assert.assertTrue((boolean)specialAdds.remove(99));
        Assert.assertFalse((boolean)specialAdds.add(64));
    }

    @Test
    public void testAddOrReplace() {
        int i;
        FoldedTreeSet<String> simpleSet = new FoldedTreeSet<String>();
        String entry = "apa";
        Assert.assertNull((Object)simpleSet.addOrReplace(entry));
        Assert.assertEquals((Object)entry, (Object)simpleSet.addOrReplace(entry));
        FoldedTreeSet<Integer> intSet = new FoldedTreeSet<Integer>();
        for (i = 0; i < 1024; ++i) {
            Assert.assertNull((Object)intSet.addOrReplace(i));
        }
        for (i = 0; i < 1024; ++i) {
            Assert.assertEquals((long)i, (long)intSet.addOrReplace(i).intValue());
        }
    }

    @Test
    public void testRemoveWithComparator() {
        FoldedTreeSet<Holder> set = new FoldedTreeSet<Holder>();
        long[] longs = new long[98327];
        for (int i = 0; i < longs.length; ++i) {
            Holder val = new Holder(srand.nextLong());
            while (set.contains(val)) {
                val = new Holder(srand.nextLong());
            }
            longs[i] = val.getId();
            set.add(val);
        }
        Assert.assertEquals((long)longs.length, (long)set.size());
        Comparator<Object> cmp = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                long stored;
                long lookup = (Long)o1;
                return lookup < (stored = ((Holder)o2).getId()) ? -1 : (lookup > stored ? 1 : 0);
            }
        };
        for (long val : longs) {
            set.remove(val, cmp);
        }
        Assert.assertEquals((long)0L, (long)set.size());
        Assert.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testGetWithComparator() {
        FoldedTreeSet<Holder> set = new FoldedTreeSet<Holder>();
        long[] longs = new long[32147];
        for (int i = 0; i < longs.length; ++i) {
            Holder val = new Holder(srand.nextLong());
            while (set.contains(val)) {
                val = new Holder(srand.nextLong());
            }
            longs[i] = val.getId();
            set.add(val);
        }
        Assert.assertEquals((long)longs.length, (long)set.size());
        Comparator<Object> cmp = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                long stored;
                long lookup = (Long)o1;
                return lookup < (stored = ((Holder)o2).getId()) ? -1 : (lookup > stored ? 1 : 0);
            }
        };
        for (long val : longs) {
            Assert.assertEquals((long)val, (long)((Holder)set.get(val, cmp)).getId());
        }
    }

    @Test
    public void testGet() {
        FoldedTreeSet<Holder> set = new FoldedTreeSet<Holder>();
        long[] longs = new long[43277];
        for (int i = 0; i < longs.length; ++i) {
            Holder val = new Holder(srand.nextLong());
            while (set.contains(val)) {
                val = new Holder(srand.nextLong());
            }
            longs[i] = val.getId();
            set.add(val);
        }
        Assert.assertEquals((long)longs.length, (long)set.size());
        for (long val : longs) {
            Assert.assertEquals((long)val, (long)set.get(new Holder(val)).getId());
        }
    }

    @Test
    public void testRemove() {
        FoldedTreeSet<String> instance = new FoldedTreeSet<String>();
        Assert.assertEquals((Object)false, (Object)instance.remove("apa"));
        instance.add("apa");
        Assert.assertEquals((Object)true, (Object)instance.remove("apa"));
        this.removeLeft();
        this.removeRight();
        this.removeAt();
        this.removeRandom();
    }

    public void removeLeft() {
        int i;
        FoldedTreeSet<Integer> set = new FoldedTreeSet<Integer>();
        for (i = 1; i <= 320; ++i) {
            set.add(i);
        }
        for (i = 193; i < 225; ++i) {
            Assert.assertEquals((Object)true, (Object)set.remove(i));
            Assert.assertEquals((Object)false, (Object)set.remove(i));
        }
        for (i = 129; i < 161; ++i) {
            Assert.assertEquals((Object)true, (Object)set.remove(i));
            Assert.assertEquals((Object)false, (Object)set.remove(i));
        }
        for (i = 256; i > 224; --i) {
            Assert.assertEquals((Object)true, (Object)set.remove(i));
            Assert.assertEquals((Object)false, (Object)set.remove(i));
        }
        for (i = 257; i < 289; ++i) {
            Assert.assertEquals((Object)true, (Object)set.remove(i));
            Assert.assertEquals((Object)false, (Object)set.remove(i));
        }
        while (!set.isEmpty()) {
            Assert.assertTrue((boolean)set.remove(set.first()));
        }
    }

    public void removeRight() {
        int i;
        FoldedTreeSet<Integer> set = new FoldedTreeSet<Integer>();
        for (i = 1; i <= 320; ++i) {
            set.add(i);
        }
        for (i = 193; i < 225; ++i) {
            Assert.assertEquals((Object)true, (Object)set.remove(i));
            Assert.assertEquals((Object)false, (Object)set.remove(i));
        }
        for (i = 192; i > 160; --i) {
            Assert.assertEquals((Object)true, (Object)set.remove(i));
            Assert.assertEquals((Object)false, (Object)set.remove(i));
        }
        for (i = 256; i > 224; --i) {
            Assert.assertEquals((Object)true, (Object)set.remove(i));
            Assert.assertEquals((Object)false, (Object)set.remove(i));
        }
        for (i = 320; i > 288; --i) {
            Assert.assertEquals((Object)true, (Object)set.remove(i));
            Assert.assertEquals((Object)false, (Object)set.remove(i));
        }
        while (!set.isEmpty()) {
            Assert.assertTrue((boolean)set.remove(set.last()));
        }
    }

    public void removeAt() {
        int i;
        FoldedTreeSet<Integer> set = new FoldedTreeSet<Integer>();
        for (i = 1; i <= 320; ++i) {
            set.add(i);
        }
        for (i = 193; i < 225; ++i) {
            Assert.assertEquals((Object)true, (Object)set.remove(i));
            Assert.assertEquals((Object)false, (Object)set.remove(i));
        }
        for (i = 160; i < 192; ++i) {
            Assert.assertEquals((Object)true, (Object)set.remove(i));
            Assert.assertEquals((Object)false, (Object)set.remove(i));
        }
        for (i = 225; i < 257; ++i) {
            Assert.assertEquals((Object)true, (Object)set.remove(i));
            Assert.assertEquals((Object)false, (Object)set.remove(i));
        }
        for (i = 288; i < 320; ++i) {
            Assert.assertEquals((Object)true, (Object)set.remove(i));
            Assert.assertEquals((Object)false, (Object)set.remove(i));
        }
    }

    public void removeRandom() {
        FoldedTreeSet<Integer> set = new FoldedTreeSet<Integer>();
        int[] integers = new int[2048];
        for (int i = 0; i < 2048; ++i) {
            int val = srand.nextInt();
            while (set.contains(val)) {
                val = srand.nextInt();
            }
            integers[i] = val;
            set.add(val);
        }
        Assert.assertEquals((long)2048L, (long)set.size());
        for (int val : integers) {
            Assert.assertEquals((Object)true, (Object)set.remove(val));
            Assert.assertEquals((Object)false, (Object)set.remove(val));
        }
        Assert.assertEquals((Object)true, (Object)set.isEmpty());
    }

    @Test
    public void testContainsAll() {
        List<String> list = Arrays.asList("apa", "apa2", "apa");
        FoldedTreeSet<String> instance = new FoldedTreeSet<String>();
        Assert.assertEquals((Object)false, (Object)instance.containsAll(list));
        instance.addAll(list);
        Assert.assertEquals((Object)true, (Object)instance.containsAll(list));
    }

    @Test
    public void testAddAll() {
        List<String> list = Arrays.asList("apa", "apa2", "apa");
        FoldedTreeSet<String> instance = new FoldedTreeSet<String>();
        Assert.assertEquals((Object)true, (Object)instance.addAll(list));
        Assert.assertEquals((Object)false, (Object)instance.addAll(list));
    }

    @Test
    public void testRetainAll() {
        List<String> list = Arrays.asList("apa", "apa2", "apa");
        FoldedTreeSet<String> instance = new FoldedTreeSet<String>();
        instance.addAll(list);
        Assert.assertEquals((Object)false, (Object)instance.retainAll(list));
        Assert.assertEquals((long)2L, (long)instance.size());
        List<String> list2 = Arrays.asList("apa");
        Assert.assertEquals((Object)true, (Object)instance.retainAll(list2));
        Assert.assertEquals((long)1L, (long)instance.size());
    }

    @Test
    public void testRemoveAll() {
        List<String> list = Arrays.asList("apa", "apa2", "apa");
        FoldedTreeSet<String> instance = new FoldedTreeSet<String>();
        Assert.assertEquals((Object)false, (Object)instance.removeAll(list));
        instance.addAll(list);
        Assert.assertEquals((Object)true, (Object)instance.removeAll(list));
        Assert.assertEquals((Object)true, (Object)instance.isEmpty());
    }

    @Test
    public void testClear() {
        FoldedTreeSet<String> instance = new FoldedTreeSet<String>();
        instance.clear();
        Assert.assertEquals((Object)true, (Object)instance.isEmpty());
        instance.add("apa");
        Assert.assertEquals((Object)false, (Object)instance.isEmpty());
        instance.clear();
        Assert.assertEquals((Object)true, (Object)instance.isEmpty());
    }

    @Test
    public void testFillRatio() {
        int i;
        FoldedTreeSet<Integer> set = new FoldedTreeSet<Integer>();
        int size = 1024;
        for (i = 1; i <= 1024; ++i) {
            set.add(i);
            Assert.assertEquals((String)("Iteration: " + i), (double)1.0, (double)set.fillRatio(), (double)0.0);
        }
        for (i = 1; i <= 512; ++i) {
            set.remove(i * 2);
            Assert.assertEquals((String)("Iteration: " + i), (double)Math.max((double)(1024 - i) / 1024.0, 0.53125), (double)set.fillRatio(), (double)0.0);
        }
    }

    @Test
    public void testCompact() {
        FoldedTreeSet<Holder> set = new FoldedTreeSet<Holder>();
        long[] longs = new long[24553];
        for (int i = 0; i < longs.length; ++i) {
            Holder val = new Holder(srand.nextLong());
            while (set.contains(val)) {
                val = new Holder(srand.nextLong());
            }
            longs[i] = val.getId();
            set.add(val);
        }
        Assert.assertEquals((long)longs.length, (long)set.size());
        long[] longs2 = new long[longs.length];
        for (int i = 0; i < longs2.length; ++i) {
            Holder val = new Holder(srand.nextLong());
            while (set.contains(val)) {
                val = new Holder(srand.nextLong());
            }
            longs2[i] = val.getId();
            set.add(val);
        }
        Assert.assertEquals((long)(longs.length + longs2.length), (long)set.size());
        for (long val : longs) {
            Assert.assertTrue((boolean)set.remove(new Holder(val)));
        }
        Assert.assertEquals((long)longs2.length, (long)set.size());
        Assert.assertFalse((boolean)set.compact(0L));
        Assert.assertTrue((boolean)set.compact(Long.MAX_VALUE));
        Assert.assertEquals((long)longs2.length, (long)set.size());
        for (long val : longs) {
            Assert.assertFalse((boolean)set.remove(new Holder(val)));
        }
        for (long val : longs2) {
            Assert.assertEquals((long)val, (long)set.get(new Holder(val)).getId());
        }
    }

    private static class Holder
    implements Comparable<Holder> {
        private final long id;

        public Holder(long id) {
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        @Override
        public int compareTo(Holder o) {
            return this.id < o.getId() ? -1 : (this.id > o.getId() ? 1 : 0);
        }
    }
}

