/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.qjournal.client.QuorumJournalManager;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogOutputStream;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.TestEditLog;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.shaded.com.google.common.collect.Lists;
import org.junit.Assert;

public abstract class QJMTestUtil {
    public static final NamespaceInfo FAKE_NSINFO = new NamespaceInfo(12345, "mycluster", "my-bp", 0L);
    public static final String JID = "test-journal";

    public static byte[] createTxnData(int startTxn, int numTxns) throws Exception {
        DataOutputBuffer buf = new DataOutputBuffer();
        FSEditLogOp.Writer writer = new FSEditLogOp.Writer(buf);
        for (long txid = (long)startTxn; txid < (long)(startTxn + numTxns); ++txid) {
            FSEditLogOp op = NameNodeAdapter.createMkdirOp("tx " + txid);
            op.setTransactionId(txid);
            writer.writeOp(op, FAKE_NSINFO.getLayoutVersion());
        }
        return Arrays.copyOf(buf.getData(), buf.getLength());
    }

    public static byte[] createGabageTxns(long startTxId, int numTxns) throws IOException {
        DataOutputBuffer buf = new DataOutputBuffer();
        FSEditLogOp.Writer writer = new FSEditLogOp.Writer(buf);
        for (long txid = startTxId; txid < startTxId + (long)numTxns; ++txid) {
            TestEditLog.GarbageMkdirOp op = new TestEditLog.GarbageMkdirOp();
            op.setTransactionId(txid);
            writer.writeOp((FSEditLogOp)op, FAKE_NSINFO.getLayoutVersion());
        }
        return Arrays.copyOf(buf.getData(), buf.getLength());
    }

    public static EditLogOutputStream writeSegment(MiniJournalCluster cluster, QuorumJournalManager qjm, long startTxId, int numTxns, boolean finalize) throws IOException {
        EditLogOutputStream stm = qjm.startLogSegment(startTxId, NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        QJMTestUtil.assertExistsInQuorum(cluster, NNStorage.getInProgressEditsFileName(startTxId));
        QJMTestUtil.writeTxns(stm, startTxId, numTxns);
        if (finalize) {
            stm.close();
            qjm.finalizeLogSegment(startTxId, startTxId + (long)numTxns - 1L);
            return null;
        }
        return stm;
    }

    public static void writeOp(EditLogOutputStream stm, long txid) throws IOException {
        FSEditLogOp op = NameNodeAdapter.createMkdirOp("tx " + txid);
        op.setTransactionId(txid);
        stm.write(op);
    }

    public static void writeTxns(EditLogOutputStream stm, long startTxId, int numTxns) throws IOException {
        for (long txid = startTxId; txid < startTxId + (long)numTxns; ++txid) {
            QJMTestUtil.writeOp(stm, txid);
        }
        stm.setReadyToFlush();
        stm.flush();
    }

    public static void verifyEdits(List<EditLogInputStream> streams, int firstTxnId, int lastTxnId) throws IOException {
        Iterator<EditLogInputStream> iter = streams.iterator();
        Assert.assertTrue((boolean)iter.hasNext());
        EditLogInputStream stream = iter.next();
        for (int expected = firstTxnId; expected <= lastTxnId; ++expected) {
            FSEditLogOp op = stream.readOp();
            while (op == null) {
                Assert.assertTrue((String)("Expected to find txid " + expected + ", but no more streams available to read from"), (boolean)iter.hasNext());
                stream = iter.next();
                op = stream.readOp();
            }
            Assert.assertEquals((Object)((Object)FSEditLogOpCodes.OP_MKDIR), (Object)((Object)op.opCode));
            Assert.assertEquals((long)expected, (long)op.getTransactionId());
        }
        Assert.assertNull((Object)stream.readOp());
        Assert.assertFalse((String)("Expected no more txns after " + lastTxnId + " but more streams are available"), (boolean)iter.hasNext());
    }

    public static void assertExistsInQuorum(MiniJournalCluster cluster, String fname) {
        int count = 0;
        for (int i = 0; i < 3; ++i) {
            File dir = cluster.getCurrentDir(i, JID);
            if (!new File(dir, fname).exists()) continue;
            ++count;
        }
        Assert.assertTrue((String)("File " + fname + " should exist in a quorum of dirs"), (count >= cluster.getQuorumSize() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long recoverAndReturnLastTxn(QuorumJournalManager qjm) throws IOException {
        qjm.recoverUnfinalizedSegments();
        long lastRecoveredTxn = 0L;
        ArrayList streams = Lists.newArrayList();
        try {
            qjm.selectInputStreams(streams, 0L, false);
            for (EditLogInputStream elis : streams) {
                Assert.assertTrue((elis.getFirstTxId() > lastRecoveredTxn ? 1 : 0) != 0);
                lastRecoveredTxn = elis.getLastTxId();
            }
        }
        finally {
            IOUtils.cleanup(null, (Closeable[])streams.toArray(new Closeable[0]));
        }
        return lastRecoveredTxn;
    }
}

