/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class PlacementConstraint {
    private AbstractConstraint constraintExpr;
    static final String NODE_SCOPE = "node";
    static final String RACK_SCOPE = "rack";

    public PlacementConstraint(AbstractConstraint constraintExpr) {
        this.constraintExpr = constraintExpr;
    }

    public String toString() {
        return this.constraintExpr.toString();
    }

    public AbstractConstraint getConstraintExpr() {
        return this.constraintExpr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlacementConstraint)) {
            return false;
        }
        PlacementConstraint that = (PlacementConstraint)o;
        return this.getConstraintExpr() != null ? this.getConstraintExpr().equals(that.getConstraintExpr()) : that.getConstraintExpr() == null;
    }

    public int hashCode() {
        return this.getConstraintExpr() != null ? this.getConstraintExpr().hashCode() : 0;
    }

    public static class TimedPlacementConstraint
    implements Visitable {
        private AbstractConstraint constraint;
        private long schedulingDelay;
        private DelayUnit delayUnit;

        public TimedPlacementConstraint(AbstractConstraint constraint, long schedulingDelay, DelayUnit delayUnit) {
            this.constraint = constraint;
            this.schedulingDelay = schedulingDelay;
            this.delayUnit = delayUnit;
        }

        public TimedPlacementConstraint(AbstractConstraint constraint, long schedulingDelay) {
            this(constraint, schedulingDelay, DelayUnit.MILLISECONDS);
        }

        public TimedPlacementConstraint(AbstractConstraint constraint) {
            this(constraint, Long.MAX_VALUE, DelayUnit.MILLISECONDS);
        }

        public AbstractConstraint getConstraint() {
            return this.constraint;
        }

        public void setConstraint(AbstractConstraint constraint) {
            this.constraint = constraint;
        }

        public long getSchedulingDelay() {
            return this.schedulingDelay;
        }

        public DelayUnit getDelayUnit() {
            return this.delayUnit;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimedPlacementConstraint that = (TimedPlacementConstraint)o;
            if (this.schedulingDelay != that.schedulingDelay) {
                return false;
            }
            if (this.constraint != null ? !this.constraint.equals(that.constraint) : that.constraint != null) {
                return false;
            }
            return this.delayUnit == that.delayUnit;
        }

        public int hashCode() {
            int result = this.constraint != null ? this.constraint.hashCode() : 0;
            result = 31 * result + (int)(this.schedulingDelay ^ this.schedulingDelay >>> 32);
            result = 31 * result + (this.delayUnit != null ? this.delayUnit.hashCode() : 0);
            return result;
        }

        public static enum DelayUnit {
            MILLISECONDS,
            OPPORTUNITIES;

        }
    }

    public static class DelayedOr
    extends CompositeConstraint<TimedPlacementConstraint> {
        private List<TimedPlacementConstraint> children = new ArrayList<TimedPlacementConstraint>();

        public DelayedOr(List<TimedPlacementConstraint> children) {
            this.children = children;
        }

        public DelayedOr(TimedPlacementConstraint ... children) {
            this(Arrays.asList(children));
        }

        @Override
        public List<TimedPlacementConstraint> getChildren() {
            return this.children;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("DelayedOr(");
            Iterator<TimedPlacementConstraint> it = this.getChildren().iterator();
            while (it.hasNext()) {
                TimedPlacementConstraint child = it.next();
                sb.append(child.toString());
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static class Or
    extends CompositeConstraint<AbstractConstraint> {
        private List<AbstractConstraint> children;

        public Or(List<AbstractConstraint> children) {
            this.children = children;
        }

        public Or(AbstractConstraint ... children) {
            this(Arrays.asList(children));
        }

        @Override
        public List<AbstractConstraint> getChildren() {
            return this.children;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("or(");
            Iterator<AbstractConstraint> it = this.getChildren().iterator();
            while (it.hasNext()) {
                AbstractConstraint child = it.next();
                sb.append(child.toString());
                if (!it.hasNext()) continue;
                sb.append(":");
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static class And
    extends CompositeConstraint<AbstractConstraint> {
        private List<AbstractConstraint> children;

        public And(List<AbstractConstraint> children) {
            this.children = children;
        }

        public And(AbstractConstraint ... children) {
            this(Arrays.asList(children));
        }

        @Override
        public List<AbstractConstraint> getChildren() {
            return this.children;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("and(");
            Iterator<AbstractConstraint> it = this.getChildren().iterator();
            while (it.hasNext()) {
                AbstractConstraint child = it.next();
                sb.append(child.toString());
                if (!it.hasNext()) continue;
                sb.append(":");
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static abstract class CompositeConstraint<R extends Visitable>
    extends AbstractConstraint {
        public abstract List<R> getChildren();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.getChildren() != null ? this.getChildren().equals(((CompositeConstraint)o).getChildren()) : ((CompositeConstraint)o).getChildren() == null;
        }

        public int hashCode() {
            return this.getChildren() != null ? this.getChildren().hashCode() : 0;
        }
    }

    public static class CardinalityConstraint
    extends AbstractConstraint {
        private String scope;
        private int minCardinality;
        private int maxCardinality;
        private Set<String> allocationTags;

        public CardinalityConstraint(String scope, int minCardinality, int maxCardinality, Set<String> allocationTags) {
            this.scope = scope;
            this.minCardinality = minCardinality;
            this.maxCardinality = maxCardinality;
            this.allocationTags = allocationTags;
        }

        public String getScope() {
            return this.scope;
        }

        public int getMinCardinality() {
            return this.minCardinality;
        }

        public int getMaxCardinality() {
            return this.maxCardinality;
        }

        public Set<String> getAllocationTags() {
            return this.allocationTags;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CardinalityConstraint that = (CardinalityConstraint)o;
            if (this.minCardinality != that.minCardinality) {
                return false;
            }
            if (this.maxCardinality != that.maxCardinality) {
                return false;
            }
            if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) {
                return false;
            }
            return this.allocationTags != null ? this.allocationTags.equals(that.allocationTags) : that.allocationTags == null;
        }

        public int hashCode() {
            int result = this.scope != null ? this.scope.hashCode() : 0;
            result = 31 * result + this.minCardinality;
            result = 31 * result + this.maxCardinality;
            result = 31 * result + (this.allocationTags != null ? this.allocationTags.hashCode() : 0);
            return result;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("cardinality").append(",").append(this.getScope()).append(",");
            for (String tag : this.getAllocationTags()) {
                sb.append(tag).append(",");
            }
            sb.append(this.minCardinality).append(",").append(this.maxCardinality);
            return sb.toString();
        }
    }

    public static class TargetConstraint
    extends AbstractConstraint {
        private TargetOperator op;
        private String scope;
        private Set<TargetExpression> targetExpressions;

        public TargetConstraint(TargetOperator op, String scope, Set<TargetExpression> targetExpressions) {
            this.op = op;
            this.scope = scope;
            this.targetExpressions = targetExpressions;
        }

        public TargetOperator getOp() {
            return this.op;
        }

        public String getScope() {
            return this.scope;
        }

        public Set<TargetExpression> getTargetExpressions() {
            return this.targetExpressions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TargetConstraint)) {
                return false;
            }
            TargetConstraint that = (TargetConstraint)o;
            if (this.getOp() != that.getOp()) {
                return false;
            }
            if (!this.getScope().equals(that.getScope())) {
                return false;
            }
            return this.getTargetExpressions().equals(that.getTargetExpressions());
        }

        public int hashCode() {
            int result = this.getOp().hashCode();
            result = 31 * result + this.getScope().hashCode();
            result = 31 * result + this.getTargetExpressions().hashCode();
            return result;
        }

        @Override
        public String toString() {
            List targetExprs = this.getTargetExpressions().stream().map(targetExpression -> this.op.getOperator() + "," + this.scope + "," + targetExpression.toString()).collect(Collectors.toList());
            return String.join((CharSequence)":", targetExprs);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this);
        }

        static enum TargetOperator {
            IN("in"),
            NOT_IN("notin");

            private String operator;

            private TargetOperator(String op) {
                this.operator = op;
            }

            String getOperator() {
                return this.operator;
            }
        }
    }

    public static class TargetExpression
    implements Visitable {
        private TargetType targetType;
        private String targetKey;
        private Set<String> targetValues;

        public TargetExpression(TargetType targetType, String targetKey, Set<String> targetValues) {
            this.targetType = targetType;
            this.targetKey = targetKey;
            this.targetValues = targetValues;
        }

        public TargetExpression(TargetType targetType) {
            this(targetType, null, new HashSet<String>());
        }

        public TargetExpression(TargetType targetType, String targetKey, String ... targetValues) {
            this(targetType, targetKey, new HashSet<String>(Arrays.asList(targetValues)));
        }

        public TargetType getTargetType() {
            return this.targetType;
        }

        public String getTargetKey() {
            return this.targetKey;
        }

        public Set<String> getTargetValues() {
            return this.targetValues;
        }

        public int hashCode() {
            int result = this.targetType != null ? this.targetType.hashCode() : 0;
            result = 31 * result + (this.targetKey != null ? this.targetKey.hashCode() : 0);
            result = 31 * result + (this.targetValues != null ? this.targetValues.hashCode() : 0);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof TargetExpression)) {
                return false;
            }
            TargetExpression that = (TargetExpression)o;
            if (this.targetType != that.targetType) {
                return false;
            }
            if (this.targetKey != null ? !this.targetKey.equals(that.targetKey) : that.targetKey != null) {
                return false;
            }
            return this.targetValues != null ? this.targetValues.equals(that.targetValues) : that.targetValues == null;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (TargetType.ALLOCATION_TAG == this.targetType) {
                sb.append(String.join((CharSequence)",", this.getTargetValues()));
            } else if (TargetType.NODE_ATTRIBUTE == this.targetType && this.getTargetValues() != null) {
                String attributeName = this.getTargetKey();
                String attributeValues = String.join((CharSequence)":", this.getTargetValues());
                sb.append(attributeName + "=[" + attributeValues + "]");
            }
            return sb.toString();
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this);
        }

        public static enum TargetType {
            NODE_ATTRIBUTE,
            ALLOCATION_TAG;

        }
    }

    public static class SingleConstraint
    extends AbstractConstraint {
        private String scope;
        private int minCardinality;
        private int maxCardinality;
        private Set<TargetExpression> targetExpressions;

        public SingleConstraint(String scope, int minCardinality, int maxCardinality, Set<TargetExpression> targetExpressions) {
            this.scope = scope;
            this.minCardinality = minCardinality;
            this.maxCardinality = maxCardinality;
            this.targetExpressions = targetExpressions;
        }

        public SingleConstraint(String scope, int minC, int maxC, TargetExpression ... targetExpressions) {
            this(scope, minC, maxC, new HashSet<TargetExpression>(Arrays.asList(targetExpressions)));
        }

        public String getScope() {
            return this.scope;
        }

        public int getMinCardinality() {
            return this.minCardinality;
        }

        public int getMaxCardinality() {
            return this.maxCardinality;
        }

        public Set<TargetExpression> getTargetExpressions() {
            return this.targetExpressions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SingleConstraint)) {
                return false;
            }
            SingleConstraint that = (SingleConstraint)o;
            if (this.getMinCardinality() != that.getMinCardinality()) {
                return false;
            }
            if (this.getMaxCardinality() != that.getMaxCardinality()) {
                return false;
            }
            if (!this.getScope().equals(that.getScope())) {
                return false;
            }
            return this.getTargetExpressions().equals(that.getTargetExpressions());
        }

        public int hashCode() {
            int result = this.getScope().hashCode();
            result = 31 * result + this.getMinCardinality();
            result = 31 * result + this.getMaxCardinality();
            result = 31 * result + this.getTargetExpressions().hashCode();
            return result;
        }

        @Override
        public String toString() {
            int max = this.getMaxCardinality();
            int min = this.getMinCardinality();
            List targetExprList = this.getTargetExpressions().stream().map(TargetExpression::toString).collect(Collectors.toList());
            ArrayList<String> targetConstraints = new ArrayList<String>();
            for (String targetExpr : targetExprList) {
                if (min == 0 && max == 0) {
                    targetConstraints.add("notin" + "," + this.getScope() + "," + targetExpr);
                    continue;
                }
                if (min == 1 && max == Integer.MAX_VALUE) {
                    targetConstraints.add("in" + "," + this.getScope() + "," + targetExpr);
                    continue;
                }
                targetConstraints.add("cardinality" + "," + this.getScope() + "," + targetExpr + "," + min + "," + max);
            }
            return String.join((CharSequence)":", targetConstraints);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visit(this);
        }
    }

    public static abstract class AbstractConstraint
    implements Visitable {
        public PlacementConstraint build() {
            return new PlacementConstraint(this);
        }

        public String toString() {
            return super.toString();
        }
    }

    @InterfaceAudience.Private
    public static interface Visitor<T> {
        public T visit(SingleConstraint var1);

        public T visit(TargetExpression var1);

        public T visit(TargetConstraint var1);

        public T visit(CardinalityConstraint var1);

        public T visit(And var1);

        public T visit(Or var1);

        public T visit(DelayedOr var1);

        public T visit(TimedPlacementConstraint var1);
    }

    @InterfaceAudience.Private
    public static interface Visitable {
        public <T> T accept(Visitor<T> var1);
    }
}

