/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;
import org.apache.hadoop.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ser.std.StdSerializer;

public class StdKeySerializer
extends StdSerializer<Object> {
    public StdKeySerializer() {
        super(Object.class);
    }

    @Override
    public void serialize(Object value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        String str;
        Class<?> cls = value.getClass();
        if (cls == String.class) {
            str = (String)value;
        } else if (cls.isEnum()) {
            Enum en = (Enum)value;
            str = provider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING) ? en.toString() : en.name();
        } else {
            if (value instanceof Date) {
                provider.defaultSerializeDateKey((Date)value, g2);
                return;
            }
            str = cls == Class.class ? ((Class)value).getName() : value.toString();
        }
        g2.writeFieldName(str);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string");
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

