/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestGetContentSummaryWithSnapshot {
    protected static final short REPLICATION = 3;
    protected static final long BLOCKSIZE = 1024L;
    protected Configuration conf;
    protected MiniDFSCluster cluster;
    protected FSNamesystem fsn;
    protected FSDirectory fsdir;
    protected DistributedFileSystem dfs;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        this.conf.setLong("dfs.blocksize", 1024L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.fsn = this.cluster.getNamesystem();
        this.fsdir = this.fsn.getFSDirectory();
        this.dfs = this.cluster.getFileSystem();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testGetContentSummary() throws IOException {
        Path foo = new Path("/foo");
        Path bar = new Path(foo, "bar");
        Path baz = new Path(bar, "baz");
        this.dfs.mkdirs(bar);
        this.dfs.allowSnapshot(foo);
        this.dfs.createSnapshot(foo, "s1");
        DFSTestUtil.createFile((FileSystem)this.dfs, baz, 10L, (short)3, 0L);
        ContentSummary summary = this.cluster.getNameNodeRpc().getContentSummary(bar.toString());
        Assert.assertEquals((long)1L, (long)summary.getDirectoryCount());
        Assert.assertEquals((long)1L, (long)summary.getFileCount());
        Assert.assertEquals((long)10L, (long)summary.getLength());
        Path barS1 = SnapshotTestHelper.getSnapshotPath(foo, "s1", "bar");
        summary = this.cluster.getNameNodeRpc().getContentSummary(barS1.toString());
        Assert.assertEquals((long)1L, (long)summary.getDirectoryCount());
        Assert.assertEquals((long)0L, (long)summary.getFileCount());
        Assert.assertEquals((long)0L, (long)summary.getLength());
        summary = this.cluster.getNameNodeRpc().getContentSummary(foo.toString());
        Assert.assertEquals((long)2L, (long)summary.getDirectoryCount());
        Assert.assertEquals((long)1L, (long)summary.getFileCount());
        Assert.assertEquals((long)10L, (long)summary.getLength());
        Path fooS1 = SnapshotTestHelper.getSnapshotRoot(foo, "s1");
        summary = this.cluster.getNameNodeRpc().getContentSummary(fooS1.toString());
        Assert.assertEquals((long)2L, (long)summary.getDirectoryCount());
        Assert.assertEquals((long)0L, (long)summary.getFileCount());
        Assert.assertEquals((long)0L, (long)summary.getLength());
        this.dfs.createSnapshot(foo, "s2");
        DFSTestUtil.appendFile((FileSystem)this.dfs, baz, 10);
        summary = this.cluster.getNameNodeRpc().getContentSummary(bar.toString());
        Assert.assertEquals((long)1L, (long)summary.getDirectoryCount());
        Assert.assertEquals((long)1L, (long)summary.getFileCount());
        Assert.assertEquals((long)20L, (long)summary.getLength());
        Path fooS2 = SnapshotTestHelper.getSnapshotRoot(foo, "s2");
        summary = this.cluster.getNameNodeRpc().getContentSummary(fooS2.toString());
        Assert.assertEquals((long)2L, (long)summary.getDirectoryCount());
        Assert.assertEquals((long)1L, (long)summary.getFileCount());
        Assert.assertEquals((long)10L, (long)summary.getLength());
        this.cluster.getNameNodeRpc().delete(baz.toString(), false);
        summary = this.cluster.getNameNodeRpc().getContentSummary(foo.toString());
        Assert.assertEquals((long)0L, (long)summary.getSnapshotDirectoryCount());
        Assert.assertEquals((long)1L, (long)summary.getSnapshotFileCount());
        Assert.assertEquals((long)20L, (long)summary.getSnapshotLength());
        Path bazS1 = SnapshotTestHelper.getSnapshotPath(foo, "s1", "bar/baz");
        try {
            this.cluster.getNameNodeRpc().getContentSummary(bazS1.toString());
            Assert.fail((String)"should get FileNotFoundException");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }
}

