/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.qjournal.MiniQJMHACluster;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.TestFsck;
import org.apache.hadoop.hdfs.server.namenode.ha.BootstrapStandby;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.server.namenode.ha.ObserverReadProxyProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestObserverNode {
    public static final Logger LOG = LoggerFactory.getLogger((String)TestObserverNode.class.getName());
    private static Configuration conf;
    private static MiniQJMHACluster qjmhaCluster;
    private static MiniDFSCluster dfsCluster;
    private static DistributedFileSystem dfs;
    private final Path testPath = new Path("/TestObserverNode");

    @BeforeClass
    public static void startUpCluster() throws Exception {
        conf = new Configuration();
        qjmhaCluster = HATestUtil.setUpObserverCluster(conf, 1, 0, true);
        dfsCluster = qjmhaCluster.getDfsCluster();
    }

    @Before
    public void setUp() throws Exception {
        TestObserverNode.setObserverRead(true);
    }

    @After
    public void cleanUp() throws IOException {
        dfs.delete(this.testPath, true);
        Assert.assertEquals((String)"NN[0] should be active", (Object)HAServiceProtocol.HAServiceState.ACTIVE, (Object)NameNodeAdapter.getServiceState(dfsCluster.getNameNode(0)));
        Assert.assertEquals((String)"NN[1] should be standby", (Object)HAServiceProtocol.HAServiceState.STANDBY, (Object)NameNodeAdapter.getServiceState(dfsCluster.getNameNode(1)));
        Assert.assertEquals((String)"NN[2] should be observer", (Object)HAServiceProtocol.HAServiceState.OBSERVER, (Object)NameNodeAdapter.getServiceState(dfsCluster.getNameNode(2)));
    }

    @AfterClass
    public static void shutDownCluster() throws IOException {
        if (qjmhaCluster != null) {
            qjmhaCluster.shutdown();
        }
    }

    @Test
    public void testNoActiveToObserver() throws Exception {
        try {
            dfsCluster.transitionToObserver(0);
        }
        catch (ServiceFailedException e) {
            return;
        }
        Assert.fail((String)"active cannot be transitioned to observer");
    }

    @Test
    public void testNoObserverToActive() throws Exception {
        try {
            dfsCluster.transitionToActive(2);
        }
        catch (ServiceFailedException e) {
            return;
        }
        Assert.fail((String)"observer cannot be transitioned to active");
    }

    @Test
    public void testSimpleRead() throws Exception {
        Path testPath2 = new Path(this.testPath, "test2");
        dfs.mkdir(this.testPath, FsPermission.getDefault());
        this.assertSentTo(0);
        dfsCluster.rollEditLogAndTail(0);
        dfs.getFileStatus(this.testPath);
        this.assertSentTo(2);
        dfs.mkdir(testPath2, FsPermission.getDefault());
        this.assertSentTo(0);
    }

    @Test
    public void testFailover() throws Exception {
        Path testPath2 = new Path(this.testPath, "test2");
        TestObserverNode.setObserverRead(false);
        dfs.mkdir(this.testPath, FsPermission.getDefault());
        this.assertSentTo(0);
        dfs.getFileStatus(this.testPath);
        this.assertSentTo(0);
        dfsCluster.transitionToStandby(0);
        dfsCluster.transitionToActive(1);
        dfsCluster.waitActive(1);
        dfs.mkdir(testPath2, FsPermission.getDefault());
        this.assertSentTo(1);
        dfs.getFileStatus(this.testPath);
        this.assertSentTo(1);
        dfsCluster.transitionToStandby(1);
        dfsCluster.transitionToActive(0);
        dfsCluster.waitActive(0);
    }

    @Test
    public void testDoubleFailover() throws Exception {
        Path testPath2 = new Path(this.testPath, "test2");
        Path testPath3 = new Path(this.testPath, "test3");
        dfs.mkdir(this.testPath, FsPermission.getDefault());
        this.assertSentTo(0);
        dfsCluster.rollEditLogAndTail(0);
        dfs.getFileStatus(this.testPath);
        this.assertSentTo(2);
        dfs.mkdir(testPath2, FsPermission.getDefault());
        this.assertSentTo(0);
        dfsCluster.transitionToStandby(0);
        dfsCluster.transitionToActive(1);
        dfsCluster.waitActive(1);
        dfsCluster.rollEditLogAndTail(1);
        dfs.getFileStatus(testPath2);
        this.assertSentTo(2);
        dfs.mkdir(testPath3, FsPermission.getDefault());
        this.assertSentTo(1);
        dfsCluster.transitionToStandby(1);
        dfsCluster.transitionToActive(0);
        dfsCluster.waitActive(0);
        dfsCluster.rollEditLogAndTail(0);
        dfs.getFileStatus(testPath3);
        this.assertSentTo(2);
        dfs.delete(testPath3, false);
        this.assertSentTo(0);
    }

    @Test
    public void testObserverShutdown() throws Exception {
        dfs.mkdir(this.testPath, FsPermission.getDefault());
        dfsCluster.rollEditLogAndTail(0);
        dfs.getFileStatus(this.testPath);
        this.assertSentTo(2);
        dfsCluster.shutdownNameNode(2);
        dfs.getFileStatus(this.testPath);
        this.assertSentTo(0);
        dfsCluster.restartNameNode(2);
        dfsCluster.transitionToObserver(2);
        dfs.getFileStatus(this.testPath);
        dfs.getFileStatus(this.testPath);
        this.assertSentTo(2);
    }

    @Test
    public void testObserverFailOverAndShutdown() throws Exception {
        dfs.mkdir(this.testPath, FsPermission.getDefault());
        dfsCluster.rollEditLogAndTail(0);
        dfs.getFileStatus(this.testPath);
        this.assertSentTo(2);
        dfsCluster.transitionToStandby(0);
        dfsCluster.transitionToActive(1);
        dfsCluster.waitActive(1);
        dfsCluster.shutdownNameNode(2);
        dfs.getFileStatus(this.testPath);
        this.assertSentTo(1);
        dfsCluster.restartNameNode(2);
        dfs.getFileStatus(this.testPath);
        this.assertSentTo(1);
        dfsCluster.transitionToObserver(2);
        dfs.getFileStatus(this.testPath);
        dfs.getFileStatus(this.testPath);
        this.assertSentTo(2);
        dfsCluster.transitionToStandby(1);
        dfsCluster.transitionToActive(0);
        dfsCluster.waitActive(0);
    }

    @Test
    public void testBootstrap() throws Exception {
        for (URI u : dfsCluster.getNameDirs(2)) {
            File dir = new File(u.getPath());
            Assert.assertTrue((boolean)FileUtil.fullyDelete((File)dir));
        }
        int rc = BootstrapStandby.run((String[])new String[]{"-nonInteractive"}, (Configuration)dfsCluster.getConfiguration(2));
        Assert.assertEquals((long)0L, (long)rc);
    }

    @Test
    public void testObserverNodeSafeModeWithBlockLocations() throws Exception {
        dfs.create(this.testPath, (short)1).close();
        this.assertSentTo(0);
        dfsCluster.rollEditLogAndTail(0);
        dfs.open(this.testPath).close();
        this.assertSentTo(2);
        dfsCluster.getFileSystem(2).setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        BlockManager bmSpy = NameNodeAdapter.spyOnBlockManager(dfsCluster.getNameNode(2));
        ((BlockManager)Mockito.doAnswer(invocation -> {
            ExtendedBlock b = new ExtendedBlock("fake-pool", new Block(12345L));
            LocatedBlock fakeBlock = new LocatedBlock(b, DatanodeInfo.EMPTY_ARRAY);
            ArrayList<LocatedBlock> fakeBlocks = new ArrayList<LocatedBlock>();
            fakeBlocks.add(fakeBlock);
            return new LocatedBlocks(0L, false, fakeBlocks, null, true, null, null);
        }).when((Object)bmSpy)).createLocatedBlocks((BlockInfo[])Matchers.any(), Matchers.anyLong(), Matchers.anyBoolean(), Matchers.anyLong(), Matchers.anyLong(), Matchers.anyBoolean(), Matchers.anyBoolean(), (FileEncryptionInfo)Matchers.any(), (ErasureCodingPolicy)Matchers.any());
        dfs.open(this.testPath).close();
        this.assertSentTo(0);
        Mockito.reset((Object[])new BlockManager[]{bmSpy});
        dfsCluster.getFileSystem(2).setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        dfs.open(this.testPath).close();
        this.assertSentTo(2);
    }

    @Test
    public void testObserverNodeBlockMissingRetry() throws Exception {
        TestObserverNode.setObserverRead(true);
        dfs.create(this.testPath, (short)1).close();
        this.assertSentTo(0);
        dfsCluster.rollEditLogAndTail(0);
        BlockManager bmSpy = NameNodeAdapter.spyOnBlockManager(dfsCluster.getNameNode(2));
        ((BlockManager)Mockito.doAnswer(invocation -> {
            ArrayList<LocatedBlock> fakeBlocks = new ArrayList<LocatedBlock>();
            ExtendedBlock b = new ExtendedBlock("fake-pool", new Block(12345L));
            LocatedBlock fakeBlock = new LocatedBlock(b, DatanodeInfo.EMPTY_ARRAY);
            fakeBlocks.add(fakeBlock);
            return new LocatedBlocks(0L, false, fakeBlocks, null, true, null, null);
        }).when((Object)bmSpy)).createLocatedBlocks((BlockInfo[])Mockito.any(), Matchers.anyLong(), Matchers.anyBoolean(), Matchers.anyLong(), Matchers.anyLong(), Matchers.anyBoolean(), Matchers.anyBoolean(), (FileEncryptionInfo)Mockito.any(), (ErasureCodingPolicy)Mockito.any());
        dfs.open(this.testPath);
        this.assertSentTo(0);
        Mockito.reset((Object[])new BlockManager[]{bmSpy});
    }

    @Test
    public void testFsckWithObserver() throws Exception {
        TestObserverNode.setObserverRead(true);
        dfs.create(this.testPath, (short)1).close();
        this.assertSentTo(0);
        String result = TestFsck.runFsck(conf, 0, true, "/");
        LOG.info("result=" + result);
        Assert.assertTrue((boolean)result.contains("Status: HEALTHY"));
    }

    private void assertSentTo(int nnIdx) throws IOException {
        Assert.assertTrue((String)("Request was not sent to the expected namenode " + nnIdx), (boolean)HATestUtil.isSentToAnyOfNameNodes(dfs, dfsCluster, nnIdx));
    }

    private static void setObserverRead(boolean flag) throws Exception {
        dfs = HATestUtil.configureObserverReadFs(dfsCluster, conf, ObserverReadProxyProvider.class, flag);
    }
}

