/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.base.Supplier;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocolPB.DatanodeLifelineProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.metrics.DataNodeMetrics;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataNodeLifeline {
    private static final Logger LOG = LoggerFactory.getLogger(TestDataNodeLifeline.class);
    @Rule
    public Timeout timeout = new Timeout(60000);
    private MiniDFSCluster cluster;
    private HdfsConfiguration conf;
    private DatanodeLifelineProtocolClientSideTranslatorPB lifelineNamenode;
    private DataNodeMetrics metrics;
    private DatanodeProtocolClientSideTranslatorPB namenode;
    private FSNamesystem namesystem;
    private DataNode dn;
    private BPServiceActor bpsa;

    @Before
    public void setup() throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setInt("dfs.datanode.lifeline.interval.seconds", 2);
        this.conf.setInt("dfs.heartbeat.interval", 1);
        this.conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1);
        this.conf.set("dfs.namenode.lifeline.rpc-address", "0.0.0.0:0");
        this.conf.setInt("dfs.namenode.stale.datanode.interval", 6000);
        this.cluster = new MiniDFSCluster.Builder((Configuration)this.conf).numDataNodes(1).build();
        this.namesystem = this.cluster.getNameNode().getNamesystem();
        this.dn = this.cluster.getDataNodes().get(0);
        this.metrics = this.dn.getMetrics();
        Assert.assertNotNull((Object)this.metrics);
        List allBpos = this.dn.getAllBpOs();
        Assert.assertNotNull((Object)allBpos);
        Assert.assertEquals((long)1L, (long)allBpos.size());
        BPOfferService bpos = (BPOfferService)allBpos.get(0);
        List allBpsa = bpos.getBPServiceActors();
        Assert.assertNotNull((Object)allBpsa);
        Assert.assertEquals((long)1L, (long)allBpsa.size());
        this.bpsa = (BPServiceActor)allBpsa.get(0);
        Assert.assertNotNull((Object)this.bpsa);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                if (TestDataNodeLifeline.this.bpsa.getLifelineNameNodeProxy() != null) {
                    TestDataNodeLifeline.this.lifelineNamenode = (DatanodeLifelineProtocolClientSideTranslatorPB)Mockito.spy((Object)TestDataNodeLifeline.this.bpsa.getLifelineNameNodeProxy());
                    TestDataNodeLifeline.this.bpsa.setLifelineNameNode(TestDataNodeLifeline.this.lifelineNamenode);
                }
                return TestDataNodeLifeline.this.lifelineNamenode != null;
            }
        }, (int)100, (int)10000);
        Assert.assertNotNull((Object)this.bpsa.getNameNodeProxy());
        this.namenode = (DatanodeProtocolClientSideTranslatorPB)Mockito.spy((Object)this.bpsa.getNameNodeProxy());
        this.bpsa.setNameNode(this.namenode);
    }

    @After
    public void shutdown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            GenericTestUtils.assertNoThreadsMatching((String)".*lifeline.*");
        }
    }

    @Test
    public void testSendLifelineIfHeartbeatBlocked() throws Exception {
        int numLifelines = 10;
        CountDownLatch lifelinesSent = new CountDownLatch(numLifelines);
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer(new LatchAwaitingAnswer(lifelinesSent)).when((Object)this.namenode)).sendHeartbeat((DatanodeRegistration)Mockito.any(DatanodeRegistration.class), (StorageReport[])Mockito.any(StorageReport[].class), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), (VolumeFailureSummary)Mockito.any(VolumeFailureSummary.class), Mockito.anyBoolean(), (SlowPeerReports)Mockito.any(SlowPeerReports.class), (SlowDiskReports)Mockito.any(SlowDiskReports.class));
        ((DatanodeLifelineProtocolClientSideTranslatorPB)Mockito.doAnswer(new LatchCountingAnswer(lifelinesSent)).when((Object)this.lifelineNamenode)).sendLifeline((DatanodeRegistration)Mockito.any(DatanodeRegistration.class), (StorageReport[])Mockito.any(StorageReport[].class), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), (VolumeFailureSummary)Mockito.any(VolumeFailureSummary.class));
        while (!lifelinesSent.await(1L, TimeUnit.SECONDS)) {
            Assert.assertEquals((String)"Expect DataNode to be kept alive by lifeline.", (long)1L, (long)this.namesystem.getNumLiveDataNodes());
            Assert.assertEquals((String)"Expect DataNode not marked dead due to lifeline.", (long)0L, (long)this.namesystem.getNumDeadDataNodes());
            Assert.assertEquals((String)"Expect DataNode not marked stale due to lifeline.", (long)0L, (long)this.namesystem.getNumStaleDataNodes());
            this.cluster.getDataNodes().get(0).reconfigurePropertyImpl("dfs.datanode.data.dir", this.cluster.getDataDirectory().concat("/data-new"));
        }
        ((DatanodeLifelineProtocolClientSideTranslatorPB)Mockito.verify((Object)this.lifelineNamenode, (VerificationMode)Mockito.atLeastOnce())).sendLifeline((DatanodeRegistration)Mockito.any(DatanodeRegistration.class), (StorageReport[])Mockito.any(StorageReport[].class), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), (VolumeFailureSummary)Mockito.any(VolumeFailureSummary.class));
        Assert.assertTrue((String)("Expect metrics to count at least " + numLifelines + " calls."), (MetricsAsserts.getLongCounter((String)"LifelinesNumOps", (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)this.metrics.name())) >= (long)numLifelines ? 1 : 0) != 0);
    }

    @Test
    public void testNoLifelineSentIfHeartbeatsOnTime() throws Exception {
        int numHeartbeats = 10;
        CountDownLatch heartbeatsSent = new CountDownLatch(numHeartbeats);
        ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer(new LatchCountingAnswer(heartbeatsSent)).when((Object)this.namenode)).sendHeartbeat((DatanodeRegistration)Mockito.any(DatanodeRegistration.class), (StorageReport[])Mockito.any(StorageReport[].class), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), (VolumeFailureSummary)Mockito.any(VolumeFailureSummary.class), Mockito.anyBoolean(), (SlowPeerReports)Mockito.any(SlowPeerReports.class), (SlowDiskReports)Mockito.any(SlowDiskReports.class));
        while (!heartbeatsSent.await(1L, TimeUnit.SECONDS)) {
            Assert.assertEquals((String)"Expect DataNode to be kept alive by lifeline.", (long)1L, (long)this.namesystem.getNumLiveDataNodes());
            Assert.assertEquals((String)"Expect DataNode not marked dead due to lifeline.", (long)0L, (long)this.namesystem.getNumDeadDataNodes());
            Assert.assertEquals((String)"Expect DataNode not marked stale due to lifeline.", (long)0L, (long)this.namesystem.getNumStaleDataNodes());
        }
        ((DatanodeLifelineProtocolClientSideTranslatorPB)Mockito.verify((Object)this.lifelineNamenode, (VerificationMode)Mockito.never())).sendLifeline((DatanodeRegistration)Mockito.any(DatanodeRegistration.class), (StorageReport[])Mockito.any(StorageReport[].class), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), (VolumeFailureSummary)Mockito.any(VolumeFailureSummary.class));
        Assert.assertEquals((String)"Expect metrics to count no lifeline calls.", (long)0L, (long)MetricsAsserts.getLongCounter((String)"LifelinesNumOps", (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)this.metrics.name())));
    }

    @Test
    public void testLifelineForDeadNode() throws Exception {
        long initialCapacity = this.cluster.getNamesystem(0).getCapacityTotal();
        Assert.assertTrue((initialCapacity > 0L ? 1 : 0) != 0);
        this.dn.setHeartbeatsDisabledForTests(true);
        this.cluster.setDataNodesDead();
        Assert.assertEquals((String)"Capacity should be 0 after all DNs dead", (long)0L, (long)this.cluster.getNamesystem(0).getCapacityTotal());
        this.bpsa.sendLifelineForTests();
        Assert.assertEquals((String)"Lifeline should be ignored for dead node", (long)0L, (long)this.cluster.getNamesystem(0).getCapacityTotal());
        this.dn.setHeartbeatsDisabledForTests(false);
        final DatanodeDescriptor dnDesc = (DatanodeDescriptor)this.cluster.getNamesystem(0).getBlockManager().getDatanodeManager().getDatanodes().iterator().next();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return dnDesc.isAlive() && dnDesc.isHeartbeatedSinceRegistration();
            }
        }, (int)100, (int)5000);
        Assert.assertEquals((String)"Capacity should include only live capacity", (long)initialCapacity, (long)this.cluster.getNamesystem(0).getCapacityTotal());
    }

    static {
        GenericTestUtils.setLogLevel((Logger)DataNode.LOG, (Level)Level.ALL);
    }

    private final class LatchCountingAnswer<T>
    implements Answer<T> {
        private final CountDownLatch latch;

        public LatchCountingAnswer(CountDownLatch latch) {
            this.latch = latch;
        }

        public T answer(InvocationOnMock invocation) throws Throwable {
            Object result = invocation.callRealMethod();
            this.latch.countDown();
            LOG.info("Countdown, remaining latch count is {}.", (Object)this.latch.getCount());
            return (T)result;
        }
    }

    private final class LatchAwaitingAnswer<T>
    implements Answer<T> {
        private final CountDownLatch latch;

        public LatchAwaitingAnswer(CountDownLatch latch) {
            this.latch = latch;
        }

        public T answer(InvocationOnMock invocation) throws Throwable {
            LOG.info("Awaiting, remaining latch count is {}.", (Object)this.latch.getCount());
            this.latch.await();
            return (T)invocation.callRealMethod();
        }
    }
}

