/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.rmadmin;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.api.ResourceManagerAdministrationProtocol;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.AddToClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.CheckForDecommissioningNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.CheckForDecommissioningNodesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshClusterMaxPriorityRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshClusterMaxPriorityResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResourcesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResourcesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceResponse;
import org.apache.hadoop.yarn.server.router.rmadmin.AbstractRMAdminRequestInterceptor;
import org.apache.hadoop.yarn.server.router.rmadmin.RMAdminRequestInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRMAdminRequestInterceptor
extends AbstractRMAdminRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRMAdminRequestInterceptor.class);
    private ResourceManagerAdministrationProtocol rmAdminProxy;
    private UserGroupInformation user = null;

    @Override
    public void init(String userName) {
        super.init(userName);
        try {
            this.user = userName.equalsIgnoreCase(UserGroupInformation.getCurrentUser().getUserName()) ? UserGroupInformation.getCurrentUser() : UserGroupInformation.createProxyUser((String)userName, (UserGroupInformation)UserGroupInformation.getCurrentUser());
            final Configuration conf = this.getConf();
            this.rmAdminProxy = (ResourceManagerAdministrationProtocol)this.user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ResourceManagerAdministrationProtocol>(){

                @Override
                public ResourceManagerAdministrationProtocol run() throws Exception {
                    return (ResourceManagerAdministrationProtocol)ClientRMProxy.createRMProxy((Configuration)conf, ResourceManagerAdministrationProtocol.class);
                }
            });
        }
        catch (IOException e) {
            String message = "Error while creating Router RMAdmin Service for user:";
            if (this.user != null) {
                message = message + ", user: " + this.user;
            }
            LOG.info(message);
            throw new YarnRuntimeException(message, (Throwable)e);
        }
        catch (Exception e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    @Override
    public void setNextInterceptor(RMAdminRequestInterceptor next) {
        throw new YarnRuntimeException("setNextInterceptor is being called on DefaultRMAdminRequestInterceptor, which should be the last one in the chain. Check if the interceptor pipeline configuration is correct");
    }

    @VisibleForTesting
    public void setRMAdmin(ResourceManagerAdministrationProtocol rmAdmin) {
        this.rmAdminProxy = rmAdmin;
    }

    public RefreshQueuesResponse refreshQueues(RefreshQueuesRequest request) throws StandbyException, YarnException, IOException {
        return this.rmAdminProxy.refreshQueues(request);
    }

    public RefreshNodesResponse refreshNodes(RefreshNodesRequest request) throws StandbyException, YarnException, IOException {
        return this.rmAdminProxy.refreshNodes(request);
    }

    public RefreshSuperUserGroupsConfigurationResponse refreshSuperUserGroupsConfiguration(RefreshSuperUserGroupsConfigurationRequest request) throws StandbyException, YarnException, IOException {
        return this.rmAdminProxy.refreshSuperUserGroupsConfiguration(request);
    }

    public RefreshUserToGroupsMappingsResponse refreshUserToGroupsMappings(RefreshUserToGroupsMappingsRequest request) throws StandbyException, YarnException, IOException {
        return this.rmAdminProxy.refreshUserToGroupsMappings(request);
    }

    public RefreshAdminAclsResponse refreshAdminAcls(RefreshAdminAclsRequest request) throws YarnException, IOException {
        return this.rmAdminProxy.refreshAdminAcls(request);
    }

    public RefreshServiceAclsResponse refreshServiceAcls(RefreshServiceAclsRequest request) throws YarnException, IOException {
        return this.rmAdminProxy.refreshServiceAcls(request);
    }

    public UpdateNodeResourceResponse updateNodeResource(UpdateNodeResourceRequest request) throws YarnException, IOException {
        return this.rmAdminProxy.updateNodeResource(request);
    }

    public RefreshNodesResourcesResponse refreshNodesResources(RefreshNodesResourcesRequest request) throws YarnException, IOException {
        return this.rmAdminProxy.refreshNodesResources(request);
    }

    public AddToClusterNodeLabelsResponse addToClusterNodeLabels(AddToClusterNodeLabelsRequest request) throws YarnException, IOException {
        return this.rmAdminProxy.addToClusterNodeLabels(request);
    }

    public RemoveFromClusterNodeLabelsResponse removeFromClusterNodeLabels(RemoveFromClusterNodeLabelsRequest request) throws YarnException, IOException {
        return this.rmAdminProxy.removeFromClusterNodeLabels(request);
    }

    public ReplaceLabelsOnNodeResponse replaceLabelsOnNode(ReplaceLabelsOnNodeRequest request) throws YarnException, IOException {
        return this.rmAdminProxy.replaceLabelsOnNode(request);
    }

    public CheckForDecommissioningNodesResponse checkForDecommissioningNodes(CheckForDecommissioningNodesRequest checkForDecommissioningNodesRequest) throws YarnException, IOException {
        return this.rmAdminProxy.checkForDecommissioningNodes(checkForDecommissioningNodesRequest);
    }

    public RefreshClusterMaxPriorityResponse refreshClusterMaxPriority(RefreshClusterMaxPriorityRequest request) throws YarnException, IOException {
        return this.rmAdminProxy.refreshClusterMaxPriority(request);
    }

    public String[] getGroupsForUser(String userName) throws IOException {
        return this.rmAdminProxy.getGroupsForUser(userName);
    }
}

