/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.api.records;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.service.api.records.BaseResource;
import org.apache.hadoop.yarn.service.api.records.ResourceInformation;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@ApiModel(description="Resource determines the amount of resources (vcores, memory, network, etc.) usable by a container. This field determines the resource to be applied for all the containers of a component or service. The resource specified at the service (or global) level can be overriden at the component level. Only one of profile OR cpu & memory are expected. It raises a validation exception otherwise.")
public class Resource
extends BaseResource
implements Cloneable {
    private static final long serialVersionUID = -6431667797380250037L;
    private String profile = null;
    private Integer cpus = 1;
    private String memory = null;
    @JsonProperty(value="additional")
    @XmlElement(name="additional")
    private Map<String, ResourceInformation> additional = new HashMap<String, ResourceInformation>();

    public Resource profile(String profile) {
        this.profile = profile;
        return this;
    }

    @ApiModelProperty(example="null", value="Each resource profile has a unique id which is associated with a cluster-level predefined memory, cpus, etc.")
    @JsonProperty(value="profile")
    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public Resource cpus(Integer cpus) {
        this.cpus = cpus;
        return this;
    }

    @ApiModelProperty(example="null", value="Amount of vcores allocated to each container (optional but overrides cpus in profile if specified).")
    @JsonProperty(value="cpus")
    public Integer getCpus() {
        return this.cpus;
    }

    public void setCpus(Integer cpus) {
        this.cpus = cpus;
    }

    public Resource memory(String memory) {
        this.memory = memory;
        return this;
    }

    @ApiModelProperty(example="null", value="Amount of memory allocated to each container (optional but overrides memory in profile if specified). Currently accepts only an integer value and default unit is in MB.")
    @JsonProperty(value="memory")
    public String getMemory() {
        return this.memory;
    }

    public void setMemory(String memory) {
        this.memory = memory;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public long calcMemoryMB() {
        if (this.memory == null) {
            return 0L;
        }
        return Long.parseLong(this.memory);
    }

    public Resource setResourceInformations(Map<String, ResourceInformation> resourceInformations) {
        this.additional = resourceInformations;
        return this;
    }

    public Resource resourceInformations(Map<String, ResourceInformation> resourceInformations) {
        this.additional = resourceInformations;
        return this;
    }

    @ApiModelProperty(value="Map of resource name to ResourceInformation")
    @JsonProperty(value="additional")
    public Map<String, ResourceInformation> getAdditional() {
        return this.additional;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        return Objects.equals(this.profile, resource.profile) && Objects.equals(this.cpus, resource.cpus) && Objects.equals(this.memory, resource.memory) && Objects.equals(this.additional, resource.additional);
    }

    public int hashCode() {
        return Objects.hash(this.profile, this.cpus, this.memory, this.additional);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Resource {\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    cpus: ").append(this.toIndentedString(this.cpus)).append("\n");
        sb.append("    memory: ").append(this.toIndentedString(this.memory)).append("\n");
        sb.append("    additional: ").append(this.toIndentedString(this.additional)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

